import { GlobalFunctions } from "./global-functions";
export class validateSearchCriteriaFunctions {
    static isValidBsnNumber(searchQuery) {
        let validBsnFormat = /^(\d{8}|\d{9})$/;
        if (searchQuery.match(validBsnFormat) == null) {
            return false;
        }
        let j = searchQuery.length;
        let pos = 0;
        let result = 0;
        for (let i = j; i > 0; i--) {
            result += (i != 1) ? (searchQuery.charAt(pos) * i) : (searchQuery.charAt(pos) * i * -1);
            pos++;
        }
        return (result % 11 == 0);
    }
    static isValidDateNumber(searchQuery) {
        return (GlobalFunctions.validDate(new this.DateJS.parseExact(searchQuery.trim(), "ddMMyy")) || GlobalFunctions.validDate(new this.DateJS.parseExact(searchQuery.trim(), "ddMMyyyy")) || GlobalFunctions.validDate(new this.DateJS.parseExact(searchQuery.trim(), "dd-MM-yy")) || GlobalFunctions.validDate(new this.DateJS.parseExact(searchQuery.trim(), "dd-MM-yyyy")) || GlobalFunctions.validDate(new this.DateJS.parseExact(searchQuery.trim(), "dd/MM/yy")) || GlobalFunctions.validDate(new this.DateJS.parseExact(searchQuery.trim(), "dd/MM/yyyy")));
    }
    static isValidText(searchQuery) {
        let validTextFormat = /^\s*([a-zA-Z ]+)\s*$/;
        return searchQuery.match(validTextFormat) != null;
    }
    static isValidNumber(searchQuery) {
        let validNumberformat = /^\d+$/;
        return searchQuery.match(validNumberformat) != null && !validateSearchCriteriaFunctions.isValidBsnNumber(searchQuery);
    }
    static isValidCaseId(searchQuery) {
        let validcaseIdFormat = /^(z|z-|z\/)[0-9]|^\d{4}\//i;
        return searchQuery.match(validcaseIdFormat) != null;
    }
    static isValidKvkNumber(searchQuery) {
        let validKvkFormat = /^[Kk](\d{8}|\d{9})$/;
        return searchQuery.match(validKvkFormat) != null;
    }
    static isValidBranchNumber(searchQuery) {
        let validBranchNumberFormat = /^\d{12}$/;
        return searchQuery.match(validBranchNumberFormat) != null;
    }
    static isValidPersonSearchCriteria(searchQuery) {
        return validateSearchCriteriaFunctions.isValidBsnNumber(searchQuery) || validateSearchCriteriaFunctions.isValidDateNumber(searchQuery) || validateSearchCriteriaFunctions.isValidZipcodeAndHousenumber(searchQuery) || validateSearchCriteriaFunctions.isValidCombinationSearch(searchQuery) || GlobalFunctions.isValidEmailAddress(searchQuery) || validateSearchCriteriaFunctions.isValidContactnumber(searchQuery);
    }
    static isValidProductSearchCriteria(searchQuery) {
        return validateSearchCriteriaFunctions.isValidText(searchQuery);
    }
    static isValidQuestionAnswerSearchCriteria(searchQuery) {
        return validateSearchCriteriaFunctions.isValidText(searchQuery);
    }
    static isValidOrganizationSearchCriteria(searchQuery) {
        return validateSearchCriteriaFunctions.isValidText(searchQuery) || validateSearchCriteriaFunctions.isValidKvkNumber(searchQuery) || validateSearchCriteriaFunctions.isValidBranchNumber(searchQuery);
    }
    static isValidCaseSearchCriteria(searchQuery) {
        return validateSearchCriteriaFunctions.isValidCaseId(searchQuery);
    }
    static isValidAllSourceSearchCriteria(searchQuery) {
        return validateSearchCriteriaFunctions.isValidBsnNumber(searchQuery) || validateSearchCriteriaFunctions.isValidDateNumber(searchQuery) || validateSearchCriteriaFunctions.isValidText(searchQuery) || validateSearchCriteriaFunctions.isValidCaseId(searchQuery);
    }
    static isValidZipcodeAndHousenumber(searchQuery) {
        let zipcode = /^([0-9]{4}[a-z|A-Z]{2})|([0-9]{4}[ ][a-z|A-Z]{2})\b/;
        return searchQuery.match(zipcode) != null;
    }
    static isValidCombinationSearch(searchQuery) {
        let validMixedFormat = /^[A-Za-z0-9 ]+$/;
        let containsDate;
        let containSurname;
        let containEmailOrPhoneOrMobile;
        if (searchQuery.indexOf(' ') != -1) {
            let dateparts = searchQuery.split(' ', 2);
            dateparts.forEach((value, key) => {
                if (validateSearchCriteriaFunctions.isValidDateNumber(value))
                    containsDate = true;
                else if (GlobalFunctions.isValidEmailAddress(value) || validateSearchCriteriaFunctions.isValidContactnumber(value))
                    containEmailOrPhoneOrMobile = true;
                else
                    containSurname = true;
            });
        }
        return (searchQuery.match(validMixedFormat) != null && containsDate) || (containSurname && containEmailOrPhoneOrMobile);
    }
    static isValidPersonSearchCriteriaWithText(searchQuery) {
        return validateSearchCriteriaFunctions.isValidPersonSearchCriteria(searchQuery) || validateSearchCriteriaFunctions.isValidText(searchQuery);
    }
    static isValidCaseSearchCriteriaWithText(searchQuery) {
        return validateSearchCriteriaFunctions.isValidCaseId(searchQuery) || validateSearchCriteriaFunctions.isValidText(searchQuery);
    }
    static isValidDecoumentSearchCriteriaWithText(searchQuery) {
        return validateSearchCriteriaFunctions.isValidNumber(searchQuery) || validateSearchCriteriaFunctions.isValidText(searchQuery);
    }
    static isValidContactnumber(searchQuery) {
        searchQuery = searchQuery.replace(/" "/g, "");
        let validContactnumberFormat = /(^\+31|^31|^00|^0)([0-9]{9})$/;
        return searchQuery.match(validContactnumberFormat) != null;
    }
}
validateSearchCriteriaFunctions.DateJS = Date;
//# sourceMappingURL=validate-search-criteria-functions.js.map