var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from '@angular/core';
import { GlobalFunctions } from '../global-functions';
let TaskFilterPipe = class TaskFilterPipe {
    transform(tasks, query, columnName) {
        let filteredTasks = [];
        if (!GlobalFunctions.isEmpty(query) && !GlobalFunctions.isEmpty(columnName)) {
            query = query.toLowerCase();
            columnName = columnName.toLowerCase();
            tasks.forEach(task => {
                if (task) {
                    switch (columnName) {
                        case 'type':
                            {
                                if (task.ScheduledWorkType != null && task.ScheduledWorkType != undefined && query.indexOf(task.ScheduledWorkType.toLowerCase()) >= 0)
                                    filteredTasks.push(task);
                                break;
                            }
                        case 'priority':
                            {
                                if (task.Priority != null && query.indexOf(task.Priority) >= 0)
                                    filteredTasks.push(task);
                                break;
                            }
                        case 'session':
                            {
                                if (task.ScheduledWorkType == "Session" && (query.indexOf("all") >= 0 || query.indexOf(task.ObjectSourceDto.CreatedById) >= 0))
                                    filteredTasks.push(task);
                                break;
                            }
                        case 'role':
                            {
                                if ((query.indexOf("all") >= 0 || query.indexOf(task.ObjectSourceDto.CreatedById) >= 0))
                                    filteredTasks.push(task);
                                break;
                            }
                        case 'status':
                            {
                                if (task.CurrentStatus != null && task.CurrentStatus != undefined && query.indexOf(task.CurrentStatus.toString()) >= 0)
                                    filteredTasks.push(task);
                                break;
                            }
                    }
                }
            });
        }
        return filteredTasks;
    }
    ;
};
TaskFilterPipe = __decorate([
    Pipe({
        name: 'taskFilter'
    })
], TaskFilterPipe);
export { TaskFilterPipe };
//# sourceMappingURL=task-filter.pipe.js.map