var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from "@angular/core";
import { GlobalFunctions } from "../global-functions";
import { PipeHelper } from "../helper/pipe-helper";
let PersonFormattedAddressPipe = class PersonFormattedAddressPipe {
    constructor(translateService) {
        this.translateService = translateService;
    }
    transform(personDto, returnHtml = false) {
        let addressInfo = "";
        if (personDto != null) {
            let addressDto = null;
            if (!GlobalFunctions.isEmpty(personDto.ResidentialAddress) && !GlobalFunctions.isEmpty(personDto.ResidentialAddress.Address) && this.isValidAddress(personDto.ResidentialAddress.Address))
                addressDto = personDto.ResidentialAddress.Address;
            else if (!GlobalFunctions.isEmpty(personDto.CorrespondenceAddress) && !GlobalFunctions.isEmpty(personDto.CorrespondenceAddress.Address) && this.isValidAddress(personDto.CorrespondenceAddress.Address))
                addressDto = personDto.CorrespondenceAddress.Address;
            else if (!GlobalFunctions.isEmpty(personDto.RegistrationAddress) && !GlobalFunctions.isEmpty(personDto.RegistrationAddress.Address) && this.isValidAddress(personDto.RegistrationAddress.Address))
                addressDto = personDto.RegistrationAddress.Address;
            addressInfo = PipeHelper.getFormattedAddress(addressDto, returnHtml, personDto.PrivateFields);
        }
        let defaultResult = returnHtml ? "<em style='color: gray;'>" + this.translateService.instant("LBL_NO_ADDRESS_FOUND") + "</em>" : this.translateService.instant("LBL_NO_ADDRESS_FOUND");
        return addressInfo == "" ? defaultResult : addressInfo;
    }
    isValidAddress(address) {
        if (!address)
            return false;
        const addressFieldsToCheck = [address.StreetName, address.ZipCode, address.City, address.State, address.HouseNumberAddition, address.Country?.Name];
        const hasHouseNumber = address.HouseNumber && address.HouseNumber > 0;
        return addressFieldsToCheck.some(field => !GlobalFunctions.isEmpty(field)) || hasHouseNumber;
    }
};
PersonFormattedAddressPipe = __decorate([
    Pipe({ name: 'personFormattedAddress' })
], PersonFormattedAddressPipe);
export { PersonFormattedAddressPipe };
//# sourceMappingURL=person-formated-address.pipe.js.map