var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from "@angular/core";
import { GlobalFunctions } from "../global-functions";
import { PipeHelper } from "../helper/pipe-helper";
let PersonFormattedAddressWithLabelPipe = class PersonFormattedAddressWithLabelPipe {
    constructor(translateService) {
        this.translateService = translateService;
    }
    transform(personDto, returnHtml = false) {
        let addressInfo = "";
        let label = "";
        if (personDto != null) {
            personDto.IsAddressHeightSmall = true;
            let residentialAddress, registrationAddress, correspondenceAddress;
            if (personDto.ResidentialAddress != null && personDto?.ResidentialAddress?.Address != null)
                residentialAddress = PipeHelper.getFormattedAddress(personDto?.ResidentialAddress?.Address, returnHtml, personDto.PrivateFields);
            if (personDto.CorrespondenceAddress != null && personDto?.CorrespondenceAddress?.Address != null)
                correspondenceAddress = PipeHelper.getFormattedAddress(personDto?.CorrespondenceAddress?.Address, returnHtml, personDto.PrivateFields);
            if (personDto.RegistrationAddress != null && personDto.RegistrationAddress.Address != null)
                registrationAddress = PipeHelper.getFormattedAddress(personDto?.RegistrationAddress?.Address, returnHtml, personDto.PrivateFields);
            if (residentialAddress == correspondenceAddress)
                correspondenceAddress = null;
            if (residentialAddress == registrationAddress)
                registrationAddress = null;
            if (correspondenceAddress == registrationAddress)
                correspondenceAddress = null;
            if (!GlobalFunctions.isEmpty(residentialAddress) && GlobalFunctions.isEmpty(correspondenceAddress) && GlobalFunctions.isEmpty(registrationAddress))
                addressInfo = residentialAddress;
            else {
                if (!GlobalFunctions.isEmpty(residentialAddress)) {
                    label = returnHtml ? "<b>" + this.translateService.instant("LBL_RESIDENTIAL") + ": </b>" : this.translateService.instant("LBL_RESIDENTIAL") + ":";
                    addressInfo = label + residentialAddress;
                }
                if (!GlobalFunctions.isEmpty(registrationAddress)) {
                    label = returnHtml ? "<b>" + this.translateService.instant("LBL_REGISTRATION") + ": </b>" : this.translateService.instant("LBL_REGISTRATION") + ":";
                    registrationAddress = label + registrationAddress;
                    if (!GlobalFunctions.isEmpty(addressInfo)) {
                        addressInfo = addressInfo + (returnHtml ? "<br/>" : "\n") + registrationAddress;
                        personDto.IsAddressHeightSmall = false;
                    }
                    else
                        addressInfo = registrationAddress;
                }
                if (!GlobalFunctions.isEmpty(correspondenceAddress)) {
                    label = returnHtml ? "<b>" + this.translateService.instant("LBL_CORRESPONDENCE") + ": </b>" : this.translateService.instant("LBL_CORRESPONDENCE") + ":";
                    correspondenceAddress = label + correspondenceAddress;
                    if (!GlobalFunctions.isEmpty(addressInfo)) {
                        addressInfo = addressInfo + (returnHtml ? "<br/>" : "\n") + correspondenceAddress;
                        personDto.IsAddressHeightSmall = false;
                    }
                    else
                        addressInfo = correspondenceAddress;
                }
            }
        }
        let defaultResult = returnHtml ? "<em style='color: gray;'>" + this.translateService.instant("LBL_NO_ADDRESS_FOUND") + "</em>" : "";
        return addressInfo == "" ? defaultResult : addressInfo;
    }
};
PersonFormattedAddressWithLabelPipe = __decorate([
    Pipe({ name: 'personFormattedAddressWithLabel' })
], PersonFormattedAddressWithLabelPipe);
export { PersonFormattedAddressWithLabelPipe };
//# sourceMappingURL=person-formated-address-with-label.pipe.js.map