var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from '@angular/core';
import { GlobalFunctions } from '../global-functions';
import { CommonHelper } from '../helper/common-helper';
let ParseDatePipe = class ParseDatePipe {
    constructor(datePipe) {
        this.datePipe = datePipe;
        this.dateJS = Date;
    }
    transform(date, format) {
        if (!GlobalFunctions.isEmpty(date) && new this.dateJS(date).toString('M/d/yyyy') != '1/1/1' && new this.dateJS(date).toString('dd MMM yyyy').toLowerCase() != '01 jan 0001' && new this.dateJS(date).toString('d MMM yyyy') != '1 jan 1' &&
            date !== '0001-01-01T00:00:00' && date !== '01-01-0001' && date !== '01/01/0001' && date !== '01010001') {
            date = this.datePipe.transform(date, format, "", CommonHelper.getLanguageCode());
            return GlobalFunctions.removeDotAfterMonth(date);
        }
        else
            return '';
    }
};
ParseDatePipe = __decorate([
    Pipe({ name: 'parseDate' })
], ParseDatePipe);
export { ParseDatePipe };
//# sourceMappingURL=parse-date.pipe.js.map