var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from "@angular/core";
import { BroadCastEventKeys } from "../constants";
import { GlobalFunctions } from "../global-functions";
import { PipeHelper } from "../helper/pipe-helper";
let LocalSearchFilterPipe = class LocalSearchFilterPipe {
    constructor(eventProvider, searchService) {
        this.eventProvider = eventProvider;
        this.searchService = searchService;
    }
    transform(results, query = '', fieldObj = null) {
        let filteredResults = [];
        if (results.length > 0 && query != null && query.length > 2) {
            query = query.toLowerCase();
            let field = null;
            if (!GlobalFunctions.isEmpty(fieldObj) && !GlobalFunctions.isEmpty(fieldObj.key))
                field = fieldObj.key;
            results.forEach(resultObject => {
                if (!GlobalFunctions.isEmpty(field) && field.indexOf('.') != -1) {
                    const value = GlobalFunctions.setGrammarForBaseDto(resultObject, "{" + field + "}");
                    if (!GlobalFunctions.isEmpty(value) && value.toLowerCase().indexOf(query) > -1)
                        filteredResults.push(resultObject);
                }
                else if (PipeHelper.isValueMatchingWithAnyProperty(resultObject, query, field))
                    filteredResults.push(resultObject);
            });
        }
        else {
            filteredResults = results;
            this.searchService.isLocalSearch = false;
        }
        let searchMessage = new Object();
        searchMessage.ActiveHandlers = [];
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_LOCAL_SEARCH_RESULT_LIST, { filteredResults, searchMessage });
        return filteredResults;
    }
};
LocalSearchFilterPipe = __decorate([
    Pipe({ name: 'localSearchFilter' })
], LocalSearchFilterPipe);
export { LocalSearchFilterPipe };
//# sourceMappingURL=local-search-filter.pipe.js.map