var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from "@angular/core";
let HighlightSearchPipe = class HighlightSearchPipe {
    transform(value, args) {
        if (!args || !value)
            return value;
        let detailSearchQuery = null;
        let searchQuery = null;
        if (typeof args === 'string') {
            searchQuery = args;
        }
        else {
            detailSearchQuery = args.detailSearchQuery || null;
            searchQuery = args.searchQuery || null;
        }
        // Escape special characters in the search terms
        const escapedDetailQuery = detailSearchQuery ? detailSearchQuery.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&') : null;
        const escapedSearchQuery = searchQuery ? searchQuery.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&') : null;
        // Handle highlighting for both queries
        if (escapedDetailQuery) {
            value = this.highlightTerm(value, escapedDetailQuery, "<span class='highlight-blue'>$&</span>");
        }
        if (escapedSearchQuery) {
            value = this.highlightTerm(value, escapedSearchQuery, "<mark>$&</mark>");
        }
        return value;
    }
    // Helper function to apply highlighting
    highlightTerm(value, term, wrapper) {
        const re = new RegExp(`\\b${term}\\b`, 'gi');
        // Split the value into parts separated by '<' and '>'
        const parts = value.split(/(<[^>]*>)/);
        return parts.map(part => {
            if (!part.match(/<[^>]*>/)) {
                return part.replace(re, wrapper);
            }
            else {
                return part;
            }
        }).join('');
    }
};
HighlightSearchPipe = __decorate([
    Pipe({ name: 'highlight' })
], HighlightSearchPipe);
export { HighlightSearchPipe };
//# sourceMappingURL=highlight-search.pipe.js.map