var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Pipe } from '@angular/core';
import { GlobalFunctions } from '../global-functions';
let EmployeeSearchFilterPipe = class EmployeeSearchFilterPipe {
    transform(results, query, popularNumberList) {
        let filteredResults = [];
        if (query && query.length > 1) { // Query length should be greater than 1.
            query = query.toLowerCase();
            query = GlobalFunctions.convertDiacriticToPlainText(query);
            let queryWords = query.split(" ");
            if (queryWords.length == 1) {
                results.forEach(employee => {
                    if (GlobalFunctions.isValidDiacriticSearch(employee.Surname, query) || GlobalFunctions.isValidDiacriticSearch(employee.FirstName, query))
                        filteredResults.push(employee);
                    else if (employee.Department != null && GlobalFunctions.isValidDiacriticSearch(employee.Department.Name, query))
                        filteredResults.push(employee);
                    else if (employee.IsPopular && employee.FunctionWithDepartment != null && GlobalFunctions.isValidDiacriticSearch(employee.FunctionWithDepartment, query))
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isNumber(query) && ((employee.PhoneNumber != null && employee.PhoneNumber.toLowerCase().indexOf(query) >= 0) || (employee.MobileNumber != null && employee.MobileNumber.toLowerCase().indexOf(query) >= 0)))
                        filteredResults.push(employee);
                    else if (employee.Skills != null && employee.Skills.length > 0 && jlinq.from(employee.Skills).contains("Name", query).any())
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.Note, query))
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.Function, query))
                        filteredResults.push(employee);
                    else if (employee.Location != null && employee.Location.toLowerCase().indexOf(query) >= 0)
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.StringRepresentation, query))
                        filteredResults.push(employee);
                    else if (employee.EmailAddress != null && query.indexOf('@') >= 0 && employee.EmailAddress.toLowerCase().indexOf(query) >= 0)
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.ExtraInfo, query))
                        filteredResults.push(employee);
                });
            }
            else {
                results.forEach(employee => {
                    if (GlobalFunctions.isValidDiacriticSearch(employee.Surname, queryWords[0]) && GlobalFunctions.isValidDiacriticSearch(employee.FirstName, queryWords[1]))
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.Surname, queryWords[1]) && GlobalFunctions.isValidDiacriticSearch(employee.FirstName, queryWords[0]))
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.Surname, queryWords[0]) && GlobalFunctions.isValidDiacriticSearch(employee.Function, queryWords[1]))
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.Surname, queryWords[1]) && GlobalFunctions.isValidDiacriticSearch(employee.Function, queryWords[0]))
                        filteredResults.push(employee);
                    else if ((employee.Function != null && employee.Department != null && employee.Department.Name != null) && ((GlobalFunctions.isValidDiacriticSearch(employee.Function, queryWords[0]) && GlobalFunctions.isValidDiacriticSearch(employee.Department.Name, queryWords[1])) ||
                        (GlobalFunctions.isValidDiacriticSearch(employee.Function, queryWords[1]) && GlobalFunctions.isValidDiacriticSearch(employee.Department.Name, queryWords[0]))))
                        filteredResults.push(employee);
                    else if (employee.Department != null && GlobalFunctions.isValidDiacriticSearch(employee.Department.Name, query))
                        filteredResults.push(employee);
                    else if (employee.IsPopular && employee.FunctionWithDepartment != null && GlobalFunctions.isValidDiacriticSearch(employee.FunctionWithDepartment, query))
                        filteredResults.push(employee);
                    else if (employee.Skills != null && employee.Skills.length > 0 && jlinq.from(employee.Skills).contains("Name", query).any())
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.Note, query))
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.Function, query))
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.StringRepresentation, query))
                        filteredResults.push(employee);
                    else if (employee.EmailAddress != null && query.indexOf('@') >= 0 && employee.EmailAddress.toLowerCase().indexOf(query) >= 0)
                        filteredResults.push(employee);
                    else if (GlobalFunctions.isValidDiacriticSearch(employee.ExtraInfo, query))
                        filteredResults.push(employee);
                });
            }
        }
        else if (query && query.length === 1 && query.startsWith('_'))
            filteredResults = popularNumberList;
        else
            filteredResults = results;
        filteredResults.forEach(item => {
            if (!GlobalFunctions.isEmpty(query))
                item['searchStatusQuery'] = query;
        });
        return filteredResults;
    }
    ;
};
EmployeeSearchFilterPipe = __decorate([
    Pipe({ name: 'employeeSearchFilter' })
], EmployeeSearchFilterPipe);
export { EmployeeSearchFilterPipe };
//# sourceMappingURL=employee-search-filter.pipe.js.map