import { GlobalFunctions } from "../global-functions";
export class PipeHelper {
    static isValueMatchingWithAnyProperty(obj, query, field) {
        if (obj) {
            for (let key in obj) {
                if (field != null && field.length > 0 && key.toUpperCase() != field)
                    continue;
                if (obj[key] != null && obj[key] !== undefined && obj[key].toString() != "") {
                    if (typeof obj[key] == "object") {
                        if (this.isValueMatchingWithAnyProperty(obj[key], query, field))
                            return true;
                    }
                    else if (typeof obj[key] != "function") {
                        let keyValue = obj[key].toString();
                        // check Date field for Local search
                        let convertedDate = new this.dateJS(keyValue);
                        if (convertedDate !== null && GlobalFunctions.validDate(convertedDate) && keyValue !== "0") {
                            let convertedQuery = GlobalFunctions.parseNonEnglishDate(query);
                            if (convertedDate.getDate() === new Date(convertedQuery).getDate() &&
                                convertedDate.getMonth() === new Date(convertedQuery).getMonth() &&
                                convertedDate.getFullYear() === new Date(convertedQuery).getFullYear()) // Compare dates
                                return true;
                        }
                        if (keyValue.toLowerCase().indexOf(query) > -1)
                            return true;
                    }
                }
            }
        }
        return false;
    }
    static getFormattedAddress(addressDto, returnHtml, privateFields = null) {
        let addressInfo = "";
        if (addressDto != null) {
            if (GlobalFunctions.isEmpty(privateFields))
                privateFields = '';
            if (!GlobalFunctions.isEmpty(addressDto.StreetName) && privateFields.indexOf('|STREETNAME|') == -1)
                addressInfo += (addressDto.StreetName + " ");
            if (!GlobalFunctions.isEmpty(addressDto.HouseNumber) && addressDto.HouseNumber != 0 && privateFields.indexOf('|HOUSENUMBER|') == -1)
                addressInfo += (addressDto.HouseNumber + " ");
            if (!GlobalFunctions.isEmpty(addressDto.HouseNumberAddition) && privateFields.indexOf('|ADJUNCT|') == -1)
                addressInfo += (addressDto.HouseNumberAddition + " ");
            if (addressInfo.length > 0 && returnHtml)
                addressInfo += "<br/>";
            if (addressDto.ZipCode != null && addressDto.ZipCode != "" && privateFields.indexOf('|ZIPCODE|') == -1)
                addressInfo += (addressDto.ZipCode + " ");
            if (addressDto.City != null && addressDto.City != "" && privateFields.indexOf('|CITY|') == -1)
                addressInfo += addressDto.City;
        }
        return addressInfo;
    }
}
PipeHelper.dateJS = Date;
//# sourceMappingURL=pipe-helper.js.map