import { JkcPanelParameters } from "src/app/core/models/common/jkc-panel-parameters";
export class JkcPanel {
    constructor(sessionNotesUIState, editedData, editMode, entitySubType, entityObject, modal = null, headerId, footerId, topSpace, leftSpace, leftSpaceWithoutSessionNote, widthValue, heightValue, maxWidth) {
        this.jkcParentPanelId = '#jkcParentPanel';
        this.jkcChildPanelId = '#JkcChildPanel';
        this.jkcViewerPanelId = '#jkcViewerPanel';
        this.jkcSuggestionPanelId = '#jkcSuggestionPanel';
        this.sessionNotesUIState = sessionNotesUIState;
        this.parameters = new JkcPanelParameters(editedData, editMode, entitySubType, entityObject, modal, headerId, footerId, topSpace, leftSpace, leftSpaceWithoutSessionNote, widthValue, heightValue, maxWidth);
    }
    expandJsPanel(panelId = null) {
        panelId = panelId == null ? this.jkcParentPanelId : panelId;
        if ($(panelId) != null && this.parameters.IsPanelExpanded)
            this.setCollapsedJsPanelStyle(panelId);
        else
            this.setExpandedJsPanelStyle(panelId);
    }
    setInitialJsPanelStyle(panelId = null) {
        panelId = panelId == null ? this.jkcParentPanelId : panelId;
        let windowHeight = $(window).height();
        let newHeight = this.parameters.HeightValue === null ? windowHeight - parseInt(this.parameters.TopSpace) - 100 : this.parameters.HeightValue;
        if (panelId == this.jkcViewerPanelId) {
            $(panelId).css({ top: this.parameters.TopSpace, left: this.parameters.LeftSpaceWithoutSessionNote, 'background-color': 'transparent', 'height': newHeight, 'width': this.parameters.WidthValue, 'max-width': this.parameters.MaxWidth });
            $(panelId).addClass('jsPanel-viewer-z-index');
        }
        else if (panelId == this.jkcSuggestionPanelId) {
            $(panelId).css({ top: this.parameters.TopSpace, left: this.parameters.LeftSpaceWithoutSessionNote, 'background-color': 'transparent', 'height': newHeight, 'width': this.parameters.WidthValue, 'max-width': this.parameters.MaxWidth });
            $(panelId).addClass('jsPanel-suggestion-z-index');
        }
        else {
            if (this.sessionNotesUIState.UIState == 1)
                $(panelId).css({ top: this.parameters.TopSpace, left: this.parameters.LeftSpace, 'background-color': 'transparent', 'height': newHeight, 'width': this.sessionNotesUIState.isSuggestionPanelOpen ? '60%' : this.parameters.WidthValue, 'max-width': this.parameters.MaxWidth });
            else
                $(panelId).css({ top: this.parameters.TopSpace, left: this.parameters.LeftSpaceWithoutSessionNote, 'background-color': 'transparent', 'height': newHeight, 'width': this.parameters.WidthValue, 'max-width': this.parameters.MaxWidth });
            $(panelId).addClass('jsPanel-z-index');
        }
        $('#' + this.parameters.HeaderId).css({ 'width': ($(panelId).width()) });
        this.parameters.IsPanelExpanded = true;
    }
    ;
    setExpandedJsPanelStyle(panelId) {
        let windowHeight = $(window).height();
        let newHeight = this.parameters.HeightValue === null ? windowHeight - parseInt(this.parameters.TopSpace) - 5 : this.parameters.HeightValue;
        if (panelId == this.jkcViewerPanelId)
            if (this.sessionNotesUIState.UIState == 1)
                $(panelId).css({ top: this.parameters.TopSpace, left: '45%', 'background-color': 'transparent', 'height': newHeight, 'width': this.parameters.WidthValue, 'max-width': this.parameters.MaxWidth });
            else
                $(panelId).css({ top: this.parameters.TopSpace, left: '70%', 'background-color': 'transparent', 'height': newHeight, 'width': this.parameters.WidthValue, 'max-width': this.parameters.MaxWidth });
        else if (this.sessionNotesUIState.UIState == 1)
            $(panelId).css({ top: this.parameters.TopSpace, left: this.parameters.LeftSpace, 'background-color': 'transparent', 'height': newHeight, 'width': this.sessionNotesUIState.isSuggestionPanelOpen ? '60%' : this.parameters.WidthValue, 'max-width': this.parameters.MaxWidth });
        else
            $(panelId).css({ top: this.parameters.TopSpace, left: this.parameters.LeftSpaceWithoutSessionNote, 'background-color': 'transparent', 'height': newHeight, 'width': 'auto', 'max-width': this.parameters.MaxWidth });
        $('#' + this.parameters.HeaderId).css({ 'width': ($(panelId).width()) });
        this.parameters.IsPanelExpanded = true;
        let panel = $(panelId);
        if (panelId == this.jkcViewerPanelId) {
            panel[0].options.dragit.containment = [0, this.sessionNotesUIState.UIState === 1 ? $('#contactSessionNotes').width() : -5, -90, 0];
            panel[0].options.resizeit.containment = [0, this.sessionNotesUIState.UIState === 1 ? $('#contactSessionNotes').width() : -5, -90, 0];
        }
        if (panelId == this.jkcParentPanelId) {
            panel[0].options.dragit.containment = [0, -5, 0, 0];
            panel[0].options.resizeit.containment = [0, -5, 0, 0];
        }
    }
    ;
    setCollapsedJsPanelStyle(panelId) {
        if (panelId == this.jkcViewerPanelId)
            $(panelId).css({ top: $(window).height() - 143 + 'px', left: '35%', 'background-color': 'transparent', 'height': '42px', 'width': '30%' });
        else {
            if (this.sessionNotesUIState.UIState == 3)
                $(panelId).css({ top: $(window).height() - 143 + 'px', left: '65%', 'background-color': 'transparent', 'height': '42px', 'width': '25%' });
            else
                $(panelId).css({ top: $(window).height() - 143 + 'px', left: '35%', 'background-color': 'transparent', 'height': '42px', 'width': '30%' });
        }
        $('#' + this.parameters.HeaderId).css({ 'width': ($(panelId).width()) });
        this.parameters.IsPanelExpanded = false;
    }
    ;
}
//# sourceMappingURL=jkc-panel-helper.js.map