import { RendererStyleFlags2 } from "@angular/core";
export class JkcDatePickerHelper {
    static setMargin(left, top, position, renderer) {
        try {
            const datepicker = document.querySelector('.mat-datepicker-content');
            renderer.setStyle(datepicker, 'margin-left', left, RendererStyleFlags2.Important);
            renderer.setStyle(datepicker, 'margin-top', top, RendererStyleFlags2.Important);
            renderer.setStyle(datepicker, 'position', position, RendererStyleFlags2.Important);
        }
        catch (e) {
            console.error(e.message);
        }
    }
    static setOverlayBackgroundColor(pickerState, renderer) {
        try {
            // picker state : datepicker is opened or closed.
            if (pickerState) {
                const overlay = document.querySelector('.cdk-overlay-container');
                //null checks before accessing the style property.
                if (overlay !== null) {
                    renderer.removeStyle(overlay, 'background-color');
                }
            }
            else {
                const datepickerOverlay = document.querySelector('.cdk-overlay-container');
                if (datepickerOverlay !== null) {
                    renderer.setStyle(datepickerOverlay, 'background-color', 'transparent', RendererStyleFlags2.Important);
                }
            }
        }
        catch (e) {
            console.error(e.message);
        }
    }
}
JkcDatePickerHelper.isDatePickerClosed = true;
//# sourceMappingURL=jkc-date-picker-helper.js.map