import { BusinessExceptionDto } from '../../core/models/common/business-exceptionDto';
import { DialogHelper } from './dialog-helper';
import { GlobalFunctions } from "../../shared/global-functions";
import { ExceptionComponent } from '../../components/common/exception/exception.component';
export class ExceptionHelper {
    static create(message, helpText, title) {
        let exception = new BusinessExceptionDto();
        exception.Message = message;
        exception.HelpText = helpText;
        exception.Title = title;
        return exception;
    }
    static getExceptionMessage(translateService, errorMessage, localiseMessage) {
        let formatedMessage = translateService.instant(errorMessage);
        formatedMessage = GlobalFunctions.formatStringValue(formatedMessage, translateService.instant(localiseMessage));
        formatedMessage = translateService.instant(formatedMessage);
        return formatedMessage;
    }
    static showException(dialog, result, reportToClient = false, message, title, zone) {
        if (!result)
            result = this.create(message, "", title);
        if (reportToClient && !this.isQueryError(result.Message)) {
            if (GlobalFunctions.isEmpty(zone))
                return DialogHelper.openDialog(dialog, ExceptionComponent, '100%', 'auto', '50vh', '45vw', result);
            else
                return zone.run(() => DialogHelper.openDialog(dialog, ExceptionComponent, '100%', 'auto', '50vh', '45vw', result));
        }
        else
            console.error(result);
    }
    static isQueryError(message = '') {
        return message.startsWith('could not insert') || message.startsWith('could not execute query');
    }
}
//# sourceMappingURL=exception-helper.js.map