export class DateHelper {
    static isDateInCurrentWeek(firstWeekDay, dateOfBirth) {
        let isValid = false;
        try {
            for (let index = 0; index < 5; index++) {
                let weeekDate = new Date();
                weeekDate.setDate(firstWeekDay.getDate() + index);
                if (weeekDate.getMonth() == dateOfBirth.getMonth() && weeekDate.getDate() == dateOfBirth.getDate()) {
                    isValid = true;
                    break;
                }
            }
        }
        catch (e) { }
        return isValid;
    }
    static getFirstDayOfWeek() {
        let currentDate = new Date();
        let day = currentDate.getDay(), diff = currentDate.getDate() - day + (day == 0 ? -6 : 1); // adjust when day is sunday
        return new Date(currentDate.setDate(diff));
    }
    static compareDateWithCurrent(dateToCompare) {
        try {
            let currentDate = new Date();
            let endDate = new Date(dateToCompare);
            currentDate.setHours(0, 0, 0, 0);
            endDate.setHours(0, 0, 0, 0);
            if (endDate.getTime() >= currentDate.getTime())
                return false;
            else
                return true;
        }
        catch (e) {
            return false;
        }
    }
    static validDate(value) {
        let isValid = false;
        if (Object.prototype.toString.call(value) === "[object Date]") {
            // it is a date
            if (isNaN(value.getTime())) { // d.valueOf() could also work
                // date is not valid
                isValid = false;
            }
            else {
                // date is valid
                isValid = true;
            }
        }
        return isValid;
    }
    ;
}
//# sourceMappingURL=date-helper.js.map