import { environment } from 'src/environments/environment';
import { LanaguageCode, Locale } from '../constants';
export class CommonHelper {
    static getLanguageCode() {
        let locale = Locale.NL_NL;
        if (navigator.language === LanaguageCode.EN_CODE || navigator.language === Locale.EN_EN)
            locale = Locale.EN_EN;
        return locale;
    }
    static getCountries() {
        return [
            "Afghanistan", "Albanië", "Algerije", "Andorra", "Angola", "Antigua en Barbuda", "Argentini",
            "Armenië", "Australië", "Azerbeidzjan", "Bahama's", "Bahrein", "Bangladesh", "Barbados", "België",
            "Belize", "Benin", "Bhutan", "Bolivia", "Bosnië en Herzegovina", "Botswana", "Brazilië", "Brunei", "Bulgarije",
            "Burkina Faso", "Burundi", "Cambodja", "Canada", "Centraal-Afrikaanse Republiek", "Chili", "China",
            "Colombia", "Comoren", "Congo-Brazzaville", "Congo-Kinshasa", "CostaRica", "Cuba", "Cyprus", "Denemarken", "Djibouti's",
            "Dominica", "Bangladesh", "Dominicaanse Republiek", "Duitsland", "Ecuador", "Egypte", "ElSalvador", "Equatoriaal-Guinea",
            "Eritrea", "Estland", "Ethiopië", "Fiji", "Filipijnen", "Finland", "Frankrijk", "Gabon", "Gambia", "Georgië",
            "Ghana", "Grenada", "Griekenland", "Guatemala", "Guinee", "Guinee-Bissau", "Guyana", "Haïti", "Honduras",
            "Hongarije", "Ierland", "IJsland", "India", "Indonesië", "Irak", "Iran",
            "Israël", "Italië", "Ivoorkust", "Jamaica", "Japan", "Jemen", "Jordanië", "Kaapverdië", "Kameroen", "Kazachstan",
            "Kenia", "Kirgizië", "Kiribati", "Koeweit", "Kroatië", "Laos", "Lesotho", "Letland", "Libanon", "Liberia", "Libië",
            "Liechtenstein-Bissau", "Litouwen", "Luxemburg", "Macedonië", "Madagaskar", "Maldiven", "Maleisië", "Mali",
            "Malta", "Marshall eilanden", "Mauritanië", "Marokko", "Mexico", "Micronesia", "Moldavië", "Monaco", "Mongolië",
            "Montenegro", "Mozambique", "Myanmar", "Namibië", "Nauru", "Nederland", "Nederlandse", "Nepal", "Nicaragua", "Nieuw-Zeeland",
            "Niger", "Nigeria", "Noord-Korea", "Noorwegen", "Oekraïne", "Oezbekistan", "Oman", "Oostenrijk", "Oost-Timor", "Pakistan",
            "Panama", "Papoea-Nieuw-Guinea", "Paraguay", "Peru", "Polen", "Portugal", "Qatar", "Roemenië",
            "Rusland", "Rwanda", "SaintKitts en Nevis", "Saint Lucia", "SaintVincent en de Grenadines", "Salomonseilanden",
            "Samoa", "San Marino", "SaoTomé en Principe", "Saoedi-Arabië", "Senegal", "Servië", "Seychellen", "SierraLeone",
            "Singapore", "Slovenië", "Slowakije", "Soedan", "Somalië", "Spanje", "SriLanka", "Suriname", "Swaziland", "Syrië",
            "Tadzjikistan", "Tanzania", "Thailand", "Togo", "Tonga", "Trinidad en Tobago", "Tsjaad", "Tsjechië", "Tunesië",
            "Turkije", "Turkmenistan", "Tuvalu", "Uruguay", "Vanuatu", "Vaticaanstad", "Venezuela", "Verenigd Koninkrijk",
            "Verenigde Arabische Emiraten", "Verenigde Staten", "Vietnam", "Zambia", "Zimbabwe", "Zuid-Afrika", "Zuid-Korea",
            "Zweden", "Zwitserland", "Abchazië", "Kosovo", "Nagorno-Karabach", "Noord-Cyprus", "Palestijnse Autoriteit",
            "Sahara", "Taiwan", "Zuid-Ossetië", "Amerikaanse Maagdeneilanden", "Amerikaans-Samoa", "Baker", "Howland",
            "Midway", "Kingman", "Navassa", "Aruba", "Bonaire", "Curaçao", "Sint Maarten", "Sint Eustatius", "Saba"
        ];
    }
    ;
    static openHelpUrl(key) {
        let url = environment.wiki_url.replace('{0}', 'en').replace('{1}', key);
        if (navigator.language.toLowerCase() === LanaguageCode.NL_CODE)
            url = environment.wiki_url.replace('{0}', 'nl').replace('{1}', key);
        window.open(url, '_blank');
    }
}
//# sourceMappingURL=common-helper.js.map