var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Directive } from '@angular/core';
let ResizeImageDirective = class ResizeImageDirective {
    constructor(elementRef, renderer) {
        this.elementRef = elementRef;
        this.renderer = renderer;
    }
    ngAfterViewInit() {
        setTimeout(() => this.resize(), 10);
    }
    resize() {
        let image = this.elementRef.nativeElement;
        let container = this.elementRef.nativeElement.parentElement;
        this.renderer.setAttribute(image, 'marginTop', '0px');
        if (image.clientHeight == 0 || image.clientWidth == 0)
            return;
        if (image.clientHeight == image.clientWidth && (image.clientHeight < container.clientHeight || image.clientWidth < container.clientWidth) || (image.clientHeight > container.clientHeight || image.clientWidth > container.clientWidth)) {
            this.renderer.setAttribute(image, 'width', container.clientWidth + "px");
            this.renderer.setAttribute(image, 'height', container.clientHeight + "px");
        }
        else if (container.clientHeight > image.clientHeight)
            this.renderer.setAttribute(image, 'marginTop', (container.clientHeight - image.clientHeight) / 2 + "px");
    }
};
ResizeImageDirective = __decorate([
    Directive({ selector: '[resizeImage]' })
], ResizeImageDirective);
export { ResizeImageDirective };
//# sourceMappingURL=resize-image.directive.js.map