var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Directive, HostListener, Input } from '@angular/core';
import { KeyCode } from 'src/app/core/enums/common-enums';
let RecordNavigationDirective = class RecordNavigationDirective {
    constructor(elementRef) {
        this.elementRef = elementRef;
        this.keyindex = -1;
    }
    click(event) {
        /* DROPDOWN */
        // handle dropdwon state and when dropdown get closed then reset keyindex value to -1 (initial index) 
        this.dropDownState = event.target.closest('.dropdown');
        if (this.dropDownState == null)
            this.keyindex = -1;
    }
    onKeyDown(event) {
        let e = event;
        this.alinks = this.elementRef.nativeElement.querySelectorAll('a');
        if (this.alinks.length > 0) {
            if (this.keyindex >= this.alinks.length)
                this.keyindex = 0;
            switch (e.key.toLocaleLowerCase()) {
                case KeyCode.Arrowdown: {
                    e.preventDefault();
                    if (this.keyindex < this.alinks.length - 1) {
                        this.keyindex++;
                        this.alinks[this.keyindex].focus();
                    }
                    break;
                }
                case KeyCode.ArrowUp: {
                    if (this.keyindex == -1)
                        this.keyindex = 0;
                    e.preventDefault();
                    if (this.keyindex >= 1) {
                        this.keyindex--;
                        this.alinks[this.keyindex].focus();
                    }
                    break;
                }
                case KeyCode.End: {
                    setTimeout(() => {
                        e.preventDefault();
                        this.keyindex = this.alinks.length - 1;
                        this.alinks[this.keyindex].focus();
                    }, 50);
                    break;
                }
                case KeyCode.Home: {
                    e.preventDefault();
                    this.keyindex = 0;
                    this.alinks[this.keyindex].focus();
                    break;
                }
                case KeyCode.Enter: {
                    if (this.keyindex == -1)
                        this.keyindex = 0;
                    e.preventDefault();
                    setTimeout(() => {
                        this.alinks[this.keyindex].click();
                    }, 0);
                    break;
                }
                case KeyCode.Space: {
                    if (this.keyindex == -1)
                        this.keyindex = 0;
                    e.preventDefault();
                    let checkbox = this.alinks[this.keyindex].parentNode.parentNode.querySelector("input[type='checkbox']");
                    if (checkbox != null)
                        checkbox.click();
                    break;
                }
            }
            e.stopPropagation();
        }
    }
};
__decorate([
    Input()
], RecordNavigationDirective.prototype, "cancelRecordNavigation", void 0);
__decorate([
    HostListener('document:click', ['$event'])
], RecordNavigationDirective.prototype, "click", null);
__decorate([
    HostListener('keydown', ['$event'])
], RecordNavigationDirective.prototype, "onKeyDown", null);
RecordNavigationDirective = __decorate([
    Directive({
        selector: '[recordNavigation]'
    })
], RecordNavigationDirective);
export { RecordNavigationDirective };
//# sourceMappingURL=record-navigation.directive.js.map