var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Directive, Input } from '@angular/core';
import { LanaguageCode } from '../constants';
import { GlobalFunctions } from '../global-functions';
let PrivateFieldDirective = class PrivateFieldDirective {
    constructor(renderer, elementRef) {
        this.renderer = renderer;
        this.elementRef = elementRef;
    }
    ngOnInit() {
        if ((GlobalFunctions.isEmpty(this.isEditMode) || this.isEditMode === "true") && !GlobalFunctions.isEmpty(this.privateField)) {
            let privateFields = this.privateField.toString().split(':');
            if (privateFields.length >= 2) {
                let isPrivate = false;
                for (let i = 1; i < privateFields.length; i++) {
                    if (privateFields[0].indexOf("|" + privateFields[i] + "|") !== -1) {
                        isPrivate = true;
                        break;
                    }
                }
                if (isPrivate) {
                    if ((GlobalFunctions.isEmpty(this.hideField) || this.hideField === "false")) {
                        this.renderer.setProperty(this.elementRef.nativeElement, "innerText", "");
                        this.renderer.setProperty(this.elementRef.nativeElement, "innerHTML", `<span class='jkcLockRed jkcSizeSmall'></span><span class='privateField'>${this.getLabel()}</span>`);
                    }
                    else
                        this.renderer.setProperty(this.elementRef.nativeElement, "outerHTML", "");
                }
            }
        }
    }
    getLabel() {
        if (navigator.language === LanaguageCode.EN_CODE)
            return 'Private field';
        else
            return 'Afgeschermd veld';
    }
};
__decorate([
    Input()
], PrivateFieldDirective.prototype, "privateField", void 0);
__decorate([
    Input()
], PrivateFieldDirective.prototype, "isEditMode", void 0);
__decorate([
    Input()
], PrivateFieldDirective.prototype, "hideField", void 0);
PrivateFieldDirective = __decorate([
    Directive({
        selector: '[privateField]'
    })
], PrivateFieldDirective);
export { PrivateFieldDirective };
//# sourceMappingURL=private-field.directive.js.map