var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Directive, SecurityContext } from '@angular/core';
let ClickableLinksDirective = class ClickableLinksDirective {
    constructor(elementRef, renderer, sanitizer) {
        this.elementRef = elementRef;
        this.renderer = renderer;
        this.sanitizer = sanitizer;
    }
    ngAfterViewInit() {
        if (this.elementRef.nativeElement.textContent) {
            const urlRegex = /((https?:\/\/)|(www\.))[^\s/$.?#].[^\s]*/gi;
            const linkClass = "link-content standard-blueLink";
            const linkedText = this.elementRef.nativeElement.textContent.replace(urlRegex, (safeURL) => {
                const url = safeURL.startsWith("www.") ? `http://${safeURL}` : safeURL;
                const sanitizedUrl = this.sanitizer.sanitize(SecurityContext.URL, url);
                return `<a href="${sanitizedUrl}" target="_blank" rel="noopener noreferrer" class="${linkClass}" style="text-decoration: underline;">${safeURL}</a>`;
            });
            this.renderer.setProperty(this.elementRef.nativeElement, "innerHTML", linkedText);
        }
    }
};
ClickableLinksDirective = __decorate([
    Directive({
        selector: '[clickableLinks]'
    })
], ClickableLinksDirective);
export { ClickableLinksDirective };
//# sourceMappingURL=clickable-links.directive.js.map