var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Directive } from '@angular/core';
import { ContactSessionNotesUIState } from 'src/app/core/enums/common-enums';
let CenterAlignDirective = class CenterAlignDirective {
    constructor(elementRef, sessionManager) {
        this.elementRef = elementRef;
        this.sessionManager = sessionManager;
    }
    ngOnInit() {
        this.adjustDialogAlignment();
    }
    adjustDialogAlignment() {
        let windowWidth = $(window).width();
        let elementWidth = this.elementRef.nativeElement.clientWidth;
        let contactSessionNotesWidth = this.sessionManager.contactSessionNotesState.UIState == ContactSessionNotesUIState.Pinned ? $("#contactSessionNotes").width() : 0;
        if (this.sessionManager.contactSessionNotesState.isSuggestionPanelOpen)
            contactSessionNotesWidth = contactSessionNotesWidth + $("#suggestionPanel").width();
        let leftMargin = ((windowWidth - elementWidth - contactSessionNotesWidth) / 2);
        this.elementRef.nativeElement.style.left = leftMargin > 0 ? ((windowWidth - elementWidth - contactSessionNotesWidth) / 2) + "px" : "2%";
    }
};
CenterAlignDirective = __decorate([
    Directive({
        selector: '[centerAlign]'
    })
], CenterAlignDirective);
export { CenterAlignDirective };
//# sourceMappingURL=center-align.directive.js.map