var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseSearchResultComponent } from '../../components/common/base-search-result.component';
import { RecordSelection } from '../../core/enums/common-enums';
import { SearchResultSource } from '../../core/enums/search-result-source.enum';
import { Menu } from '../../core/models/common/menu';
import { BroadCastEventKeys, Parameters, RoutePath, SideMenuItem } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
let SearchResultComponent = class SearchResultComponent extends BaseSearchResultComponent {
    constructor(zone, router, dialog, changeDetectorRef, viewContainerRef, sortManager, searchService, eventProvider, activatedRoute, sessionManager, translateService, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe) {
        super(translateService, changeDetectorRef, sessionManager, router, activatedRoute, eventProvider, sortManager, applicationSettingManager, employeeService, formatManager, cacheManager, integrationSettingManager, datePipe, searchService);
        this.zone = zone;
        this.router = router;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.sortManager = sortManager;
        this.searchService = searchService;
        this.eventProvider = eventProvider;
        this.activatedRoute = activatedRoute;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.employeeService = employeeService;
        this.formatManager = formatManager;
        this.cacheManager = cacheManager;
        this.integrationSettingManager = integrationSettingManager;
        this.datePipe = datePipe;
        this.showSideMenu = false;
        this.menu = new Menu();
        this.searchStatusQuery = GlobalFunctions.isEmpty(this.searchService.selectedSearchOption?.searchQuery) ? '' : this.searchService.selectedSearchOption?.searchQuery;
        this.localSearchFilterText = '';
        this.single = RecordSelection.Single;
        this.timeoutIds = [];
        if (!router.url.includes(RoutePath.DASHBOARD))
            this.showSideMenu = true;
        this.sessionManager.showLocalSearch = true;
        this.sessionManager.showMenuOptions = false;
        this.subs.sink = this.activatedRoute.params.subscribe(params => {
            this.type = params.domain;
            this.subType = params.subType;
        });
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_VIEW).subscribe(parameters => {
            this.resetMenu(parameters.domain);
            this.searchStatusQuery = parameters.searchQuery;
        });
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_SEARCH_RESULTS).subscribe(searchQuery => this.searchStatusQuery = searchQuery);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.LOCAL_SEARCH_TEXT_CHANGE).subscribe(localSearchFilterText => this.localSearchFilterText = localSearchFilterText);
    }
    ngOnInit() {
        if (this.router.url.includes(`${RoutePath.DASHBOARD}/${RoutePath.LIST_PATH}`))
            this.sourceOfSearch = SearchResultSource.Dashboard;
        else if (this.router.url.includes(RoutePath.LIST_PATH) && this.searchService.advancedSearchOption)
            this.sourceOfSearch = SearchResultSource.Advanced;
        else if (this.router.url.includes(RoutePath.LIST_PATH) && !this.searchService.advancedSearchOption)
            this.sourceOfSearch = SearchResultSource.Fulltext;
        if (!this.router.url.includes(RoutePath.DASHBOARD))
            this.loadSideMenu();
        this.timeoutIds.push(setTimeout(() => this.resize(), 100));
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.sessionManager.showLocalSearch = false;
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    loadSideMenu(resultcount = 0) {
        this.menu.addOrUpdateMenuItem(resultcount, this.type, this.translateService.instant("LBL_" + this.type.toUpperCase() + "S"), true, true);
    }
    updateSideMenuCount(count) {
        this.loadSideMenu(count);
        this.changeDetectorRef.detectChanges();
    }
    updateSideMenu(menu) {
        this.menu = menu;
        this.changeDetectorRef.detectChanges();
    }
    selectMenuItem(menuItem, index) {
        this.localSearchFilterText = (index == 0 ? '' : '_' + menuItem.contentType);
    }
    resetMenu(domain) {
        this.menu = new Menu();
        if (!this.router.url.includes(RoutePath.DASHBOARD))
            this.menu.addOrUpdateMenuItem(0, domain, this.translateService.instant("LBL_" + domain.toUpperCase() + "S"), true, true);
    }
    navigateToDetail(gridObject) {
        this.sessionManager.selectedEntity = gridObject;
        switch (this.type) {
            case SideMenuItem.TASK:
                this.sessionManager.selectedEntity = gridObject.ObjectSourceDto;
                this.zone.run(() => this.router.navigate([RoutePath.DETAIL_PATH, gridObject.ScheduledWorkType.toLowerCase(), gridObject.Id]));
                break;
            case SideMenuItem.TICKET:
                this.zone.run(() => this.router.navigate([RoutePath.DETAIL_PATH, this.type, gridObject.Id]));
                break;
            case SideMenuItem.THEME:
                this.zone.run(() => this.router.navigate([RoutePath.DETAIL_PATH, Parameters.THEME]));
                break;
            case SideMenuItem.SOCIAL_MEDIA:
                this.zone.run(() => {
                    if (gridObject.Type.toLowerCase() == "twitter")
                        this.router.navigate([RoutePath.DETAIL_PATH, "twitter"]);
                    else if (gridObject.Type.toLowerCase() == "facebook")
                        this.router.navigate([RoutePath.DETAIL_PATH, "facebook"]);
                    else if (gridObject.Type.toLowerCase() == "whatsapp")
                        this.router.navigate([RoutePath.DETAIL_PATH, "whatsapp"]);
                });
                break;
            default:
                this.zone.run(() => this.router.navigate([RoutePath.DETAIL_PATH, this.type]));
                break;
        }
    }
    resize() {
        GlobalFunctions.resizejkcBootstrapTable();
    }
};
SearchResultComponent = __decorate([
    Component({
        selector: 'search-result',
        templateUrl: './search-result.component.html',
        styleUrls: ['./search-result.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], SearchResultComponent);
export { SearchResultComponent };
//# sourceMappingURL=search-result.component.js.map