var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { DashboardWebtileType } from '../../core/models/dashboard/dashboard-web-tile-type';
import { BroadCastEventKeys } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
let X2JS = require('x2js');
let OverviewComponent = class OverviewComponent {
    constructor(taskService, eventProvider, ticketService, sessionManager, translateService, socialMediaService, userSettingManager, contactHistoryService, applicationSettingManager) {
        this.taskService = taskService;
        this.eventProvider = eventProvider;
        this.ticketService = ticketService;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.socialMediaService = socialMediaService;
        this.userSettingManager = userSettingManager;
        this.contactHistoryService = contactHistoryService;
        this.applicationSettingManager = applicationSettingManager;
        this.dashboardWebparts = [];
        this.dashboardWebTiles = [];
        this.dashboardTilePerRow = 4;
        this.selectedDashboardId = null;
        this.dashboardWebtileType = new DashboardWebtileType();
        this.dashboard = null;
        this.fetchTaskStatisticResponse = this.fetchTaskStatisticResponse.bind(this);
        this.fetchTicketStatisticResponse = this.fetchTicketStatisticResponse.bind(this);
        this.fetchContactStatisticResponse = this.fetchContactStatisticResponse.bind(this);
        this.fetchSocialMediaStatisticResponse = this.fetchSocialMediaStatisticResponse.bind(this);
    }
    ngOnInit() {
        if (this.applicationSettingManager.dashboardSetting.dashboardList.length > 0) {
            const webparts = this.refreshDashboard();
            if (!this.userSettingManager.isUserSettingsCached && !this.sessionManager.overviewSubSinkInitialized)
                this.sessionManager.overviewSubSink.sink = this.userSettingManager.cacheUserSetting(GlobalFunctions.getLoggedInUserId()).subscribe(() => this.applyOrdering(webparts));
            else
                this.applyOrdering(webparts);
            if (!this.sessionManager.overviewSubSinkInitialized) {
                this.fetchStatistics();
                this.sessionManager.overviewSubSink.sink = this.eventProvider.event(BroadCastEventKeys.REFRESH_DASHBOARD).subscribe(() => {
                    this.applyOrdering(this.refreshDashboard());
                    this.fetchStatistics();
                });
                this.sessionManager.overviewSubSink.sink = this.eventProvider.event(BroadCastEventKeys.FETCH_TASK_STATISTIC).subscribe(() => this.taskService.fetchStatistic(this.fetchTaskStatisticResponse));
                this.sessionManager.overviewSubSink.sink = this.eventProvider.event(BroadCastEventKeys.FETCH_TICKET_STATISTIC).subscribe(() => this.ticketService.fetchStatistic(this.fetchTicketStatisticResponse));
                this.sessionManager.overviewSubSink.sink = this.eventProvider.event(BroadCastEventKeys.FETCH_CONTACT_STATISTIC).subscribe(() => this.contactHistoryService.fetchStatistic(this.fetchContactStatisticResponse));
                this.sessionManager.overviewSubSink.sink = this.eventProvider.event(BroadCastEventKeys.FETCH_SOCIAL_MEDIA_STATISTIC).subscribe(() => this.socialMediaService.fetchStatistic(this.fetchSocialMediaStatisticResponse));
                this.sessionManager.overviewSubSink.sink = this.eventProvider.event(BroadCastEventKeys.FETCH_SPECIFIC_STATISTIC).subscribe(response => this.fetchSpecificStatisticResponse(response));
                this.sessionManager.overviewSubSinkInitialized = true;
            }
        }
    }
    refreshDashboard() {
        if (this.sessionManager.selectedRole != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedRole.Id))
            this.dashboard = this.applicationSettingManager.dashboardSetting.searchByRoleId(this.sessionManager.selectedRole.Id);
        if (!this.dashboard)
            this.dashboard = this.applicationSettingManager.dashboardSetting.getDefaultDashboard();
        let webparts = [];
        if (this.dashboard) {
            webparts = this.dashboard.Webparts;
            this.dashboardWebTiles = this.dashboard.Webtiles;
            this.dashboardTilePerRow = this.dashboard.PerRowTiles;
            this.selectedDashboardId = this.dashboard.Id.toUpperCase();
            this.dashboardWebtileType = this.dashboard.WebtileType;
            let favouriteWebPart = jlinq.from(webparts).starts("Type", "MyFavourite").first();
            this.sessionManager.isFavouriteEnabled = (favouriteWebPart == null || favouriteWebPart == undefined) ? false : true;
        }
        return webparts;
    }
    applyOrdering(tempDashboardItems) {
        let sequenceSettings = this.fetchDashboardItemSequenceSettings();
        if (sequenceSettings) {
            for (let index = 0; index < sequenceSettings.DASHBOARDITEMLIST.DASHBOARDITEM.length; index++) {
                for (let subIndex = 0; subIndex < tempDashboardItems.length; subIndex++) {
                    if (sequenceSettings.DASHBOARDITEMLIST.DASHBOARDITEM[index]._ID == tempDashboardItems[subIndex].Id) {
                        tempDashboardItems[subIndex].Order = parseInt(sequenceSettings.DASHBOARDITEMLIST.DASHBOARDITEM[index]._ORDER);
                        break;
                    }
                }
            }
        }
        tempDashboardItems.sort((x, y) => x.Order - y.Order);
        this.dashboardWebparts = tempDashboardItems;
    }
    ;
    fetchDashboardItemSequenceSettings() {
        let jsonObj = null;
        try {
            let xmlText = this.userSettingManager.getUserSettingValueByKey("USERDASHBOARDITEMSEQUENCE_" + this.selectedDashboardId);
            if (!GlobalFunctions.isEmpty(xmlText)) {
                let x2js = new X2JS();
                jsonObj = x2js.xml2js(xmlText);
            }
        }
        catch (e) {
            console.error(e);
        }
        return jsonObj;
    }
    fetchStatistics() {
        if (this.dashboardWebTiles.length > 0) {
            if (this.dashboardWebtileType.Task.length > 0)
                this.taskService.connect().then(() => this.taskService.fetchStatistic(this.fetchTaskStatisticResponse));
            if (this.dashboardWebtileType.Ticket.length > 0)
                this.ticketService.connect().then(() => this.ticketService.fetchStatistic(this.fetchTicketStatisticResponse));
            if (this.sessionManager.isSocialMediaFeatureEnabled && this.dashboardWebtileType.Social.length > 0)
                this.socialMediaService.connect().then(() => this.socialMediaService.fetchStatistic(this.fetchSocialMediaStatisticResponse));
            if (this.dashboardWebtileType.Contact.length > 0)
                this.contactHistoryService.connect().then(() => this.contactHistoryService.fetchStatistic(this.fetchContactStatisticResponse));
        }
    }
    fetchTaskStatisticResponse(response) {
        if (response) {
            this.setStatisticTile("OPENTASKFORME", response.OpenedTaskOnMyName);
            this.setStatisticTile("OPENTASKFORROLE", response.OpenedTaskOnMyRole);
            this.setStatisticTile("OPENTASKFORDEPARTMENT", response.OpenedTaskOnMyDepartment);
            this.setStatisticTile("CREATEDTASKBYME", response.CreatedTaskByMe);
            this.setStatisticTile("CREATEDTASKBYROLE", response.CreatedTaskByRole);
            this.setStatisticTile("CREATEDTASKBYDEPARTMENT", response.CreatedTaskByDepartment);
        }
    }
    ;
    fetchTicketStatisticResponse(response) {
        if (response) {
            this.setStatisticTile("OPENTICKETFORME", response.OpenedTicketOnMyName);
            this.setStatisticTile("OPENTICKETFORDEPARTMENT", response.OpenedTicketOnMyDepartment);
            this.setStatisticTile("CREATEDTICKETBYME", response.CreatedTicketByMe);
            this.setStatisticTile("CREATEDTICKETBYDEPARTMENT", response.CreatedTicketByDepartment);
            this.setStatisticTile("HANDLEDTICKETBYME", response.HandledTicketByMe);
            this.setStatisticTile("HANDLEDTICKETBYDEPARTMENT", response.HandledTicketByDepartment);
        }
    }
    fetchSocialMediaStatisticResponse(response) {
        if (response) {
            this.setStatisticTile("INPROGRESSSOCIALMEDIABYME", response.InProgressSocialMediaByMe);
            this.setStatisticTile("INPROGRESSSOCIALMEDIABYDEPARTMENT", response.InProgressSocialMediaByDepartment);
        }
    }
    fetchContactStatisticResponse(response) {
        if (response) {
            this.setStatisticTile("HANDLEDTASKBYME", response.HandledTaskByMe);
            this.setStatisticTile("HANDLEDTASKBYROLE", response.HandledTaskByRole);
            this.setStatisticTile("HANDLEDTASKBYDEPARTMENT", response.HandledTaskByDepartment);
            this.setStatisticTile("HANDLEDSOCIALMEDIABYME", response.HandledSocialMediaByMe);
            this.setStatisticTile("HANDLEDSOCIALMEDIABYDEPARTMENT", response.HandledSocialMediaByDepartment);
            this.setStatisticTile("HANDLEDEMAILBYME", response.HandledEmailByMe);
            this.setStatisticTile("CONTACTBYME", response.HandledContactByMe);
            this.setStatisticTile("CONTACTBYDEPARTMENT", response.HandledContactByDepartment);
            this.setStatisticTile("CONTACTBYROLE", response.HandledContactByRole);
            this.setStatisticTile("CONTACTBYALL", response.HandledContactByAll);
        }
    }
    fetchSpecificStatisticResponse(response) {
        this.setStatisticTile(response.Type, response);
    }
    setStatisticTile(type, response) {
        if (response) {
            let webTile = jlinq.from(this.dashboardWebTiles).starts("Type", type).first();
            if (webTile) {
                webTile.Count = response.TotalCount;
                if (webTile.Count > 0 && response.StatisticItems?.length > 0) {
                    let typeText = '', tooltipText = '';
                    for (let statisticItem of response.StatisticItems) {
                        typeText = this.translateService.instant("LBL_" + statisticItem.Type.toUpperCase());
                        if (typeText.indexOf('_') !== -1)
                            typeText = statisticItem.Type;
                        tooltipText = tooltipText + typeText + ": " + statisticItem.Count + "\n";
                    }
                    webTile.TooltipText = tooltipText;
                }
                else
                    webTile.TooltipText = response.TooltipText;
                this.applicationSettingManager.dashboardSetting.updateWebtiledata(this.dashboard.Id, webTile);
            }
        }
    }
};
OverviewComponent = __decorate([
    Component({
        selector: 'overview',
        templateUrl: './overview.component.html',
        styleUrls: ['./overview.component.scss']
    })
], OverviewComponent);
export { OverviewComponent };
//# sourceMappingURL=overview.component.js.map