var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, ViewChild } from '@angular/core';
import { SubSink } from 'subsink';
import { environment } from '../../../environments/environment';
import { BaseComponent } from '../../components/base-component';
import { AuthenticationType } from '../../core/enums/common-enums';
import { EmployeeStatus } from '../../core/models/common/employee-status';
import { BroadCastEventKeys, LocalStorageKey, RoutePath } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
let LoginComponent = class LoginComponent extends BaseComponent {
    constructor(translateService, router, zone, dialog, changeDetectorRef, userService, sessionManager, compressionService, viewContainerRef, appManager, eventProvider) {
        super(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef);
        this.translateService = translateService;
        this.router = router;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.userService = userService;
        this.sessionManager = sessionManager;
        this.compressionService = compressionService;
        this.viewContainerRef = viewContainerRef;
        this.appManager = appManager;
        this.eventProvider = eventProvider;
        this.showProgressBar = false;
        this.rememberMe = false;
        this.userPassword = '';
        this.username = '';
        this.isError = false;
        this.loginInfo = '';
        this.loginError = '';
        this.enable2FALogin = false;
        this.current2FAStep = 0;
        this.emailAddress = '';
        this.otpCode = '';
        this.isCookieCredentials = false;
        this.isSingleSignOn = false;
        this.authenticationResult = null;
        this.subs = new SubSink();
        this.loginResponse = this.loginResponse.bind(this);
        this.sendOtpResponse = this.sendOtpResponse.bind(this);
        this.verifyOtpResponse = this.verifyOtpResponse.bind(this);
        this.setUpdateSearchStatus = this.setUpdateSearchStatus.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.LOGOUT).subscribe(() => this.logout());
    }
    ngOnInit() {
        if (GlobalFunctions.getCookie(LocalStorageKey.SESSION_TOKEN))
            this.sessionManager.isAutoLogin = true;
        this.handleServerEvents();
        this.refillRemberedValue();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    showErrorMessage(messageKey) {
        this.isError = true;
        this.loginError = this.translateService.instant(messageKey);
        this.changeDetectorRef.detectChanges();
    }
    handleServerEvents() {
        this.userService.connect().then(() => this.getAuthenticationMode());
    }
    loginUser() {
        this.showProgressBar = true;
        if (!GlobalFunctions.isEmpty(this.username) && !GlobalFunctions.isEmpty(this.userPassword))
            this.userService.connect().then(() => {
                this.userService.search(this.username, GlobalFunctions.encryptOrDecryptUsingXOR(this.userPassword), this.isCookieCredentials, this.isSingleSignOn, this.loginResponse, this.setUpdateSearchStatus);
                this.isSingleSignOn = false;
            });
        else {
            this.showErrorMessage('LBL_EMPTY_LOGIN_CREDENTIALS_ERROR');
            this.showProgressBar = false;
        }
        this.changeDetectorRef.detectChanges();
    }
    loginResponse(result) {
        if (result?.Result == 0) {
            this.authenticationResult = result;
            this.showProgressBar = false;
            if (this.isValidFor2FAAuthentication(result))
                this.activate2FAAuthentication();
            else
                this.authenticate(result);
        }
    }
    setUpdateSearchStatus() {
        this.showProgressBar = false;
        if (this.authenticationResult?.Result != 0) {
            if (this.authenticationResult?.Result == 2)
                this.showErrorMessage('LBL_APPLICATION_ACCESS_DENIED');
            else
                this.showErrorMessage('LBL_INVALID_LOGIN_CREDENTIALS_ERROR');
        }
        this.username = '';
        this.userPassword = '';
        this.changeDetectorRef.detectChanges();
    }
    authenticate(result) {
        this.cacheUserData(result);
        if (GlobalFunctions.isEmpty(localStorage.getItem(LocalStorageKey.USER_AUTHENTICATED))) {
            localStorage.setItem(LocalStorageKey.USER_AUTHENTICATED, 'true');
            if (this.rememberMe)
                this.saveCredentialsInCookie(result);
            else
                GlobalFunctions.setCookie(LocalStorageKey.KCS_REMEMBER_ME, this.rememberMe);
        }
        if (this.router.url.includes(RoutePath.LOGIN)) {
            localStorage.setItem(LocalStorageKey.APP_INIT_VIEW, RoutePath.LOGIN);
            this.navigate('/' + RoutePath.LOADING, true);
        }
    }
    tryLoginUsingCookieCredentials() {
        if (GlobalFunctions.getCookie(LocalStorageKey.KCS_USERNAME) && GlobalFunctions.getCookie(LocalStorageKey.KCS_PASSWORD)) {
            this.username = GlobalFunctions.getCookie(LocalStorageKey.KCS_USERNAME);
            this.userPassword = GlobalFunctions.getCookie(LocalStorageKey.KCS_PASSWORD);
            this.isCookieCredentials = true;
            this.isSingleSignOn = false;
            this.loginUser();
        }
        else {
            const existingCookie = JSON.parse(GlobalFunctions.getCookie(LocalStorageKey.SESSION_TOKEN));
            if (existingCookie) {
                this.username = existingCookie.LogOnName;
                this.userPassword = " ";
                this.isSingleSignOn = false;
                this.loginUser();
            }
        }
    }
    saveCredentialsInCookie(result) {
        GlobalFunctions.setCookie(LocalStorageKey.KCS_USERNAME, result.LogOnName);
        GlobalFunctions.setCookie(LocalStorageKey.KCS_PASSWORD, result.Password);
        GlobalFunctions.setCookie(LocalStorageKey.KCS_REMEMBER_ME, this.rememberMe);
        GlobalFunctions.setCookie(LocalStorageKey.KCS_USERLOGON_TYPE, result.LogOnType);
        GlobalFunctions.setCookie(LocalStorageKey.KCS_USERAUTH_TYPE, this.sessionManager.authenticationType);
    }
    refillRemberedValue() {
        this.username = GlobalFunctions.getCookie(LocalStorageKey.KCS_USERNAME);
        this.userPassword = GlobalFunctions.getCookie(LocalStorageKey.KCS_PASSWORD);
        this.rememberMe = JSON.parse(GlobalFunctions.getCookie(LocalStorageKey.KCS_REMEMBER_ME));
    }
    cacheUserData(result) {
        this.sessionManager.isValiduser = true;
        this.sessionManager.userLogOnTypeOption = result.LogOnType;
        if (this.sessionManager.employeeStatus == null)
            this.sessionManager.employeeStatus = new EmployeeStatus();
        this.sessionManager.employeeStatus.loggedInUserTime = GlobalFunctions.getCurrentDateAndTime();
        result.PrivilegeData = this.compressionService.decompressFromUTF16(result.PrivilegeData);
        if (result.PrivilegeData && result.PrivilegeData[0] === '{')
            GlobalFunctions.setPrivilegeData(JSON.parse(result.PrivilegeData), this.sessionManager, this.translateService);
    }
    getAuthenticationMode() {
        if (!this.sessionManager.isLoggedOut) {
            this.sessionManager.isSSOLogout = this.getSSOLogoutState();
            return $.ajax({
                type: "GET",
                async: false,
                url: environment.general_config + "Blank.aspx?appsettingkey=EnableSSO",
                success: value => {
                    let data = value.split('|');
                    if (data != null && data.length > 0 && data[0].toLowerCase() == 'true') {
                        this.isCookieCredentials = false;
                        this.isSingleSignOn = true;
                        if (data.length > 1 && data[1] != undefined) {
                            this.username = data[1];
                            this.userPassword = " ";
                            this.sessionManager.authenticationType = AuthenticationType.SSO;
                            if (this.sessionManager.isSSOLogout) {
                                this.sessionManager.isSSOLogout = false;
                                GlobalFunctions.removeCookie(LocalStorageKey.SSO_LOGOUT);
                            }
                            else
                                this.loginUser();
                        }
                        else {
                            if (this.sessionManager.isSSOLogout) {
                                this.sessionManager.isSSOLogout = false;
                                GlobalFunctions.removeCookie(LocalStorageKey.SSO_LOGOUT);
                            }
                            else
                                this.tryLoginUsingCookieCredentials();
                        }
                    }
                    else {
                        $.ajax({
                            type: "GET",
                            async: false,
                            url: environment.general_config + "Blank.aspx?appsettingkey=EnableAdfs",
                            success: value => {
                                let data = value.split('|');
                                if (data != null && data.length > 0 && data[0].toLowerCase() === 'true') {
                                    this.isCookieCredentials = false;
                                    this.isSingleSignOn = true;
                                    if (data.length > 1 && data[1] != undefined) {
                                        this.username = data[1].replace(/ /g, '+');
                                        this.userPassword = " ";
                                        this.sessionManager.authenticationType = AuthenticationType.ADFS;
                                        if (this.sessionManager.isSSOLogout) {
                                            this.sessionManager.isSSOLogout = false;
                                            GlobalFunctions.removeCookie(LocalStorageKey.SSO_LOGOUT);
                                        }
                                        else
                                            this.loginUser();
                                    }
                                    else if (this.sessionManager.isSSOLogout) {
                                        this.sessionManager.isSSOLogout = false;
                                        GlobalFunctions.removeCookie(LocalStorageKey.SSO_LOGOUT);
                                    }
                                    else
                                        this.tryLoginUsingCookieCredentials();
                                }
                                else {
                                    $.ajax({
                                        type: "GET",
                                        async: false,
                                        url: environment.general_config + "Blank.aspx?appsettingkey=EnableOidc",
                                        success: value => {
                                            let data = value.split('|');
                                            if (data != null && data.length > 0 && data[0].toLowerCase() == 'true') {
                                                this.isCookieCredentials = false;
                                                this.isSingleSignOn = true;
                                                if (data.length > 1 && data[1] != undefined) {
                                                    this.username = data[1].replace(/ /g, '+');
                                                    this.userPassword = " ";
                                                    this.sessionManager.authenticationType = AuthenticationType.OIDC;
                                                    this.loginUser();
                                                }
                                                else
                                                    this.tryLoginUsingCookieCredentials();
                                            }
                                            else {
                                                $.ajax({
                                                    type: "GET",
                                                    async: false,
                                                    url: environment.general_config + "Blank.aspx?appsettingkey=EnableSaml2",
                                                    success: value => {
                                                        let data = value.split('|');
                                                        if (data != null && data.length > 0 && data[0].toLowerCase() == 'true') {
                                                            this.isCookieCredentials = false;
                                                            this.isSingleSignOn = true;
                                                            if (data.length > 1 && data[1] != undefined) {
                                                                this.username = data[1].replace(/ /g, '+');
                                                                this.userPassword = " ";
                                                                this.sessionManager.authenticationType = AuthenticationType.SAML2;
                                                                this.loginUser();
                                                            }
                                                            else
                                                                this.tryLoginUsingCookieCredentials();
                                                        }
                                                        else
                                                            this.tryLoginUsingCookieCredentials();
                                                    }
                                                });
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            });
        }
    }
    getSSOLogoutState() {
        return GlobalFunctions.getCookie(LocalStorageKey.SSO_LOGOUT) != undefined && GlobalFunctions.getCookie(LocalStorageKey.SSO_LOGOUT) == "true";
    }
    isValidFor2FAAuthentication(result) {
        return (result.LogOnType == 2 || result.LogOnType == 3) && GlobalFunctions.getCookie(LocalStorageKey.KCS_USER2FA) == undefined;
    }
    activate2FAAuthentication() {
        this.enable2FALogin = true;
        this.current2FAStep = 1;
        this.emailAddress = "";
        this.otpCode = "";
        this.loginError = "";
        this.loginInfo = "";
        this.showProgressBar = false;
        this.sessionManager.isAutoLogin = false;
        this.changeDetectorRef.detectChanges();
    }
    sendOtp() {
        if (GlobalFunctions.isEmpty(this.emailAddress))
            this.loginError = this.translateService.instant("LBL_MESSAGE_ENTER_EMAIL");
        else if (this.form.controls.emailAddressTextBox.errors?.pattern)
            this.loginError = this.translateService.instant("LBL_MESSAGE_ENTER_DECOS_EMAIL");
        else {
            this.loginError = "";
            this.loginInfo = this.translateService.instant("LBL_MESSAGE_SENDING_OTP");
            this.userService.sendOtp(this.emailAddress, this.sendOtpResponse);
            this.showProgressBar = true;
            this.disabledEmailOptions(true);
        }
        this.changeDetectorRef.detectChanges();
    }
    disabledEmailOptions(disabled) {
        $("#emailAddressTextBox").prop("disabled", disabled);
        $("#2FALoginEmail").prop("disabled", disabled);
        $("#2FALogout").prop("disabled", disabled);
        this.changeDetectorRef.detectChanges();
    }
    sendOtpResponse(response) {
        this.disabledEmailOptions(false);
        this.showProgressBar = false;
        this.loginInfo = "";
        if (response.Result == 0) {
            this.loginError = "";
            this.otpCode = "";
            this.current2FAStep = 2;
        }
        else
            this.loginError = this.translateService.instant("LBL_MESSAGE_FAIL_SEND_OTP");
        this.changeDetectorRef.detectChanges();
    }
    verifyOTPCode() {
        if (GlobalFunctions.isEmpty(this.otpCode))
            this.loginError = this.translateService.instant("LBL_MESSAGE_ENTER_OTP");
        else {
            this.loginError = "";
            this.loginInfo = this.translateService.instant("LBL_MESSAGE_VERIFY_OTP");
            this.userService.verifyOtp(this.emailAddress, this.otpCode, this.verifyOtpResponse);
            this.showProgressBar = true;
            this.disabledOptOptions(true);
            this.changeDetectorRef.detectChanges();
        }
    }
    disabledOptOptions(disabled) {
        $("#codeTextBox").prop("disabled", disabled);
        $("#2FALoginOTPCode").prop("disabled", disabled);
        $("#2FALoginBack").prop("disabled", disabled);
        this.changeDetectorRef.detectChanges();
    }
    verifyOtpResponse(response) {
        this.disabledOptOptions(false);
        this.showProgressBar = false;
        this.loginInfo = "";
        if (response.Result == 0) {
            this.loginError = "";
            GlobalFunctions.setCookie(LocalStorageKey.KCS_USER2FA, "true");
            this.authenticate(this.authenticationResult);
        }
        else if (response.Result == 3)
            this.loginError = this.translateService.instant("LBL_MESSAGE_INVALID_OTP");
        else
            this.loginError = this.translateService.instant("LBL_MESSAGE_FAIL_VALIDATE_OTP");
        this.changeDetectorRef.detectChanges();
    }
    backToEmail() {
        this.current2FAStep = 1;
        this.loginError = "";
        this.loginInfo = "";
        this.changeDetectorRef.detectChanges();
    }
    logout() {
        this.loginInfo = "";
        this.loginError = "";
        this.loginInfo = "";
        this.disabledEmailOptions(true);
        GlobalFunctions.clearAppCacheData();
        this.appManager.removeCookies();
        this.userService.isConnected = false;
        this.enable2FALogin = false;
        this.sessionManager.isAutoLogin = false;
        this.showProgressBar = false;
        this.changeDetectorRef.detectChanges();
    }
};
__decorate([
    ViewChild('form')
], LoginComponent.prototype, "form", void 0);
LoginComponent = __decorate([
    Component({
        selector: 'login',
        templateUrl: './login.component.html',
        styleUrls: ['./login.component.scss']
    })
], LoginComponent);
export { LoginComponent };
//# sourceMappingURL=login.component.js.map