var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { SubSink } from 'subsink';
import { BaseDetailComponent } from '../../components/common/base-detail.component';
import { OperationType, ScreenMode } from '../../core/enums/common-enums';
import { EntityFqdn } from '../../core/enums/core-enums';
import { ActivityItems } from '../../core/models/common/activity-items';
import { Menu } from '../../core/models/common/menu';
import { PopupMenuAction } from '../../core/models/common/popup-menu-action';
import { SearchDto } from '../../core/models/common/searchDto';
import { StringCriteriaDto } from '../../core/models/common/string-criteria';
import { BroadCastEventKeys, Parameters, RoutePath } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
let CommonDetailComponent = class CommonDetailComponent extends BaseDetailComponent {
    constructor(translateService, integrationSettingManager, sessionManager, activatedRoute, userSettingManager, systemComponentService, searchService, cacheManager, ticketService, geoLayerService, personService, organizationService, cd, caseService, contactHistoryService, documentService, taskService, productService, employeeService, noteService, questionAnswerService, emailService, themeService, linkService, socialMediaService, chatService, fileService, issueService, domainService, formatManager, dialogManager, applicationFeatureManager, applicationSettingManager, eventProvider, router, phoneManager, downloadService, sortManager) {
        super(phoneManager, dialogManager, translateService);
        this.translateService = translateService;
        this.integrationSettingManager = integrationSettingManager;
        this.sessionManager = sessionManager;
        this.activatedRoute = activatedRoute;
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.searchService = searchService;
        this.cacheManager = cacheManager;
        this.ticketService = ticketService;
        this.geoLayerService = geoLayerService;
        this.personService = personService;
        this.organizationService = organizationService;
        this.cd = cd;
        this.caseService = caseService;
        this.contactHistoryService = contactHistoryService;
        this.documentService = documentService;
        this.taskService = taskService;
        this.productService = productService;
        this.employeeService = employeeService;
        this.noteService = noteService;
        this.questionAnswerService = questionAnswerService;
        this.emailService = emailService;
        this.themeService = themeService;
        this.linkService = linkService;
        this.socialMediaService = socialMediaService;
        this.chatService = chatService;
        this.fileService = fileService;
        this.issueService = issueService;
        this.domainService = domainService;
        this.formatManager = formatManager;
        this.dialogManager = dialogManager;
        this.applicationFeatureManager = applicationFeatureManager;
        this.applicationSettingManager = applicationSettingManager;
        this.eventProvider = eventProvider;
        this.router = router;
        this.phoneManager = phoneManager;
        this.downloadService = downloadService;
        this.sortManager = sortManager;
        this.uniqueId = GlobalFunctions.createGuid();
        this.relatedStatusList = [];
        this.relatedSearchCompleted = false;
        this.popupMenu = new PopupMenuAction();
        this.relatedFor = "DETAIL";
        this.showThemeDetailView = false;
        this.showRelatedSearchDelaySymbol = false;
        this.relatedViews = [];
        this.relatedResultList = [];
        this.isNormalSizeDetailView = false;
        this.activityItems = [];
        this.groupedActivityKeys = [];
        this.groupedActivityItems = [];
        this.activityItemsToDisplay = 5;
        this.notificationItems = [];
        this.subs = new SubSink();
        this.timeoutIds = [];
        this.openItemInDetailView = (type, item) => {
            this.sessionManager.loadedFromRelatedView = true;
            this.sessionManager.selectedEntity = item;
            item.locationUrl = `${RoutePath.DETAIL_PATH}/${type.toLowerCase()}`;
            this.sessionManager.setBreadcrumbGrammer(item);
            this.sessionManager.addBreadcrumbItems([item], null, RoutePath.DETAIL_PATH);
            this.router.navigate([item.locationUrl]);
        };
        this.relatedResultFound = this.relatedResultFound.bind(this);
        this.searchStartedNotification = this.searchStartedNotification.bind(this);
        this.downloadRelatedFileReponse = this.downloadRelatedFileReponse.bind(this);
        this.searchCompletedNotification = this.searchCompletedNotification.bind(this);
        this.fetchNotificationResultCallback = this.fetchNotificationResultCallback.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.UPDATE_DETAIL_VIEW).subscribe(() => {
            this.updateDetailView();
            if (!this.sessionManager.loadedFromRelatedView)
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.RELOAD_ENTITY_DETAIL);
            else
                this.sessionManager.loadedFromRelatedView = false;
        });
    }
    ngOnInit() {
        this.subs.sink = this.activatedRoute.params.subscribe(() => this.updateDetailView());
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.sessionManager.showDetailViewActionOption = false;
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    updateDetailView() {
        this.menu = new Menu();
        this.relatedViews = [];
        this.relatedResultList = [];
        this.activityItems = [];
        this.groupedActivityKeys = [];
        this.groupedActivityItems = [];
        this.popupMenu = new PopupMenuAction();
        this.type = this.activatedRoute.snapshot.params['domain'].toLowerCase();
        this.sessionManager.showDetailViewActionOption = true;
        if (!GlobalFunctions.isTaskDomain(this.type.toUpperCase()) || (GlobalFunctions.isTaskDomain(this.type.toUpperCase()) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && this.sessionManager.selectedEntity.IsClosed == false))
            this.sessionManager.startSessionIfPossible(this.type, ScreenMode.Detail);
        this.geoLayerService.init(this.type, this.sessionManager.selectedEntity, this);
        if (this.type === Parameters.THEME)
            this.showThemeDetailView = true;
        else {
            this.relatedViews = [];
            this.showThemeDetailView = false;
            this.setRelatedResultCallback();
        }
        if (this.type.toLowerCase() === 'location') {
            this.geoLayerService.showLayerDiv = true;
            this.sessionManager.showMenuOptions = false;
        }
        else
            this.sessionManager.showMenuOptions = true;
        this.sessionManager.isFavouriteApplicable = this.isFavouriteApplicable(this.type);
        this.timeoutIds.push(setTimeout(() => this.resize(), 50));
    }
    setRelatedResultCallback() {
        this.uniqueId = GlobalFunctions.createGuid();
        this.caseService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.caseService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.contactHistoryService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.contactHistoryService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.documentService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.documentService.setFileRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.documentService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.personService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.personService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.organizationService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.organizationService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.ticketService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.ticketService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.taskService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.taskService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.productService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.productService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.employeeService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.employeeService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.noteService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.noteService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.questionAnswerService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.questionAnswerService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.emailService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.emailService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.fileService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.fileService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.themeService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.themeService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.linkService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.linkService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.socialMediaService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.socialMediaService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.chatService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.chatService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.issueService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.issueService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.systemComponentService.setNewsRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.systemComponentService.setSearchNewsNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.domainService.setRelatedResultCallback(this.relatedResultFound, this.uniqueId);
        this.domainService.setSearchNotificationCallbacks(this.searchStartedNotification, this.searchCompletedNotification);
        this.setNotificationView();
    }
    onSendRelatedRequest() {
        this.startSpinner();
        this.organizationService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.caseService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.documentService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.noteService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.issueService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.ticketService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.taskService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.productService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.questionAnswerService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.employeeService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.fileService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.themeService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.linkService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.chatService.sendRelatedRequest(this.sessionManager.selectedEntity);
        this.systemComponentService.sendNewsRelatedRequest(this.sessionManager.selectedEntity);
        this.domainService.sendRelatedRequest(this.sessionManager.selectedEntity);
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.RelatedEntityFqdn)) {
            if (this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("link") < 0)
                this.personService.sendRelatedRequest(this.sessionManager.selectedEntity);
            if (this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("link") < 0)
                this.emailService.sendRelatedRequest(this.sessionManager.selectedEntity, this.applicationFeatureManager.isShowNextEmailFeatureEnabled);
            if (this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("product") < 0 && this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("questionanswer") < 0 && this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("link") < 0 && this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("noteentity") < 0)
                this.contactHistoryService.sendRelatedRequest(this.sessionManager.selectedEntity);
            if (this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("contactmoment") > 0 || this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("callbacknote") > 0 || this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("appointment") > 0 || this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("assignment") > 0 || this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("informationrequest") > 0 || this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("informationresponse") > 0 || this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("person") > 0 || this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("organization") > 0)
                this.socialMediaService.sendRelatedRequest(this.sessionManager.selectedEntity);
            if (this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("organization") > 0)
                this.personService.searchRelatedRepresentativeRequest(this.relatedResultFound, this.sessionManager.selectedEntity);
        }
        //Stop automatically progress-bar after 20 seconds.
        this.timeoutIds.push(setTimeout(() => this.stopSpinner(), 20000));
    }
    isRelatedSearchCompleted() {
        let searchCompleted = true;
        let fqdnList = GlobalFunctions.getFqdnList();
        for (let index = 0; index < fqdnList.length; index++) {
            if (this.relatedStatusList[fqdnList[index]] != null && this.relatedStatusList[fqdnList[index]] != 0) {
                searchCompleted = false;
                break;
            }
        }
        if (searchCompleted)
            this.stopSpinner();
        else
            this.startSpinner();
        return searchCompleted;
    }
    searchStartedNotification(message) {
        let entityFqdn = GlobalFunctions.getObjectTypeName(message.ContentType);
        entityFqdn = (GlobalFunctions.isEmpty(message.SubContentType) ? entityFqdn : entityFqdn + "_" + message.SubContentType).toUpperCase();
        if (this.relatedStatusList[entityFqdn] == null)
            this.relatedStatusList[entityFqdn] = 0;
        this.relatedStatusList[entityFqdn] += 1;
        if (this.relatedStatusList[entityFqdn] == 0)
            this.relatedSearchCompleted = this.isRelatedSearchCompleted();
    }
    searchCompletedNotification(message) {
        let entityFqdn = GlobalFunctions.getObjectTypeName(message.ContentType);
        entityFqdn = (GlobalFunctions.isEmpty(message.SubContentType) ? entityFqdn : entityFqdn + "_" + message.SubContentType).toUpperCase();
        if (this.relatedStatusList[entityFqdn] == null)
            this.relatedStatusList[entityFqdn] = 0;
        this.relatedStatusList[entityFqdn] -= 1;
        if (this.relatedStatusList[entityFqdn] == 0)
            this.relatedSearchCompleted = this.isRelatedSearchCompleted();
    }
    ;
    resize() {
        const windowHeight = window.innerHeight;
        const newHeight = windowHeight - 100 + "px";
        $("#detailContainer").height(newHeight);
        $("#leftPaneMenu").height(newHeight);
        this.resizeDetailView();
        this.cd.markForCheck();
    }
    addNavigationMenuItem(menu) {
        this.menu = menu;
        this.cd.detectChanges();
    }
    navigate(menuItem) {
        if (menuItem) {
            menuItem.newUpdate = false;
            let id = 'DETAIL_RELATED_' + menuItem.contentType;
            if (id == 'DETAIL_RELATED_0')
                id = 'DETAIL_RELATED_TITLE';
            else if (menuItem.contentType.toLowerCase() == 'messages')
                id = 'socialMediaHistoryList';
            if (!GlobalFunctions.isEmpty(document.getElementById('detailContainer')) && !GlobalFunctions.isEmpty(document.getElementById(id)))
                document.getElementById('detailContainer').scroll({ top: document.getElementById(id).offsetTop - 10, behavior: 'smooth' });
        }
    }
    prepareSearchDto(searchValue, searchField) {
        let searchDto = new SearchDto();
        searchDto.StringCriteriaList = [];
        searchDto.NumericCriteriaList = [];
        searchDto.DateCriteriaList = [];
        searchDto.EnumCriteriaList = [];
        let statusSearchCriteria = new StringCriteriaDto();
        statusSearchCriteria.IsInUse = true;
        statusSearchCriteria.Name = searchField;
        statusSearchCriteria.CompareType = 1;
        statusSearchCriteria.Value = searchValue;
        searchDto.StringCriteriaList.push(statusSearchCriteria);
        return searchDto;
    }
    ;
    resizeDetailView() {
        let element = $("#detailContainer");
        this.isNormalSizeDetailView = element.outerWidth() > 800;
    }
    relatedResultFound(result, contentType, title) {
        if (result?.length > 0) {
            contentType = contentType.toUpperCase();
            this.isPersonClassified(contentType, result);
            switch (contentType.toUpperCase()) {
                case 'TASK':
                case 'CONTACTMOMENT':
                    {
                        this.formatManager.setHandler(contentType, result);
                        this.formatManager.setTag(contentType, result);
                        this.updateActivityItems(contentType, result);
                        break;
                    }
                case 'TICKET':
                    this.updateActivityItems(contentType, result);
                    break;
                case "FILEDOCUMENT":
                case "NOTEENTITY":
                    this.formatManager.setHandler(contentType, result);
                    break;
                case "SOCIALMEDIAHISTORY":
                    this.formatManager.setHandler(contentType, result[0].SocialMediaContactHistoryList);
                    break;
                case "EMPLOYEE":
                    this.formatManager.setEmployee(result);
                    break;
                case "PERSON":
                    this.formatManager.setStringPresentation(result, "PersonDto_Breadcrumb");
                    break;
                case "ORGANIZATION":
                    this.formatManager.setStringPresentation(result, "OrganizationDto_Breadcrumb");
                    break;
                case "EMAIL":
                    for (let i = 0; i < result.length; i++) {
                        if (!GlobalFunctions.isEmpty(result[i].Header) && !GlobalFunctions.isEmpty(result[i].Header.To)) {
                            result[i].Header.ToAddresses = result[i].Header.To.join('; ');
                            if (!GlobalFunctions.isEmpty(result[i].Header.Cc))
                                result[i].Header.ToAddresses += "; " + result[i].Header.Cc.join('; ');
                            if (!GlobalFunctions.isEmpty(result[i].Header.Bcc))
                                result[i].Header.ToAddresses += "; " + result[i].Header.Bcc.join('; ');
                        }
                    }
                    break;
            }
            // TODO FUTURE: split out all task subdomains for better functionality?
            if (contentType.toUpperCase() === 'TASK') {
                switch (result[0].RelatedEntityFqdn) {
                    case EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Appointment]: {
                        if (result[0].ObjectSource.toLowerCase() === 'decos.kcs.tasks.smartcjm') {
                            title = this.translateService.instant('LBL_APPOINTMENTS');
                            contentType = 'APPOINTMENT';
                            break;
                        }
                    }
                }
            }
            if (this.relatedResultList[contentType] == null)
                this.relatedResultList[contentType] = [];
            if (GlobalFunctions.getObjectTypeName(this.sessionManager.selectedEntity.RelatedEntityFqdn).toLowerCase() === 'contactmoment')
                if (this.relatedResultList.hasOwnProperty("SOCIALMEDIAHISTORY") && contentType.toUpperCase() === "SOCIALMEDIA") {
                    delete this.relatedResultList[contentType];
                    return;
                }
            this.concatUniqueOnly(contentType, result);
            this.menu.addOrUpdateMenuItem(this.relatedResultList[contentType]?.length, contentType, title, true, false, false, true, this.showRelatedSearchDelaySymbol);
            this.setRelatedViews(contentType);
            if (this.type.toLowerCase() == 'email') {
                if (contentType.indexOf("FILEDOCUMENT") != -1)
                    this.sessionManager.selectedEntity.AttachmentList = this.relatedResultList['FILEDOCUMENT'];
                else if ((contentType.indexOf("PERSON") != -1 || contentType.indexOf("ORGANIZATION") != -1) && this.sessionManager.isSessionStart)
                    this.sessionManager.addItemsToDetailViewCacheList(result[0], GlobalFunctions.toString(GlobalFunctions.toEntityFqdnString(contentType)));
            }
            this.loadRelatedPersonOrOrganizationInViewer(this.type, contentType, result);
        }
        this.cacheManager.relatedResultList = this.relatedResultList;
    }
    setRelatedViews(contentType) {
        let relatedView = jlinq.from(this.relatedViews).starts("ContentType", contentType).first();
        if (relatedView)
            relatedView.Count = this.relatedResultList[contentType].length;
        else {
            let relatedViewObj = null;
            if (contentType.indexOf("DOMAIN") == -1)
                relatedViewObj = {
                    "ContentType": contentType,
                    "Count": contentType != "LOCATION" ? this.relatedResultList[contentType].length : Number.MAX_VALUE,
                    "Index": GlobalFunctions.getRelatedViewsIndex(contentType)
                };
            else
                relatedViewObj = this.getDomainRelatedView(contentType);
            this.relatedViews.push(relatedViewObj);
        }
        this.relatedViews.sort((x, y) => (x.Index - y.Index));
    }
    ;
    updateActivityItems(contentType, result) {
        const activityItems = new ActivityItems();
        activityItems.addOrUpdateActivityItem(result, contentType, this.translateService);
        // Get last 3 months activities and group by date
        const dateJS = Date;
        for (let i = 0; i < activityItems.activityItemList.length; i++) {
            if (activityItems.activityItemList[i].date > new dateJS.today().addMonths(-6) || activityItems.activityItemList[i].date < 0) {
                if (activityItems.activityItemList[i].contentType == 'TASK')
                    activityItems.activityItemList[i].contentType = activityItems.activityItemList[i].entityObject.TaskType;
                this.activityItems.push(activityItems.activityItemList[i]);
            }
        }
        GlobalFunctions.remove_duplicates(this.activityItems);
        this.activityItems.sort((a, b) => (a.fullDate < b.fullDate) ? 1 : -1);
        this.showActivityItems(this.activityItems.slice(0, 5));
    }
    showActivityItems(activityItemList) {
        this.activityItemsToDisplay = activityItemList.length;
        this.groupedActivityItems = jlinq.from(activityItemList).group("date");
        this.groupedActivityKeys = Object.keys(this.groupedActivityItems);
    }
    ;
    getDomainRelatedView(contentType) {
        let relatedViewObj = new Object();
        relatedViewObj.Title = GlobalFunctions.capitalize(contentType.split('_')[1].toLowerCase());
        relatedViewObj.ContentType = contentType;
        relatedViewObj.Count = Number.MAX_VALUE;
        //Set header field according to domain type
        let screen = this.integrationSettingManager.getDomainScreenSetting(relatedViewObj.Title, "Related");
        if (screen != null && screen.FieldGroups != null && screen.FieldGroups.length > 0)
            relatedViewObj.Fields = screen.FieldGroups[0].Fields;
        else
            relatedViewObj.Fields = [];
        return relatedViewObj;
    }
    concatUniqueOnly(contentType, result) {
        for (let i = 0; i < result?.length; i++) {
            let found = $.grep(this.relatedResultList[contentType], existingItem => existingItem.Id == result[i].Id && existingItem.ObjectSource == result[i].ObjectSource);
            if (found?.length == 0)
                this.relatedResultList[contentType].push(result[i]);
        }
        //Sorting data base on setting
        this.relatedResultList[contentType] = this.sortManager.sortEntityBasedOnApplicationSetting(contentType.toUpperCase(), this.relatedResultList[contentType]);
    }
    ;
    isPersonClassified(objcontentType, resultData) {
        if (objcontentType.toUpperCase() == "PERSON" && this.sessionManager.selectedEntity && this.sessionManager.selectedEntity.MainEntityType == 1) {
            for (let i = 0; i < resultData.length; i++) {
                if (this.sessionManager.selectedEntity.MainEntityId == resultData[i].Id) {
                    this.sessionManager.selectedEntity.personClassifiedValue = resultData[i].ConfidentialityLevel;
                    break;
                }
            }
        }
    }
    ;
    loadRelatedPersonOrOrganizationInViewer(detailEntityType, relatedEntityType, relatedResults) {
        switch (relatedEntityType.toUpperCase()) {
            case "PERSON":
            case "ORGANIZATION":
                {
                    if (this.sessionManager.isViewerFeatureEnabled && this.sessionManager.hasViewerAccess && this.applicationSettingManager.viewerSetting.loadFromRelatedItem(relatedEntityType)) {
                        switch (detailEntityType.toUpperCase()) {
                            case "CASEENTITY":
                            case 'CONTACTMOMENT':
                            case "DOCUMENT":
                            case "EMAIL":
                            case "NOTEENTITY":
                            case "FACEBOOK":
                            case "TWITTER":
                            case "WHATSAPP":
                            case "SOCIALMEDIA":
                            case "APPOINTMENT":
                            case "ASSIGNMENT":
                            case "CALLBACKNOTE":
                            case "REPORTIMPROVEMENT":
                            case "INFORMATIONREQUEST":
                            case 'TASK':
                            case "TICKET":
                                this.timeoutIds.push(setTimeout(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.OPEN_VIEWER_PANEL, relatedResults[0]), 2000));
                                break;
                        }
                    }
                }
                break;
        }
    }
    getVendorIdDivModel(vendor) {
        return (vendor.id + 'DivModel');
    }
    getVendorIdSpanModel(vendor) {
        return (vendor.id + 'SpanModel');
    }
    showLocationMap() {
        this.relatedResultFound(["dummy"], "location", this.translateService.instant("LBL_LOCATION"));
        this.geoLayerService.plotGeoMap();
    }
    isFavouriteApplicable(type) {
        return !['email', 'facebook', 'twitter', 'whatsapp', 'appointment', 'callbacknote', 'informationrequest', 'task', 'ticket'].includes(type);
    }
    setNotificationView() {
        if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("NOTEENTITY"), OperationType.View)) {
            if (this.employeeService.loggedInEmployee != null && this.sessionManager.selectedEntity != null && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.Id)) {
                this.noteService.clearDetailViewNotificationCallbacks();
                this.noteService.setFetchDetailViewNotificationResultCallbacks(this.fetchNotificationResultCallback);
                this.noteService.fetchNotifications(this.employeeService.loggedInEmployee.Id, this.employeeService.loggedInEmployee.DepartmentId, this.sessionManager.selectedEntity.Id);
            }
        }
    }
    fetchNotificationResultCallback(result) {
        this.notificationItems = result;
    }
    downloadRelatedFile(relatedEntity) {
        if (this.relatedResultList['FILEDOCUMENT'] != null && this.relatedResultList['FILEDOCUMENT'].length > 0) {
            let file = jlinq.from(this.relatedResultList['FILEDOCUMENT']).equals("Id", relatedEntity.RelatedEntityId).first();
            if (file != null)
                this.fileService.downloadFile(file, this.downloadRelatedFileReponse);
        }
    }
    ;
    downloadRelatedFileReponse(message) {
        if (message != null && !GlobalFunctions.isEmpty(message.TicketId))
            this.subs.sink = this.downloadService.downloadFile(message.TicketId).subscribe(res => GlobalFunctions.downloadFileAsBlob(res));
    }
    ;
    openEmail() {
        if (this.relatedResultList["EMAIL"] && this.relatedResultList["EMAIL"].length > 0)
            this.openItemInDetailView("Email", this.relatedResultList["EMAIL"][0]);
    }
    ;
    openSocialMedia() {
        if (this.relatedResultList["SOCIALMEDIA"] && this.relatedResultList["SOCIALMEDIA"].length > 0 && !GlobalFunctions.isEmpty(this.relatedResultList["SOCIALMEDIA"][0].Type) && (this.relatedResultList["SOCIALMEDIA"][0].Type.toLowerCase() == 'whatsapp' || this.relatedResultList["SOCIALMEDIA"][0].Type.toLowerCase() == 'twitter' || this.relatedResultList["SOCIALMEDIA"][0].Type.toLowerCase() == 'facebook'))
            this.openItemInDetailView(this.relatedResultList["SOCIALMEDIA"][0].Type.toLowerCase(), this.relatedResultList["SOCIALMEDIA"][0]);
    }
    ;
};
CommonDetailComponent = __decorate([
    Component({
        selector: 'common-detail',
        templateUrl: './detail.component.html',
        styleUrls: ['./detail.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], CommonDetailComponent);
export { CommonDetailComponent };
//# sourceMappingURL=detail.component.js.map