var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { AlternateSearchType, OperationType } from 'src/app/core/enums/common-enums';
import { GlobalFunctions } from 'src/app/shared/global-functions';
let RssComponent = class RssComponent {
    constructor(systemComponentService, sessionManager, cacheManager, cd) {
        this.systemComponentService = systemComponentService;
        this.sessionManager = sessionManager;
        this.cacheManager = cacheManager;
        this.cd = cd;
        this.newsItems = [];
        this.showProgressBar = false;
        this.dashbordNewsItems = [];
        this.onItemSelect = new EventEmitter();
        this.searchResultFound = this.searchResultFound.bind(this);
        this.updateSearchStatus = this.updateSearchStatus.bind(this);
    }
    ngOnInit() {
        let dashbordNewsItems_cache = this.cacheManager.getFromDashboardCache("news");
        if (dashbordNewsItems_cache != undefined)
            this.dashbordNewsItems = dashbordNewsItems_cache;
        else {
            if (GlobalFunctions.checkRights("News", OperationType.View)) {
                this.showProgressBar = true;
                this.systemComponentService.searchNews("", false, AlternateSearchType.None, "", "", this.searchResultFound, this.updateSearchStatus, null, null);
            }
        }
    }
    updateSearchStatus(result) {
        this.sourceCount = result.ActiveHandlers.length;
        if (this.sourceCount == 0) {
            if (this.newsItems.length > 0) {
                this.newsItems = this.newsItems.sort((m, n) => {
                    m = new Date(m.PublishDate), n = new Date(n.PublishDate);
                    return (n.getTime() - m.getTime());
                });
            }
            if (GlobalFunctions.isEmpty(this.dashbordNewsItems))
                this.dashbordNewsItems = [];
            if (this.newsItems.length > 10)
                this.dashbordNewsItems = this.newsItems.slice(0, 10);
            else
                this.dashbordNewsItems = this.newsItems;
            this.cacheManager.addToDashboardCache("news", this.dashbordNewsItems);
            this.cd.detectChanges();
        }
    }
    searchResultFound(result) {
        try {
            if (result != null && result.length > 0) {
                this.sessionManager.setBgColorBasedOnObjectSource(result);
                if (GlobalFunctions.isEmpty(this.newsItems))
                    this.newsItems = [];
                this.newsItems = this.newsItems.concat(result);
            }
            this.showProgressBar = false;
        }
        catch (e) {
            console.error(e);
        }
    }
    select(rssItem) {
        GlobalFunctions.popUpCenter(rssItem.Link, 1024, 550);
    }
};
__decorate([
    Input()
], RssComponent.prototype, "dashboardWebPart", void 0);
__decorate([
    Output()
], RssComponent.prototype, "onItemSelect", void 0);
RssComponent = __decorate([
    Component({
        selector: 'rss-webpart',
        templateUrl: './rss.component.html',
        styleUrls: ['./rss.component.scss']
    })
], RssComponent);
export { RssComponent };
//# sourceMappingURL=rss.component.js.map