var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Input, Output } from '@angular/core';
import { OperationType } from 'src/app/core/enums/common-enums';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { SubSink } from 'subsink';
import { EntityFqdn } from '../../../../core/enums/core-enums';
import { RoutePath } from '../../../../shared/constants';
let NotificationComponent = class NotificationComponent {
    constructor(router, cacheManager, noteService, employeeService, sortManager, sessionManager, searchService, translateService, contactHistoryService) {
        this.router = router;
        this.cacheManager = cacheManager;
        this.noteService = noteService;
        this.employeeService = employeeService;
        this.sortManager = sortManager;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.translateService = translateService;
        this.contactHistoryService = contactHistoryService;
        this.showProgressBar = false;
        this.dashboardNotificationItems = [];
        this.userId = GlobalFunctions.getLoggedInUserId();
        this.onItemSelect = new EventEmitter();
        this.subs = new SubSink();
        this.fetchNotificationResultCallback = this.fetchNotificationResultCallback.bind(this);
    }
    ngOnInit() {
        try {
            if (GlobalFunctions.hasRight(GlobalFunctions.toContentType("NOTEENTITY"), OperationType.View)) {
                this.showProgressBar = true;
                let dashbordNotificationsItemsCache = this.cacheManager.getFromDashboardCache("notification");
                if (dashbordNotificationsItemsCache)
                    setTimeout(() => this.fetchNotificationResultCallback(dashbordNotificationsItemsCache), 100);
                else {
                    this.noteService.setFetchNotificationResultCallbacks(this.fetchNotificationResultCallback);
                    if (!GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee))
                        this.fetchNotifications();
                    else {
                        this.subs.sink = this.employeeService.cacheLoggedInUser().subscribe(() => {
                            if (!GlobalFunctions.isEmpty(this.employeeService.loggedInEmployee))
                                this.fetchNotifications();
                        });
                    }
                }
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    fetchNotifications() {
        this.noteService.connect().then(() => this.noteService.fetchNotifications(this.employeeService.loggedInEmployee.Id, this.employeeService.loggedInEmployee.DepartmentId));
    }
    ;
    fetchNotificationResultCallback(notifications) {
        try {
            this.noteService.clearCallbacks();
            if (notifications?.length > 0) {
                this.dashboardNotificationItems = [];
                this.noteService.setCreateByToNoteList(notifications, this.cacheManager);
                for (let index = 0; index < notifications.length; index++) {
                    if (notifications[index].NoteEntity != null && (notifications[index].NoteEntity.NoteType == 2 || notifications[index].NoteEntity.RelatedEntities == null || notifications[index].NoteEntity.RelatedEntities.length == 0))
                        this.dashboardNotificationItems.push(notifications[index]);
                }
                if (this.dashboardNotificationItems.length > 0) {
                    this.dashboardNotificationItems = this.sortManager.sortItemsBasedOnProperty(this.dashboardNotificationItems, "NoteEntity.OnDateTime");
                    this.noteService.setSelectedNotificationItem(this.dashboardNotificationItems);
                }
                this.cacheManager.addToDashboardCache('notification', notifications);
            }
            this.showProgressBar = false;
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    notificationRead(item, event) {
        if (item != null && item.NoteEntity != null) {
            let isExist = this.isDashboardNotificationItemExist(item);
            if (isExist)
                this.noteService.setNotificationMessageViewerStatus(item.Id);
            if (event.stopPropagation)
                event.stopPropagation();
            if (event.preventDefault)
                event.preventDefault();
            event.cancelBubble = true;
            event.returnValue = false;
        }
    }
    ;
    select(item) {
        if (item != null && item.NoteEntity != null) {
            if (item.NoteEntity.NoteType == 3) {
                this.searchService.advancedSearchQuery = this.translateService.instant('LBL_PRIVACY_MESSAGE_RESULTS');
                this.searchService.advanceSearch({
                    searchDto: this.contactHistoryService.getPrivacySearchDto(),
                    searchType: 'contacthistory',
                    searchSubType: 'privacy'
                });
            }
            else {
                let isExist = this.isDashboardNotificationItemExist(item);
                if (isExist) {
                    let noteType = 'noteEntity';
                    if (item.NoteEntity.NoteType == 2 || item.NoteEntity.NoteType == 'InformationResponse') {
                        noteType = 'informationresponse';
                        item.NoteEntity.RelatedEntityFqdn = EntityFqdn[EntityFqdn.Decos_Kcs_Notes_Entities_InformationResponse];
                        item.NoteEntity.NotificationId = item.Id;
                    }
                    this.sessionManager.loadedFromRelatedView = false;
                    this.sessionManager.selectedEntity = item.NoteEntity;
                    this.sessionManager.selectedEntity.locationUrl = item.locationUrl = `${RoutePath.DETAIL_PATH}/${noteType}`;
                    if (GlobalFunctions.isEmpty(item.NoteEntity.Title))
                        item.NoteEntity.StringRepresentation = item.NoteEntity.DescriptionPlaintext;
                    this.sessionManager.addBreadcrumbItems([item.NoteEntity], null, RoutePath.DETAIL_PATH);
                    this.router.navigate([this.sessionManager.selectedEntity.locationUrl]);
                }
            }
        }
    }
    ;
    isDashboardNotificationItemExist(item) {
        let isExist = false;
        if (item != null && item.NoteEntity != null) {
            for (let i = 0; i < this.dashboardNotificationItems.length; i++) {
                if (this.dashboardNotificationItems[i].Id == item.Id) {
                    this.dashboardNotificationItems.splice(i, 1);
                    isExist = true;
                    break;
                }
            }
        }
        return isExist;
    }
};
__decorate([
    Input()
], NotificationComponent.prototype, "dashboardWebPart", void 0);
__decorate([
    Output()
], NotificationComponent.prototype, "onItemSelect", void 0);
NotificationComponent = __decorate([
    Component({
        selector: 'notification-webpart',
        templateUrl: './notification.component.html',
        styleUrls: ['./notification.component.scss']
    })
], NotificationComponent);
export { NotificationComponent };
//# sourceMappingURL=notification.component.js.map