var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, EventEmitter, Output } from "@angular/core";
import { RoutePath } from "src/app/shared/constants";
import { GlobalFunctions } from "src/app/shared/global-functions";
import { SubSink } from "subsink";
import { OperationType } from "../../../core/enums/common-enums";
import { EntityFqdn } from "../../../core/enums/core-enums";
let BaseNavigationDrawerComponent = class BaseNavigationDrawerComponent {
    constructor(router, sessionManager, searchService, activatedRoute, eventProvider) {
        this.router = router;
        this.sessionManager = sessionManager;
        this.searchService = searchService;
        this.activatedRoute = activatedRoute;
        this.eventProvider = eventProvider;
        this.onMenuItemClick = new EventEmitter();
        this.hasLocationBasedTasks = false;
        this.rights = {
            contactHistory: false,
            document: false,
            email: false,
            news: false,
            note: false,
            session: false,
            socialMedia: false,
            task: false,
            theme: false,
            ticket: false,
            showDashboard: false
        };
        this.subs = new SubSink();
        this.subs.sink = this.activatedRoute.queryParams.subscribe(queryParams => this.selectedOption = queryParams.filter);
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    menuItemClick(menuItem) {
        this.sessionManager.localSearchFieldList = null;
        this.searchService.isLeftMenuSearch = true;
        this.onMenuItemClick.emit(menuItem);
        this.selectedLocation = null;
    }
    isRouteActivated(commands, includes) {
        if (!includes)
            return this.router.url === [null, ...commands].join('/');
        else
            return this.router.url.includes([null, ...commands].join('/'));
    }
    isDashboardActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD]);
    }
    isTicketsActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, 'ticket']) || this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'ticket'], true);
    }
    isMyTicketsActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'ticket?filter=my']);
    }
    isAllTicketsActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'ticket?filter=all']);
    }
    isTasksActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, 'task']) || this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'task'], true);
    }
    isMyTasksActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'task?filter=my']);
    }
    isDocumentsActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'document']);
    }
    isContactHistoryActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, 'contacthistory']) || this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'contacthistory']);
    }
    isEmailActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, 'email'], true) || this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'email'], true);
    }
    isSocialMediaActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, 'socialmedia']) || this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'socialmedia'], true);
    }
    isNewsActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'news']);
    }
    isNotesActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, 'note']) || this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'noteentity']);
    }
    isThemesActivated() {
        return this.isRouteActivated([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'theme']);
    }
    searchEmailSelection(option, mailboxId) {
        this.selectedOption = option;
        this.selectedMailbox = mailboxId;
        this.sessionManager.selectedMailbox = mailboxId;
        this.menuItemClick('email:' + option + '/' + mailboxId);
    }
    setRights() {
        this.rights.contactHistory = GlobalFunctions.checkDashboardRights('ContactHistory');
        this.rights.document = GlobalFunctions.checkDashboardRights('Document');
        this.rights.email = GlobalFunctions.checkDashboardRights('Email');
        this.rights.news = GlobalFunctions.checkDashboardRights('News');
        this.rights.note = GlobalFunctions.checkDashboardRights('NoteEntity');
        this.rights.session = GlobalFunctions.checkDashboardRights('Session');
        this.rights.socialMedia = GlobalFunctions.checkDashboardRights('SocialMedia');
        this.rights.task = GlobalFunctions.checkDashboardRights('Task');
        this.rights.theme = GlobalFunctions.checkDashboardRights('Theme');
        this.rights.ticket = GlobalFunctions.checkDashboardRights('Ticket');
        this.rights.showDashboard = GlobalFunctions.checkRights(GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_SocialMedia]), OperationType.Add);
    }
};
__decorate([
    Output()
], BaseNavigationDrawerComponent.prototype, "onMenuItemClick", void 0);
BaseNavigationDrawerComponent = __decorate([
    Component({
        selector: 'base-navigation-drawer',
        template: '<span></span>'
    })
], BaseNavigationDrawerComponent);
export { BaseNavigationDrawerComponent };
//# sourceMappingURL=base-navigation-drawer.component.js.map