var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { BaseComponent } from 'src/app/components/base-component';
import { SocialMediaMessageCountDto } from 'src/app/core/models/social-media/social-media-message-countDto';
import { BroadCastEventKeys, EntityName, SideMenuItem } from 'src/app/shared/constants';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { SubSink } from 'subsink';
import { RoutePath } from '../../shared/constants';
let DashboardComponent = class DashboardComponent extends BaseComponent {
    constructor(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef, sessionManager, taskService, sessionService, documentService, socialMediaService, emailService, ticketService, eventProvider) {
        super(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef);
        this.translateService = translateService;
        this.router = router;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.sessionManager = sessionManager;
        this.taskService = taskService;
        this.sessionService = sessionService;
        this.documentService = documentService;
        this.socialMediaService = socialMediaService;
        this.emailService = emailService;
        this.ticketService = ticketService;
        this.eventProvider = eventProvider;
        this.isPendingTasksCountReceived = false;
        this.isPendingSessionsCountReceived = false;
        this.myTasksTotalCount = 0;
        this.subs = new SubSink();
        this.timeoutIds = [];
        this.pendingTasksCountReceived = this.pendingTasksCountReceived.bind(this);
        this.pendingTicketCountReceived = this.pendingTicketCountReceived.bind(this);
        this.pendingSessionsCountReceived = this.pendingSessionsCountReceived.bind(this);
        this.pendingDocumentsCountReceived = this.pendingDocumentsCountReceived.bind(this);
        this.getTicketFilterConfigurationResponse = this.getTicketFilterConfigurationResponse.bind(this);
        this.pendingSocialMediaMessageCountReceived = this.pendingSocialMediaMessageCountReceived.bind(this);
        this.init = this.init.bind(this);
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.REFRESH_DASHBOARD).subscribe(() => {
            this.sessionManager.pendingCount.IsCountUpdated = false;
            this.init();
        });
    }
    ngOnInit() {
        this.init();
    }
    init() {
        this.taskService.connect().then(() => {
            this.taskService.pendingCountMessageId = GlobalFunctions.createGuid();
            this.sessionService.pendingCountMessageId = GlobalFunctions.createGuid();
            if ((GlobalFunctions.checkRights('Task') || GlobalFunctions.checkRights('Session')) && (this.sessionManager.isRefreshAllowed('Task') || (this.sessionManager.isRoleFeatureEnabled && this.sessionManager.isRoleChanged))) {
                this.timeoutIds.push(setTimeout(() => {
                    this.myTasksTotalCount = 0;
                    this.isPendingTasksCountReceived = false;
                    this.isPendingSessionsCountReceived = false;
                    this.taskService.getPendingTasksCount(this.taskService.pendingCountMessageId, this.pendingTasksCountReceived);
                    this.sessionService.getPendingSessionsCount(this.sessionService.pendingCountMessageId, this.pendingSessionsCountReceived);
                    this.sessionManager.pendingCount.MyScheduledWorkCount = "...";
                    this.sessionManager.pendingCount.MyUnreplyScheduledWorkCount = 0;
                    this.sessionManager.pendingCount.IsTaskCountUpdated = true;
                    this.sessionManager.isRoleChanged = false;
                }, 250));
            }
        });
        this.socialMediaService.connect().then(() => {
            this.socialMediaService.pendingCountMessageId = GlobalFunctions.createGuid();
            if (this.sessionManager.isAllowedToFetchCount('SocialMedia') && this.sessionManager.isRefreshAllowed('SocialMedia')) {
                this.socialMediaService.getPendingSocialMediaMessageCount(this.socialMediaService.pendingCountMessageId, this.pendingSocialMediaMessageCountReceived);
                this.sessionManager.pendingCount.SocialMediaMessageCount = new SocialMediaMessageCountDto();
                this.sessionManager.pendingCount.SocialMediaMessageCount.TotalMessageCount = "...";
                this.socialMediaService.lastSelectedOption = "socialmedia";
                this.sessionManager.pendingCount.IsSocialMediaCountUpdated = true;
            }
        });
        this.documentService.connect().then(() => {
            if (GlobalFunctions.checkRights('Document') && this.sessionManager.isRefreshAllowed('Document')) {
                this.documentService.searchPendingDocumentCount(this.pendingDocumentsCountReceived);
                this.sessionManager.pendingCount.DocumentCount = "...";
                this.sessionManager.pendingCount.IsDocumentCountUpdated = true;
            }
        });
        this.ticketService.connect().then(() => {
            this.ticketService.pendingCountMessageId = GlobalFunctions.createGuid();
            if (GlobalFunctions.checkRights('Ticket') && this.sessionManager.isTicketFeatureEnabled && this.sessionManager.isRefreshAllowed('Ticket')) {
                this.ticketService.getPendingTicketCount(this.ticketService.pendingCountMessageId, this.pendingTicketCountReceived);
                this.sessionManager.pendingCount.MyTicketCount = "...";
                this.sessionManager.pendingCount.IsTicketCountUpdated = true;
            }
            if (this.sessionManager.ticketFilters == null)
                this.ticketService.getTicketFilterConfiguration(this.getTicketFilterConfigurationResponse);
        });
        this.emailService.connect().then(() => {
            if (this.sessionManager.isAllowedToFetchCount('Email') && this.sessionManager.isRefreshAllowed('Email')) {
                this.emailService.getPendingEmailsCount();
                this.sessionManager.pendingCount.IsEmailCountUpdated = true;
            }
        });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
        this.timeoutIds.forEach(timeoutId => clearTimeout(timeoutId));
    }
    navigate(domain) {
        if (!GlobalFunctions.isEmpty(domain)) {
            let route = '';
            let queryParams = {};
            const contentType = domain.split(':')[0];
            switch (contentType.toLowerCase()) {
                case SideMenuItem.DASHBOARD.toLowerCase():
                    {
                        route = `/${RoutePath.DASHBOARD}`;
                        break;
                    }
                case SideMenuItem.NOTE.toLowerCase():
                case SideMenuItem.CONTACT_HISTORY.toLowerCase():
                    {
                        route = `/${RoutePath.DASHBOARD}/${RoutePath.SEARCH_PATH}/${domain}`;
                        break;
                    }
                case SideMenuItem.NEWS.toLowerCase():
                case SideMenuItem.THEME.toLowerCase():
                case SideMenuItem.DOCUMENT.toLowerCase():
                    {
                        route = `/${RoutePath.DASHBOARD}/${RoutePath.LIST_PATH}/${domain}`;
                        break;
                    }
                case SideMenuItem.TASK.toLowerCase():
                case SideMenuItem.TICKET.toLowerCase():
                case SideMenuItem.SOCIAL_MEDIA.toLowerCase():
                    {
                        const entities = domain.split(':');
                        if (entities.length === 1)
                            route = `/${RoutePath.DASHBOARD}/${RoutePath.SEARCH_PATH}/${entities[0]}`;
                        else {
                            route = `/${RoutePath.DASHBOARD}/${RoutePath.LIST_PATH}/${entities[0]}`;
                            queryParams = { filter: entities[1] };
                        }
                        break;
                    }
                case SideMenuItem.EMAIL.toLowerCase():
                    {
                        if (domain.split(':').length === 1)
                            route = `/${RoutePath.DASHBOARD}/${RoutePath.SEARCH_PATH}/${domain}`;
                        else {
                            this.searchInfo = domain.split(':')[1];
                            if (this.searchInfo.split('/').length > 1) {
                                if (this.searchInfo.split('/')[0] === 'archive') {
                                    route = `${RoutePath.DASHBOARD}/${RoutePath.SEARCH_PATH}/${EntityName.EMAIL}`;
                                    queryParams = { filter: this.searchInfo.split('/')[0], mailbox: this.searchInfo.split('/')[1] };
                                }
                                else {
                                    route = `/${RoutePath.DASHBOARD}/${RoutePath.LIST_PATH}/${EntityName.EMAIL}`;
                                    queryParams = { filter: this.searchInfo.split('/')[0], mailbox: this.searchInfo.split('/')[1] };
                                }
                            }
                        }
                        break;
                    }
            }
            if (this.router.url != this.getRoutePath(route, queryParams))
                this.zone.run(() => this.router.navigate([route], { queryParams }));
            if (this.router.url.split('?')[0] === route)
                setTimeout(() => this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_SEARCH_RESULTS));
        }
    }
    getRoutePath(route, queryParams) {
        let path = route;
        Object.keys(queryParams).forEach((key, index) => {
            if (index === 0)
                path += '?';
            else
                path += '&';
            path += `${key}=${Object.values(queryParams)[index]}`;
        });
        return path;
    }
    pendingTasksCountReceived(message) {
        if (message?.MessageId == this.taskService.pendingCountMessageId && message?.PendingItemsCountDtoList?.length > 0) {
            console.log('pendingTasksCountReceived', message);
            for (let index = 0; index < message.PendingItemsCountDtoList.length; index++) {
                if (message.PendingItemsCountDtoList[index]) {
                    let item = message.PendingItemsCountDtoList[index];
                    this.myTasksTotalCount += item.Count;
                    this.sessionManager.pendingCount.MyScheduledWorkCount = this.myTasksTotalCount;
                    this.sessionManager.pendingCount.MyUnreplyScheduledWorkCount += item.UnreplyCount;
                }
            }
        }
        this.isPendingTasksCountReceived = true;
        if (this.sessionManager.pendingCount.MyScheduledWorkCount == "..." && this.isPendingSessionsCountReceived == true)
            this.sessionService.hasPendingSession();
    }
    pendingSessionsCountReceived(message) {
        if (message?.MessageId == this.sessionService.pendingCountMessageId && message?.PendingItemsCountDtoList?.length > 0) {
            console.log('pendingSessionsCountReceived', message);
            this.sessionManager.pendingCount.SessionCount = message.PendingItemsCountDtoList[0].Count;
            this.myTasksTotalCount += message.PendingItemsCountDtoList[0].Count;
        }
        this.isPendingSessionsCountReceived = true;
        if (this.sessionManager.pendingCount.MyScheduledWorkCount == "..." && this.isPendingTasksCountReceived == true)
            this.sessionService.hasPendingSession();
    }
    pendingTicketCountReceived(message) {
        if (message?.MessageId == this.ticketService.pendingCountMessageId && message?.PendingItemsCountDtoList?.length > 0)
            this.ticketService.updatePendingTicketCount(message.PendingItemsCountDtoList);
    }
    ;
    pendingSocialMediaMessageCountReceived(message) {
        if (message?.MessageId === this.socialMediaService.pendingCountMessageId)
            this.socialMediaService.updatePendingSocialMediaCount(message);
    }
    ;
    pendingDocumentsCountReceived(message) {
        if (message?.length > 0)
            this.sessionManager.pendingCount.DocumentCount = message[0].Count;
        else
            this.sessionManager.pendingCount.DocumentCount = 0;
        this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_SPECIFIC_STATISTIC, { Type: 'TOTALOPENPOST', TotalCount: this.sessionManager.pendingCount.DocumentCount, TooltipText: `Post: ${this.sessionManager.pendingCount.DocumentCount}` });
    }
    ;
    getTicketFilterConfigurationResponse(filters) {
        this.timeoutIds.push(setTimeout(() => {
            if (filters == null)
                this.sessionManager.ticketFilters = [];
            else
                this.sessionManager.ticketFilters = filters;
        }, 100));
    }
    ;
};
DashboardComponent = __decorate([
    Component({
        selector: 'dashboard',
        templateUrl: './dashboard.component.html',
        styleUrls: ['./dashboard.component.scss']
    })
], DashboardComponent);
export { DashboardComponent };
//# sourceMappingURL=dashboard.component.js.map