var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component, Input } from '@angular/core';
import { SubSink } from 'subsink';
import { DashboardWidth } from '../../../core/models/dashboard/dashboard-width';
import { ContentType } from '../../../core/models/jkc-object/jkc-object';
import { BroadCastEventKeys, EntityName, RoutePath } from '../../../shared/constants';
import { GlobalFunctions } from '../../../shared/global-functions';
let DashboardItemComponent = class DashboardItemComponent {
    constructor(userSettingManager, systemComponentService, sessionManager, cacheManager, router, eventProvider) {
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.sessionManager = sessionManager;
        this.cacheManager = cacheManager;
        this.router = router;
        this.eventProvider = eventProvider;
        this.dashboardWebparts = [];
        this.dashboardWebTiles = [];
        this.dashboardWidth = new DashboardWidth();
        this.subs = new SubSink();
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.RESIZE_CSN).subscribe(() => setTimeout(() => this.resize(), 1000));
    }
    ngOnInit() {
        setTimeout(() => this.resize(), 1000);
    }
    ngAfterViewInit() {
        $("#dashboardSections").sortable({ containment: "#dashboardWebpartContainer", update: () => this.updateDashboardSequence(), handle: '.jkcSortableList' });
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    clickWebtile(dashboardTile) {
        if (dashboardTile) {
            const webtileType = dashboardTile.Type.toUpperCase();
            if (this.dashboardWebtileType.Contact.includes(webtileType))
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'contacthistory'], { queryParams: { filter: webtileType.toLowerCase() } });
            else if (this.dashboardWebtileType.Task.includes(webtileType))
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'task'], { queryParams: { filter: webtileType.toLowerCase() } });
            else if (this.dashboardWebtileType.Ticket.includes(webtileType))
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'ticket'], { queryParams: { filter: webtileType.toLowerCase() } });
            else if (this.dashboardWebtileType.Social.includes(webtileType))
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'socialmedia'], { queryParams: { filter: webtileType.toLowerCase() } });
            else if (this.dashboardWebtileType.Document.includes(webtileType))
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.LIST_PATH, 'document']);
            else if (this.dashboardWebtileType.Email.includes(webtileType))
                this.router.navigate([RoutePath.DASHBOARD, RoutePath.SEARCH_PATH, 'email']);
        }
    }
    ;
    resize() {
        let windowHeight = window.innerHeight;
        let newHeight = windowHeight - 100 + "px";
        $("#dashboardItemsContainer").height(newHeight);
        let containerWidth = $("#dashboardContainer").width() - $("#dashboardMenu").width() - 10;
        this.dashboardWidth.WebpartLargeWidth = containerWidth - 20 + "px";
        this.dashboardWidth.WebpartSmallWidth = (containerWidth - 10) / 3 - 10 + "px";
        this.dashboardWidth.WebpartMediumWidth = (containerWidth - 10) / 3 * 2 - 10 + "px";
        this.dashboardWidth.WebtileWidth = (containerWidth - 10 * (this.dashboardTilePerRow + 1)) / this.dashboardTilePerRow + 'px';
    }
    getWebTileStyle(webTile) {
        return { 'width': this.dashboardWidth.WebtileWidth, 'background-color': webTile.Color };
    }
    updateDashboardSequence() {
        try {
            let userSettingKey = "USERDASHBOARDITEMSEQUENCE_" + this.selectedDashboardId;
            let xmlValue = "<DASHBOARDITEMLIST>";
            $('#dashboardSections li').each((i, dashboardSection) => {
                let id = dashboardSection.getAttribute('id');
                let webpart = jlinq.from(this.dashboardWebparts).starts("Id", id).first();
                if (webpart != null)
                    xmlValue = xmlValue + "<DASHBOARDITEM ID='" + id + "' ORDER='" + (i + 1) + "' />";
            });
            xmlValue = xmlValue + "</DASHBOARDITEMLIST>";
            this.userSettingManager.setUserSettingValueByKey(userSettingKey, xmlValue);
            let userSettingDto = new Object();
            userSettingDto.Key = userSettingKey;
            userSettingDto.Value = xmlValue;
            userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
            this.systemComponentService.updateUserSetting(userSettingDto);
        }
        catch (e) {
            console.error(e);
        }
    }
    select(item) {
        if (item != null) {
            item.Partial = true;
            let type = GlobalFunctions.getObjectTypeName(item.RelatedEntityFqdn);
            if (!GlobalFunctions.isEmpty(type)) {
                type = type.toLowerCase();
                if (type === 'contactmoment')
                    type = EntityName.CONTACT_HISTORY;
                this.sessionManager.loadedFromRelatedView = false;
                if (item.RelatedEntityFqdn == ContentType.Employee)
                    item = this.cacheManager.getEmployeeById(item.Id);
                this.sessionManager.selectedEntity = item;
                item.locationUrl = `${RoutePath.DETAIL_PATH}/${type}`;
                this.sessionManager.addBreadcrumbItems([item], null, this.router.url);
                this.router.navigate([item.locationUrl]);
            }
        }
    }
    ;
};
__decorate([
    Input()
], DashboardItemComponent.prototype, "dashboardWebparts", void 0);
__decorate([
    Input()
], DashboardItemComponent.prototype, "dashboardWebTiles", void 0);
__decorate([
    Input()
], DashboardItemComponent.prototype, "dashboardTilePerRow", void 0);
__decorate([
    Input()
], DashboardItemComponent.prototype, "selectedDashboardId", void 0);
__decorate([
    Input()
], DashboardItemComponent.prototype, "dashboardWebtileType", void 0);
DashboardItemComponent = __decorate([
    Component({
        selector: 'dashboard-item',
        templateUrl: './dashboard-item.component.html',
        styleUrls: ['./dashboard-item.component.scss'],
        host: { '(window:resize)': 'resize()' }
    })
], DashboardItemComponent);
export { DashboardItemComponent };
//# sourceMappingURL=dashboard-item.component.js.map