var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Component } from '@angular/core';
import { SubSink } from 'subsink';
import { BaseComponent } from '../../components/base-component';
import { EmployeeStatus } from '../../core/models/common/employee-status';
import { BroadCastEventKeys, LocalStorageKey, RoutePath } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
let AppLoaderComponent = class AppLoaderComponent extends BaseComponent {
    constructor(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef, serviceManager, applicationFeatureManager, applicationSettingManager, integrationSettingManager, sessionManager, spinnerService, userService, compressionService, cacheManager, employeeService, eventProvider, systemComponentService) {
        super(translateService, router, zone, dialog, changeDetectorRef, viewContainerRef);
        this.translateService = translateService;
        this.router = router;
        this.zone = zone;
        this.dialog = dialog;
        this.changeDetectorRef = changeDetectorRef;
        this.viewContainerRef = viewContainerRef;
        this.serviceManager = serviceManager;
        this.applicationFeatureManager = applicationFeatureManager;
        this.applicationSettingManager = applicationSettingManager;
        this.integrationSettingManager = integrationSettingManager;
        this.sessionManager = sessionManager;
        this.spinnerService = spinnerService;
        this.userService = userService;
        this.compressionService = compressionService;
        this.cacheManager = cacheManager;
        this.employeeService = employeeService;
        this.eventProvider = eventProvider;
        this.systemComponentService = systemComponentService;
        this.authenticationResult = -1;
        this.subs = new SubSink();
        this.loginResponse = this.loginResponse.bind(this);
        this.setUpdateSearchStatus = this.setUpdateSearchStatus.bind(this);
        this.getLicenseSpecificFeatureResponse = this.getLicenseSpecificFeatureResponse.bind(this);
    }
    ngOnInit() {
        this.showProgressBar = true;
        this.eventProvider.isSessionExpired = false;
        const initAppView = localStorage.getItem(LocalStorageKey.APP_INIT_VIEW);
        if (!GlobalFunctions.isEmpty(initAppView) && initAppView === RoutePath.LOGIN) {
            localStorage.removeItem(LocalStorageKey.APP_INIT_VIEW);
            this.initServiceAndGetSettings();
        }
        else
            this.getNewToken();
    }
    ngOnDestroy() {
        this.subs.unsubscribe();
    }
    initServiceAndGetSettings() {
        this.serviceManager.connect().then(() => {
            if (GlobalFunctions.licenseSpecificFeatureList == null || GlobalFunctions.licenseSpecificFeatureList.length == 0)
                this.systemComponentService.getLicenseSpecificFeature(this.getLicenseSpecificFeatureResponse);
            else
                this.initApplication();
        });
    }
    getLicenseSpecificFeatureResponse(result) {
        this.applicationFeatureManager.getLicenseSpecificFeatureResponse(result);
        this.initApplication();
    }
    initApplication() {
        this.applicationFeatureManager.fetchData();
        this.subs.sink = this.applicationSettingManager.cacheApplicationSettings(this.sessionManager).subscribe(() => {
            this.subs.sink = this.integrationSettingManager.cacheHandlerSettings().subscribe(() => {
                this.subs.sink = this.employeeService.fetchDepartments(this.cacheManager.completedDepartmentsFetch).subscribe(() => {
                    this.sessionManager.isAppLoaded = true;
                    const redirectUrl = localStorage.getItem(LocalStorageKey.REDIRECT_URL);
                    if (!redirectUrl || redirectUrl === '/loading' || (redirectUrl.includes('person?') && !this.sessionManager.isPersonDeeplinkEnabled))
                        super.navigate('/' + RoutePath.DASHBOARD, true);
                    else
                        super.navigate(redirectUrl, true);
                }, () => this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOGOUT));
            }, () => this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOGOUT));
        }, () => this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOGOUT));
    }
    getNewToken() {
        this.userService.connect().then(() => {
            const sessionToken = JSON.parse(GlobalFunctions.getCookie(LocalStorageKey.SESSION_TOKEN));
            if (!GlobalFunctions.isEmpty(sessionToken))
                this.userService.search(sessionToken.LogOnName, '', false, false, this.loginResponse, this.setUpdateSearchStatus);
            else {
                this.spinnerService.stop();
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOGOUT);
            }
        });
    }
    loginResponse(result) {
        if (result?.Result && result.Result == 0) {
            this.authenticationResult = result.Result;
            localStorage.setItem(LocalStorageKey.USER_AUTHENTICATED, 'true');
            this.cacheUserData(result);
            this.initServiceAndGetSettings();
        }
    }
    setUpdateSearchStatus() {
        if (this.authenticationResult != 0)
            this.eventProvider.BroadcastEvent(BroadCastEventKeys.LOGOUT);
    }
    cacheUserData(result) {
        this.sessionManager.isValiduser = true;
        this.sessionManager.userLogOnTypeOption = result.LogOnType;
        if (this.sessionManager.employeeStatus == null)
            this.sessionManager.employeeStatus = new EmployeeStatus();
        this.sessionManager.employeeStatus.loggedInUserTime = GlobalFunctions.getCurrentDateAndTime();
        result.PrivilegeData = this.compressionService.decompressFromUTF16(result.PrivilegeData);
        if (result.PrivilegeData && result.PrivilegeData[0] === '{')
            GlobalFunctions.setPrivilegeData(JSON.parse(result.PrivilegeData), this.sessionManager, this.translateService);
    }
};
AppLoaderComponent = __decorate([
    Component({
        selector: 'app-loader',
        templateUrl: './app-loader.component.html',
        styleUrls: ['./app-loader.component.scss']
    })
], AppLoaderComponent);
export { AppLoaderComponent };
//# sourceMappingURL=app-loader.component.js.map