var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { map } from 'rxjs/operators';
import { environment } from '../../../environments/environment';
import { AppConstants, LocalStorageKey, SignalREvents } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { CommonHelper } from '../../shared/helper/common-helper';
import { ApplicationName, OperationType } from '../enums/common-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let X2JS = require('x2js');
let UserService = class UserService extends BaseService {
    constructor(httpClient, translateService, sessionManager, dialog, router, eventProvider, zone) {
        super(zone, router, httpClient, eventProvider);
        this.httpClient = httpClient;
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.dialog = dialog;
        this.router = router;
        this.eventProvider = eventProvider;
        this.zone = zone;
        this.userGroupIdList = [];
        this.nativeUsergroups = [];
        this.setprofileResponseCallbacks = (setProfileResponseCallback) => {
            this.setProfileResponse = setProfileResponseCallback;
        };
        this.setUICulture = () => {
            this.connection.qs = { "UICulture": this.getLanguageCode() };
        };
        this.getNativeUsergroupList = () => this.nativeUsergroups;
        this.setUserMailboxes = (multipleMailboxConfigValue) => {
            this.sessionManager.userMailboxes = [];
            let x2js = new X2JS();
            let jsonObj = x2js.xml2js(multipleMailboxConfigValue);
            if (jsonObj != null && jsonObj.MAILBOXES != null && jsonObj.MAILBOXES.MAILBOX != null) {
                jsonObj.MAILBOXES.MAILBOX = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jsonObj.MAILBOXES.MAILBOX);
                let mailbox;
                for (let mailboxNumber = 0; mailboxNumber < jsonObj.MAILBOXES.MAILBOX.length; mailboxNumber++) {
                    if (!GlobalFunctions.isEmpty(jsonObj.MAILBOXES.MAILBOX[mailboxNumber]._ISORGANIZATIONDEFAULT) && jsonObj.MAILBOXES.MAILBOX[mailboxNumber]._ISORGANIZATIONDEFAULT.toLowerCase() == 'true')
                        mailbox = { MailboxId: jsonObj.MAILBOXES.MAILBOX[mailboxNumber].MAILBOXLOGINNAME, IsOrganizationDefault: true };
                    else
                        mailbox = { MailboxId: jsonObj.MAILBOXES.MAILBOX[mailboxNumber].MAILBOXLOGINNAME };
                    if (GlobalFunctions.hasAllowDataRights(ContentType.Email, OperationType.Mailboxes, mailbox.MailboxId))
                        this.sessionManager.userMailboxes.push(mailbox);
                }
            }
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            if (!this.connection || this.connection.state === 4) {
                this.isConnecting = true;
                this.connection = $.hubConnection(environment.user_config);
                const cookie = this.isValidToken();
                if (cookie)
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                this.registerServerEvents();
                this.connection.start()
                    .done(() => {
                    this.isConnected = true;
                    this.isConnecting = false;
                    return resolve(true);
                })
                    .fail(() => {
                    this.isConnected = false;
                    this.isConnecting = false;
                    super.serviceStopped(this.translateService.instant('LBL_USER'), this.translateService, this.dialog);
                    return reject('Failed to connect to user service');
                });
                this.connection.disconnected(() => {
                    this.isConnected = false;
                    console.error(`User service disconnected: ${this.connection.lastError}`);
                });
                this.connection.connectionSlow(() => {
                    this.proxy.invoke('ping');
                    console.warn(`User service connection is slow: sending ping to the hub`);
                });
            }
        });
    }
    registerServerEvents() {
        this.proxy.on(SignalREvents.SEARCH_RESULT_FOUND, (result, sessionToken) => {
            console.log('authenticationService->searchResultFound:', result);
            if (!GlobalFunctions.isEmpty(sessionToken)) {
                delete sessionToken.Expires;
                GlobalFunctions.setCookie(LocalStorageKey.SESSION_TOKEN, JSON.stringify(sessionToken));
            }
            if (this.setLoginSearchResponse != null)
                this.setLoginSearchResponse(result);
        });
        this.proxy.on(SignalREvents.UPDATED_SEARCH_STATUS, (result) => {
            console.log('authenticationService->updateSearchStatus:', result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result);
        });
        this.proxy.on(SignalREvents.PROFILE_RESPONSE, result => {
            console.log('UserService -> profileResponse', result);
            if (this.setProfileResponse != null)
                this.setProfileResponse(result);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_USER'), this.translateService, this.dialog));
        this.proxy.on(SignalREvents.SEARCH_ROLE_RESPONSE, result => {
            console.log("UserService -> searchRoleResponse", result);
            if (this.setsearchRoleResponse != null)
                this.setsearchRoleResponse(result);
        });
        this.proxy.on(SignalREvents.TOKEN_FAILED_RESPONSE, () => {
            console.log('UserService -> tokenFailedResponse');
            this.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('sendOtpResponse', result => {
            console.log("UserService -> sendOtpResponse", result);
            if (this.setSendOtpResponse != null)
                this.setSendOtpResponse(result);
        });
        this.proxy.on('verifyOtpResponse', result => {
            console.log("UserService -> verifyOtpResponse", result);
            if (this.setVerifyOtpResponse != null)
                this.setVerifyOtpResponse(result);
        });
    }
    search(username, password, isCookieCredentials, isSingleSignOn, onSuccessCallback, updateSearchStatusCallback) {
        this.setLoginSearchResponse = onSuccessCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.connection.qs = { UICulture: CommonHelper.getLanguageCode() };
        this.proxy.invoke(SignalREvents.SEARCH, username, password, isCookieCredentials, isSingleSignOn, ApplicationName.JoinKlantContact, GlobalFunctions.getLoggedInUserId());
    }
    updateProfile(profileRequest) {
        console.log('userService -> update profile:', Date.now());
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('updateProfile', profileRequest);
        });
    }
    searchRole(setsearchRoleResponseCallback, userId) {
        this.setsearchRoleResponse = setsearchRoleResponseCallback;
        console.log('userService -> search role:', Date.now());
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('searchRole', userId);
        });
    }
    sendOtp(emailAddress, setSendOtpResponseCallback) {
        this.setSendOtpResponse = setSendOtpResponseCallback;
        let cookie = this.isValidToken();
        if (cookie != null) {
            console.log('userService -> send otp:', Date.now());
            let sendOtpRequest = {
                UserId: cookie.UserId,
                SessionId: cookie.Id,
                EmailAddress: emailAddress
            };
            let url = environment.user_config.replace("/signalr", "/post/SendOtp?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, sendOtpRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        console.error('Error occured while sending Otp');
                    });
                }
            });
        }
        else
            this.setSendOtpResponse({ Result: -1 });
    }
    ;
    verifyOtp(emailAddress, otp, setVerifyOtpResponseCallback) {
        this.setVerifyOtpResponse = setVerifyOtpResponseCallback;
        let cookie = this.isValidToken();
        if (cookie != null) {
            console.log('userService -> verify otp:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('verifyOtp', emailAddress, otp, cookie.Id, cookie.UserId);
            });
        }
        else
            this.setVerifyOtpResponse({ Result: -1 });
    }
    ;
    // TODO - check for error handling
    cacheUserPrivilegeData() {
        let userId = GlobalFunctions.getLoggedInUserId();
        if (userId != null && userId != "" && GlobalFunctions.userPrivilegeData == null) {
            let url = environment.oData_config + '/UserPrivilegeData?$filter=ID%20eq%20%27' + userId + '%27';
            console.log(url);
            return this.httpClient.get(url, { headers: this.getHeader() }).pipe(map((data) => {
                console.log('callback of privilegedata cache');
                if (data != null && data.length > 0)
                    GlobalFunctions.setPrivilegeData(JSON.parse(data[0].PrivilegeData), this.sessionManager, this.translateService);
            }));
        }
        else
            return new BehaviorSubject(true);
    }
    ;
    // implement error block
    cacheNativeUsergroups() {
        try {
            if (this.nativeUsergroups && this.nativeUsergroups.length > 0)
                return new BehaviorSubject(this.nativeUsergroups);
            this.nativeUsergroups = Array();
            let url = environment.oData_config + '/UsersGroup';
            console.log(url);
            let sessionToken = GlobalFunctions.getSessionTokenAsString();
            if (sessionToken != null) {
                return this.httpClient.get(url, { headers: { sessionToken } }).pipe(map((data) => {
                    console.log('callback of department odata response');
                    if (data != null && data.length > 0) {
                        for (let index = 0; index < data.length; index++) {
                            if (data[index].Id != undefined && data[index].IsNative == true)
                                this.nativeUsergroups.push(data[index]);
                        }
                    }
                }));
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
};
UserService = __decorate([
    Injectable({ providedIn: 'root' })
], UserService);
export { UserService };
//# sourceMappingURL=user-service.js.map