var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { AlternateSearchType, OperationType } from '../enums/common-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { DeleteThemeRequest } from '../models/theme/delete-theme-request';
import { BaseService } from './base-service';
let ThemeService = class ThemeService extends BaseService {
    constructor(zone, router, dialog, httpClient, cacheManager, eventProvider, translateService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.dialog = dialog;
        this.httpClient = httpClient;
        this.cacheManager = cacheManager;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setThemeDetailResponse = null;
            this.setViewerRelatedThemeResultFound = null;
        };
        this.setRelatedResultCallback = (setRelatedThemeResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedThemeResultFound = setRelatedThemeResultFoundCallback;
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedThemeResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedThemeResultFound = setViewerRelatedThemeResultFoundCallback;
        };
        this.search = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            if (GlobalFunctions.hasRight(ContentType.Theme, OperationType.View)) {
                this.setSearchResultFound = searchResultFoundCallback;
                this.setUpdateSearchStatus = updateSearchStatusCallback;
                isAllSourceRequest = GlobalFunctions.isEmpty(isAllSourceRequest) ? false : isAllSourceRequest;
                this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
                this.searchQuery = query;
                alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
                handler = handler != undefined ? handler : "";
                this.messageId = GlobalFunctions.createGuid();
                console.log("themeService->search:", this.searchQuery);
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke("search", this.searchQuery, this.messageId, isAllSourceRequest);
                });
            }
        };
        this.advancedSearch = (searchDto, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            if (GlobalFunctions.hasRight(ContentType.Theme, OperationType.View)) {
                this.setSearchResultFound = searchResultFoundCallback;
                this.setUpdateSearchStatus = updateSearchStatusCallback;
                this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
                alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
                handler = handler != undefined ? handler : "";
                sourceLocation = sourceLocation != undefined ? sourceLocation : "";
                this.messageId = GlobalFunctions.createGuid();
                console.log('themeService->advancedSearch:', searchDto);
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('advancedSearch', searchDto, this.messageId);
                });
            }
        };
        this.fetchDetail = (partialDto, themeDetailResponseCallback) => {
            this.setThemeDetailResponse = themeDetailResponseCallback;
            console.log('themeService -> fetchThemeDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('fetchDetail', partialDto);
            });
        };
        this.addTheme = (createOrUpdateThemeRequest, createOrUpdateThemeCallback, createOrUpdateThemeErrorCallback) => {
            this.setThemeOpCompleted = createOrUpdateThemeCallback;
            const cookie = this.isValidToken();
            const url = environment.theme_config.replace("/signalr", "/post/PostThemeXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, createOrUpdateThemeRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (createOrUpdateThemeErrorCallback)
                            createOrUpdateThemeErrorCallback();
                    });
                }
            });
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.theme_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_THEME_PAGE'), this.translateService, this.dialog);
                        return reject('Failed to connect to theme service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Theme service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Theme service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for theme service');
        });
    }
    registerServerEvents() {
        this.proxy.on("searchStartedNotification", message => {
            console.log("themeService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on("searchCompletedNotification", message => {
            console.log("themeService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on("updateSearchStatus", (result, messageId) => {
            console.log("themeService -> updateSearchStatus:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setUpdateSearchStatus != null)
                    this.setUpdateSearchStatus(result);
            }
        });
        this.proxy.on("searchResultFound", (result, messageId) => {
            console.log("themeService -> searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null) {
                    for (let index = 0; index < result.length; index++) {
                        let employeeDto = this.cacheManager.getEmployeeById(result[index].CreatedBy);
                        if (employeeDto != null)
                            result[index].CreatedByText = employeeDto.StringRepresentation;
                        else
                            result[index].CreatedByText = '';
                    }
                    this.setSearchResultFound(result);
                }
            }
        });
        this.proxy.on('relatedThemeResultFound', (result, messageId) => {
            console.log("themeService->relatedThemeResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedThemeResultFound != null) {
                    for (let index = 0; index < result.length; index++) {
                        let employeeDto = this.cacheManager.getEmployeeById(result[index].CreatedBy);
                        if (employeeDto != null)
                            result[index].CreatedByText = employeeDto.StringRepresentation;
                        else
                            result[index].CreatedByText = '';
                    }
                    this.setRelatedThemeResultFound(result, "Theme", this.translateService.instant("LBL_THEME"));
                }
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedThemeResultFound != null) {
                    for (let index = 0; index < result.length; index++) {
                        let employeeDto = this.cacheManager.getEmployeeById(result[index].CreatedBy);
                        if (employeeDto != null)
                            result[index].CreatedByText = employeeDto.StringRepresentation;
                        else
                            result[index].CreatedByText = '';
                    }
                    this.setViewerRelatedThemeResultFound(result, "Theme", this.translateService.instant("LBL_THEME"));
                }
            }
        });
        this.proxy.on('themeDetailResponse', result => {
            console.log("themeService->themeDetailResponse:", result);
            if (this.setThemeDetailResponse != null) {
                this.setThemeDetailResponse(result);
                this.setThemeDetailResponse = null;
            }
        });
        this.proxy.on('createOrUpdateThemeCompleted', response => {
            console.log('add theme response --> ' + response);
            if (this.setThemeOpCompleted != null)
                this.setThemeOpCompleted(response);
        });
        this.proxy.on('deleteThemeResponse', response => {
            console.log('ThemeService -> deleteThemeResponse');
            if (this.setThemeDeleteResponse != null)
                this.setThemeDeleteResponse(response);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_THEME_PAGE'), this.translateService, this.dialog));
        this.proxy.on('tokenFailedResponse', () => this.sessionExpired(this.translateService, this.dialog));
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Theme, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Theme, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
    deleteTheme(themeDto, entityDeleteResponseCallback) {
        this.setThemeDeleteResponse = entityDeleteResponseCallback;
        if (themeDto) {
            console.log('themeService -> deleting theme:', Date.now());
            let deleteThemeRequest = new DeleteThemeRequest();
            deleteThemeRequest.ThemeDto = new Object();
            deleteThemeRequest.ThemeDto.Id = themeDto.Id;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('DeleteTheme', JSON.stringify(deleteThemeRequest));
            });
        }
    }
};
ThemeService = __decorate([
    Injectable({ providedIn: 'root' })
], ThemeService);
export { ThemeService };
//# sourceMappingURL=theme-service.js.map