var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { OperationType } from '../enums/common-enums';
import { EntityFqdn } from '../enums/core-enums';
import { TaskHandlerType, TaskStatus } from '../enums/task-enum';
import { BaseDto } from '../models/common/baseDto';
import { RelatedEntityDto } from '../models/common/related-enityDto';
import { ContentType } from '../models/jkc-object/jkc-object';
import { DeleteTaskRequest } from '../models/task/delete-task-request';
import { TaskHandlerDto } from '../models/task/task-handlerDto';
import { TaskHistoryDto } from '../models/task/task-historyDto';
import { BaseService } from './base-service';
let TaskService = class TaskService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, sessionManager, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.dialog = dialog;
        this.DateJS = Date;
        this.setMultipleFetchDetailResponse = [];
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.lastAppliedFilters = [];
        this.filterOptions = [];
        this.sessionMessageId = "";
        this.pendingCountMessageId = "";
        this.scheduleWorkList = [];
        this.setRelatedResultCallback = (setRelatedTaskResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedTaskResultFound = setRelatedTaskResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedTaskResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedTaskResultFound = setViewerRelatedTaskResultFoundCallback;
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.setExternalAppointmentCallback = externalAppointmentCallback => {
            this.setExternalAppointmentResponse = externalAppointmentCallback;
        };
        this.setTaskRemindersCallback = setGetTaskRemindersCallback => {
            this.setGetTaskRemindersResponse = setGetTaskRemindersCallback;
        };
        this.setAllMeetingRoomsCallbacks = setAllMeetingRoomsCompleteCallback => {
            this.setAllMeetingRoomsReceived = setAllMeetingRoomsCompleteCallback;
        };
        this.startSessionResponseCallbacks = setstartSessionResponseCallback => {
            this.startSessionResponseCallback = setstartSessionResponseCallback;
        };
        this.setLockEntityResponseCallback = (lockEntityResponseCallback) => {
            this.lockEntityResponse = lockEntityResponseCallback;
        };
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setRelatedTaskResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.startSessionResponseCallback = null;
            this.setCBNLimitDetailCallback = null;
            this.lockEntityResponse = null;
            this.setViewerRelatedTaskResultFound = null;
        };
        //<<SESSION>>
        this.searchSession = (searchDto, messageId, searchSessionResponse, setUpdateSearchStatusResponse) => {
            this.sessionMessageId = messageId;
            this.setSearchSessionResponse = searchSessionResponse;
            this.setUpdateSearchSessionStatus = setUpdateSearchStatusResponse;
            console.log('taskService->searchSessionRequest');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('SearchSession', searchDto, messageId);
            });
        };
        this.createOrUpdateSession = (sessionDto, createOrUpdateSessionResponse, exceptionCallbackStatus) => {
            this.setCreateOrUpdateResponse = createOrUpdateSessionResponse;
            let cookie = this.isValidToken();
            let url = environment.task_config.replace("/signalr", "/post/PostSessionXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, sessionDto).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (exceptionCallbackStatus)
                            exceptionCallbackStatus(1);
                    });
                }
            });
        };
        this.handleSession = (sessionId, handleSessionResponse) => {
            this.setHandleSessionResponse = handleSessionResponse;
            console.log('taskService->handleSession');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('HandleSession', sessionId);
            });
        };
        this.hasPendingSession = () => {
            console.log('taskService->HasPendingSession');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('HasPendingSession');
            });
        };
        this.lockOrUnlockSession = (sessionId, sessionStatus) => {
            console.log('taskService->lockOrUnlockSession');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('lockOrUnlockSession', sessionId, sessionStatus);
            });
        };
        this.getPendingSessionsCount = (messageId, pendingSessionsCountCallback) => {
            console.log('taskService->getPendingSessionsCount:', Date.now());
            this.setPendingSessionsCountResponse = pendingSessionsCountCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke("GetPendingSessionCount", GlobalFunctions.getLoggedInUserId(), messageId);
            });
        };
        this.replyInformationRequest = (taskDto, replyIRResponseCallback, replyIRRelatedErrorCallback) => {
            this.setReplyIRResponse = replyIRResponseCallback;
            console.log('taskService -> replyInformationRequest');
            let cookie = this.isValidToken();
            let url = environment.task_config.replace("/signalr", "/post/PostReplyIRXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, taskDto).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (replyIRRelatedErrorCallback)
                            replyIRRelatedErrorCallback(1);
                    });
                }
            });
        };
        this.fetchLocationsWiseProducts = (publicId, setfetchLocationWiseProductCallback) => {
            console.log('taskService -> setfetchLocationWiseProductCallback');
            this.fetchLocationsWiseProductResponse = setfetchLocationWiseProductCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchLocationsWiseProducts', publicId);
            });
        };
        this.fetchProductWiseDateTimes = (request, setfetchProductWiseDateTimesCallback) => {
            console.log('taskService -> setfetchProductWiseDateTimesCallback');
            this.fetchProductWiseDateTimesResponse = setfetchProductWiseDateTimesCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchProductWiseDateAndTimes', JSON.stringify(request));
            });
        };
        this.fetchAvailabilityRelatedToProduct = (request) => {
            console.log('taskService -> FetchAvailabiltyRelatedProduct');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchAvailabilityRelatedToProduct', request);
            });
        };
        this.forwardTask = (taskDto, forwardTaskType, forwardTaskCallback, forwardTaskErrorCallback) => {
            console.log('taskService -> forwardTask:', taskDto);
            this.forwardTaskResponseReceived = forwardTaskCallback;
            let cookie = this.isValidToken();
            let inputData = { 'taskDto': taskDto, 'taskType': forwardTaskType };
            let url = environment.task_config.replace("/signalr", "/post/PostForwardTaskXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, inputData).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (forwardTaskErrorCallback)
                            forwardTaskErrorCallback();
                    });
                }
            });
        };
        this.sendCallbackAttemptRequest = (taskDto, isRescheduleRequired, callbackAttemptTaskResponseCallback, taskCallbackAttemptRelatedErrorCallback) => {
            let sendBasketRequest = new Object();
            sendBasketRequest.TaskDto = taskDto;
            sendBasketRequest.IsRescheduleRequired = isRescheduleRequired;
            this.setCallbackAttemptTaskResponse = callbackAttemptTaskResponseCallback;
            let cookie = this.isValidToken();
            let url = environment.task_config.replace("/signalr", "/post/PostCallbackAttemptXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, sendBasketRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (taskCallbackAttemptRelatedErrorCallback)
                            taskCallbackAttemptRelatedErrorCallback();
                    });
                }
            });
        };
        this.deleteTask = (taskDto, entityDeleteResponseCallback) => {
            this.setTaskDeleteResponse = entityDeleteResponseCallback;
            if (taskDto) {
                console.log('taskService -> deleting task:', Date.now());
                let deleteTaskRequest = new DeleteTaskRequest();
                deleteTaskRequest.TaskDto = new Object();
                deleteTaskRequest.TaskDto.Id = taskDto.Id;
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('DeleteTask', JSON.stringify(deleteTaskRequest));
                });
            }
        };
        this.getPendingTasksCount = (messageId, pendingTasksCountCallback) => {
            console.log('pendingItems -> getPendingTasksCount:', Date.now());
            this.setPendingTasksCountResponse = pendingTasksCountCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke("GetPendingItemsCount", GlobalFunctions.getLoggedInUserId(), messageId, this.sessionManager.roleId);
            });
        };
        this.advancedSearch = (searchDto, messageId, setSearchResultFoundCallback, setUpdateSearchStatusCallback) => {
            this.messageId = messageId;
            this.setSearchResultFound = setSearchResultFoundCallback;
            this.setUpdateSearchStatus = setUpdateSearchStatusCallback;
            console.log('taskService -> advancedSearch:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('advancedSearch', searchDto, messageId, this.sessionManager.roleId);
            });
        };
        this.fetchDetail = (partialDto, fetchDetailCallback) => {
            this.setFetchDetailResponse = fetchDetailCallback;
            let baseEntity = new Object();
            baseEntity.Id = partialDto.Id;
            baseEntity.ObjectSource = partialDto.ObjectSource;
            console.log('taskService -> fetchDetail:', baseEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', baseEntity, this.sessionManager.roleId);
            });
        };
        this.makeAppointmentExternal = (taskDto) => {
            console.log('taskService -> makeAppointmentExternal');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('MakeAppointmentExternal', taskDto);
            });
        };
        this.fetchLocationsRelatedToAppointment = (setfetchAppointmentRelatedLocationCallback) => {
            this.fetchAppointmentRelatedLocationResponse = setfetchAppointmentRelatedLocationCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchLocationsRelatedToAppointment');
            });
        };
        this.sendReminder = (taskIdList) => {
            console.log('taskService -> sendReminder');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('SendReminder', taskIdList);
            });
        };
        this.getTaskReminders = (startDate, endDate) => {
            console.log('taskService -> fetching task reminders:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getTaskReminders', startDate, endDate);
            });
        };
        this.getRecentActivities = (query) => {
            console.log('taskService -> fetching recent contact activities:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getRecentActivities', query, this.relatedMessageId, this.sessionManager.roleId);
            });
        };
        this.bulkHandleTask = (bulkHandleTaskRequest, bulkHandleTaskResponseCallback, errorCallback) => {
            this.setBulkHandleTaskResponse = bulkHandleTaskResponseCallback;
            console.log('taskService -> bulk handle task:', Date.now());
            let cookie = this.isValidToken();
            let url = environment.task_config.replace("/signalr", "/post/PostBulkHandleTaskXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.httpClient.post(url, bulkHandleTaskRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (errorCallback)
                            errorCallback();
                    });
            });
        };
        this.getAllMeetingRooms = (startDate, endDate) => {
            console.log('taskService -> getting all meeting rooms', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getAllMeetingRooms', startDate, endDate);
            });
        };
        this.createReport = (exportReportRequest, createReportCallback) => {
            console.log('taskService -> creating report:', Date.now());
            this.setCreateReportResponse = createReportCallback;
            let cookie = this.isValidToken();
            let url = environment.task_config.replace("/signalr", "/post/PostCreateReportXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, exportReportRequest).subscribe(result => {
                        console.log(result);
                    }, error => {
                        console.error(error);
                    });
                }
            });
        };
        this.fetchStatistic = (fetchStatisticResponseCallback) => {
            console.log('taskService -> fetchStatistic');
            this.setFetchStatisticResponse = fetchStatisticResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('fetchStatistic', this.sessionManager.roleId);
            });
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.task_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_TASK'), this.translateService, this.dialog);
                        return reject('Failed to connect to task service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Task service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Task service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for task service');
        });
    }
    registerServerEvents() {
        this.proxy.on('createTaskResponse', (result, response) => {
            console.log("taskService -> createTaskComplete", result);
            if (this.setCreateTaskComplete != null)
                this.setCreateTaskComplete(response);
            else {
                if (result != 0) {
                    if (!GlobalFunctions.isEmpty(response.TaskId))
                        this.sessionManager.removeFromDetailViewCachedEntityList(response.TaskId);
                }
            }
            this.setCreateTaskComplete = null;
        });
        this.proxy.on('handleTaskResponse', result => {
            console.log("taskService -> handleTaskResponse", result);
            if (this.setHandleTaskResponse != null)
                this.setHandleTaskResponse(result);
        });
        this.proxy.on('replyIRResponse', result => {
            console.log("taskService -> replyIRResponse", result);
            if (this.setReplyIRResponse != null)
                this.setReplyIRResponse(result);
        });
        this.proxy.on('forwardTaskResponseReceived', result => {
            console.log("taskService -> forwardTaskResponseReceived:", result);
            if (this.forwardTaskResponseReceived != null)
                this.forwardTaskResponseReceived(result);
        });
        this.proxy.on('callbackAttemptTaskResponse', result => {
            console.log("taskService -> callbackAttemptTaskResponse", result);
            if (this.setCallbackAttemptTaskResponse != null)
                this.setCallbackAttemptTaskResponse(result);
        });
        this.proxy.on('deleteTaskEntityResponse', response => {
            console.log('taskService -> deleteTaskResponse');
            if (this.setTaskDeleteResponse != null)
                this.setTaskDeleteResponse(response);
        });
        this.proxy.on('searchResultFound', (result, messageId) => {
            console.log("taskService -> searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result);
            }
        });
        this.proxy.on('updateSearchStatus', (result, messageId) => {
            console.log("taskService -> updateSearchStatus:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setUpdateSearchStatus != null)
                    this.setUpdateSearchStatus(result);
            }
        });
        this.proxy.on('relatedTaskResultFound', (result, messageId) => {
            console.log("taskService -> relatedTaskResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedTaskResultFound != null)
                    this.setRelatedTaskResultFound(result, "Task", this.translateService.instant("LBL_TASKS"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedTaskResultFound != null)
                    this.setViewerRelatedTaskResultFound(result, "Task", this.translateService.instant("LBL_TASKS"));
            }
        });
        this.proxy.on('taskBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_TASK'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("taskService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("taskService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('detailResponse', result => {
            console.log("taskService -> detailResponse:", result);
            if (this.setFetchDetailResponse != null)
                this.setFetchDetailResponse(result);
            if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0) {
                $.each(this.setMultipleFetchDetailResponse, (index) => { this.setMultipleFetchDetailResponse[index](result); });
            }
        });
        this.proxy.on('externalAppointmentResponse', result => {
            console.log("taskService -> externalAppointmentResponse:", result);
            if (this.setExternalAppointmentResponse != null)
                this.setExternalAppointmentResponse(result);
        });
        this.proxy.on('pendingItemCountResponse', result => {
            console.log("taskService -> pendingItemCountResponse:", result);
            if (this.setPendingTasksCountResponse != null)
                this.setPendingTasksCountResponse(result);
        });
        this.proxy.on('createReportResponse', result => {
            console.log("taskService -> createReportResponse");
            if (this.setCreateReportResponse != null)
                this.setCreateReportResponse(result);
        });
        this.proxy.on('getTaskRemindersResponse', result => {
            console.log("taskService -> getTaskRemindersResponse");
            if (this.setGetTaskRemindersResponse != null)
                this.setGetTaskRemindersResponse(result);
        });
        this.proxy.on('bulkHandleTaskResponse', result => {
            console.log("taskService -> bulkHandleTaskResponse", result);
            if (this.setBulkHandleTaskResponse != null)
                this.setBulkHandleTaskResponse(result);
        });
        this.proxy.on('allMeetingRoomsReceived', (response) => {
            console.log("taskService -> allMeetingRoomsReceived");
            if (this.setAllMeetingRoomsReceived != null)
                this.setAllMeetingRoomsReceived(response);
        });
        this.proxy.on('fetchAppointmentRelatedProductResponse', result => {
            console.log("taskService -> fetchAppointmentRelatedProductResponse:", result);
            if (this.fetchAppointmentRelatedProductResponse != null)
                this.fetchAppointmentRelatedProductResponse(result);
        });
        this.proxy.on('fetchAvailabilityRelatedToProductResponse', result => {
            console.log("taskService -> fetchAvailabilityRelatedToProductCallback", result);
            if (this.fetchAvailabilityRelatedToProductCallback != null)
                this.fetchAvailabilityRelatedToProductCallback(result);
        });
        this.proxy.on('fetchAppointmentRelatedLocationResponse', result => {
            console.log("taskService -> fetchAppointmentRelatedLocationResponse:", result);
            if (this.fetchAppointmentRelatedLocationResponse != null)
                this.fetchAppointmentRelatedLocationResponse(result);
        });
        this.proxy.on('fetchLocationsWiseProductResponse', result => {
            console.log("taskService -> fetchLocationsWiseProductResponse:", result);
            if (this.fetchLocationsWiseProductResponse != null)
                this.fetchLocationsWiseProductResponse(result);
        });
        this.proxy.on('fetchProductWiseDateTimesResponse', result => {
            console.log("taskService -> fetchProductWiseDateTimesResponse:", result);
            if (this.fetchProductWiseDateTimesResponse != null)
                this.fetchProductWiseDateTimesResponse(result);
        });
        this.proxy.on('getCBNLimitResponse', response => {
            console.log("taskService -> GetCBNLimitResponse:", response);
            if (this.setCBNLimitDetailCallback != null)
                this.setCBNLimitDetailCallback(response);
        });
        this.proxy.on('startSessionResponse', response => {
            console.log("taskService -> startSessionResponse:", response);
            if (this.startSessionResponseCallback != null)
                this.startSessionResponseCallback(response);
        });
        this.proxy.on('lockEntityResponse', response => {
            console.log("taskService -> lockEntityResponse ");
            if (this.lockEntityResponse != null)
                this.lockEntityResponse(response);
        });
        this.proxy.on('updateSearchSessionStatus', (result, messageId) => {
            console.log("taskService -> updateSearchSessionStatus:", result);
            if (this.sessionMessageId == "" || this.sessionMessageId == messageId) {
                if (this.setUpdateSearchSessionStatus != null)
                    this.setUpdateSearchSessionStatus(result);
            }
        });
        this.proxy.on('searchSessionResponse', (message, messageId) => {
            console.log("taskService->searchSessionResponse:", message);
            if (this.sessionMessageId == "" || this.sessionMessageId == messageId) {
                if (this.setSearchSessionResponse != null)
                    this.setSearchSessionResponse(message);
            }
        });
        this.proxy.on('createOrUpdateSessionResponse', message => {
            console.log("taskService->createOrUpdateSessionResponse:", message);
            if (this.setCreateOrUpdateResponse != null)
                this.setCreateOrUpdateResponse(message);
        });
        this.proxy.on('handleSessionResponse', message => {
            console.log("taskService->handleSessionResponse:", message);
            if (this.setHandleSessionResponse != null)
                this.setHandleSessionResponse(message);
        });
        this.proxy.on('hasPendingSessionResponse', hasPendingSession => {
            this.sessionManager.hasPendingSession = hasPendingSession;
            console.log('taskService -> response of HasPendingSession: ' + hasPendingSession);
        });
        this.proxy.on('pendingSessionCountResponse', result => {
            console.log("taskService -> pendingSessionCountResponse:", result);
            if (this.setPendingSessionsCountResponse != null)
                this.setPendingSessionsCountResponse(result);
        });
        this.proxy.on('sessionBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_SESSION'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('fetchStatisticResponse', response => {
            console.log("taskService -> fetchStatisticResponse");
            if (this.setFetchStatisticResponse != null)
                this.setFetchStatisticResponse(response);
        });
        this.proxy.on('fetchRelatedProductsResponse', response => {
            console.log("taskService -> fetchRelatedProductsResponse");
            if (this.fetchRelatedProductsResponse != null)
                this.fetchRelatedProductsResponse(response);
        });
        this.proxy.on('fetchAppointmentAvailableSlotsResponse', response => {
            console.log("taskService -> fetchAppointmentAvailableSlotsResponse");
            if (this.fetchAppointmentAvailableSlotsResponse != null)
                this.fetchAppointmentAvailableSlotsResponse(response);
        });
        this.proxy.on('bookAppointmentResponse', response => {
            console.log("taskService -> bookAppointmentResponse");
            if (this.bookAppointmentResponse != null)
                this.bookAppointmentResponse(response);
        });
        this.proxy.on('fetchAppointmentDetailResponse', response => {
            console.log("taskService -> fetchAppointmentDetailResponse");
            if (this.fetchAppointmentDetailResponse != null)
                this.fetchAppointmentDetailResponse(response);
        });
        this.proxy.on('deleteAppointmentResponse', response => {
            console.log("taskService -> deleteAppointmentResponse");
            if (this.deleteAppointmentResponse != null)
                this.deleteAppointmentResponse(response);
        });
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_TASK'), this.translateService, this.dialog));
    }
    createTask(task, createTaskCompleteCallback, errorCallbackFunction, createSendEmailResponseComplete) {
        this.setCreateTaskComplete = createTaskCompleteCallback;
        let cookie = this.isValidToken();
        let url = environment.task_config.replace("/signalr", "/post/PostTaskXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, task).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallbackFunction)
                        errorCallbackFunction(1);
                });
            }
        });
    }
    ;
    handleTask(taskDto, handleTaskResponseCallback, taskHandleRelatedErrorCallback) {
        this.setHandleTaskResponse = handleTaskResponseCallback;
        console.log('taskService -> handleTask');
        let cookie = this.isValidToken();
        let handleTaskRequest = new Object();
        handleTaskRequest.SessionId = cookie.Id;
        handleTaskRequest.UICulture = this.getLanguageCode();
        handleTaskRequest.TaskDto = taskDto;
        handleTaskRequest.RoleId = this.sessionManager.roleId;
        let url = environment.task_config.replace("/signalr", "/post/PostHandleTaskXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, JSON.stringify(handleTaskRequest)).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (taskHandleRelatedErrorCallback)
                        taskHandleRelatedErrorCallback(1);
                });
            }
        });
    }
    ;
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Task, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId, this.sessionManager.roleId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Task, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId, this.sessionManager.roleId);
            });
        }
    }
    ;
    getCBNLimitDetail(handlerId, startTime, getCBNLimitDetailCallback) {
        console.log('taskService -> getting department callback limit:', handlerId);
        this.setCBNLimitDetailCallback = getCBNLimitDetailCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('getCBNLimit', handlerId, startTime);
        });
    }
    ;
    lookingOnTask(applyLock, taskId) {
        let taskDto = new Object();
        taskDto.Id = taskId;
        taskDto.LookingBy = applyLock ? GlobalFunctions.getLoggedInUserId() : null;
        console.log('taskService -> lookingOnTask request: ' + taskId + ' & lock: ' + applyLock);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('lookingOnTask', taskDto);
        });
    }
    ;
    lockUnlockTask(applyLock, taskId) {
        let taskDto = new Object();
        taskDto.Id = taskId;
        taskDto.LockedBy = applyLock ? GlobalFunctions.getLoggedInUserId() : null;
        console.log('taskService -> lock unlock request: ' + taskId + ' & lock: ' + applyLock);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('LockUnlockTask', taskDto);
        });
    }
    ;
    handleAssignmentTask(cacheManager) {
        let assignmentTask = cacheManager.relatedResultList["TASK"][0];
        let taskHistoryDto = new TaskHistoryDto();
        taskHistoryDto.DateRecorded = new this.DateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        taskHistoryDto.Status = TaskStatus.Handled;
        taskHistoryDto.CreatedById = GlobalFunctions.getLoggedInUserId();
        let taskHandler = new TaskHandlerDto();
        taskHandler.HandlerId = GlobalFunctions.getLoggedInUserId();
        taskHandler.HandlerType = TaskHandlerType.Employee;
        let baseDtoObject = new BaseDto();
        baseDtoObject.Id = taskHandler.HandlerId;
        taskHandler.HandlerObject = baseDtoObject;
        taskHistoryDto.TaskHandlerList = [];
        taskHistoryDto.TaskHandlerList.push(taskHandler);
        assignmentTask.TaskHistoryList = [];
        assignmentTask.TaskHistoryList.push(taskHistoryDto);
        assignmentTask.CurrentStatus = TaskStatus.Handled;
        assignmentTask.Result = '';
        assignmentTask.ResultFreeText = '';
        let cachedEntities = this.sessionManager.detailViewCachedEntityList;
        if (!GlobalFunctions.isEmpty(cachedEntities)) {
            assignmentTask.RelatedEntityList = [];
            cachedEntities.forEach(value => {
                if (!GlobalFunctions.isEmpty(value) && !GlobalFunctions.isEmpty(value.key) && value.value == EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_SocialMedia].toString()) {
                    let relatedEntityDto = new RelatedEntityDto();
                    relatedEntityDto.RelatedEntityId = value.key.Id;
                    let actualEntityType = value.value.replace(/\./g, '_');
                    relatedEntityDto.EntityType = EntityFqdn["" + actualEntityType + ""];
                    relatedEntityDto.ObjectSource = value.key.ObjectSource;
                    assignmentTask.RelatedEntityList.push(relatedEntityDto);
                }
            });
        }
        this.handleTask(assignmentTask, null, this.taskHandleRelatedErrorCallback);
    }
    ;
    taskHandleRelatedErrorCallback() {
        let exception = ExceptionHelper.create(this.translateService.instant("LBL_ERROR_MSG"), this.translateService.instant("LBL_CALLBACK_ATTEMPT_ERROR_MSG"), this.translateService.instant("LBL_TASK"));
        ExceptionHelper.showException(this.dialog, exception, true);
    }
    ;
    fetchRelatedProducts(fetchRelatedProductsCallback) {
        console.log('taskService -> fetchRelatedProducts');
        this.fetchRelatedProductsResponse = fetchRelatedProductsCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('fetchRelatedProducts');
        });
    }
    fetchAppointmentAvailableSlots(locationId, productId, date, amount, fetchAppointmentAvailableSlotsCallback) {
        console.log('taskService -> fetchAppointmentAvailableSlots');
        this.fetchAppointmentAvailableSlotsResponse = fetchAppointmentAvailableSlotsCallback;
        let appointmentDate = date.toDateString();
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('fetchAppointmentAvailableSlots', productId, locationId, appointmentDate, amount);
        });
    }
    bookAppointment(bookappointmentRequest, bookAppointmentCallback) {
        console.log('taskService -> bookAppointment');
        this.bookAppointmentResponse = bookAppointmentCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('bookAppointment', bookappointmentRequest);
        });
    }
    fetchAppointmentDetail(id, fetchAppointmentDetailCallback) {
        console.log('taskService -> fetchAppointmentDetail');
        this.fetchAppointmentDetailResponse = fetchAppointmentDetailCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('fetchAppointmentDetail', id);
        });
    }
    deleteAppointment(id, deleteAppointmentCallback) {
        console.log('taskService -> deleteAppointment');
        this.deleteAppointmentResponse = deleteAppointmentCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('deleteAppointment', id);
        });
    }
};
TaskService = __decorate([
    Injectable({ providedIn: 'root' })
], TaskService);
export { TaskService };
//# sourceMappingURL=task-service.js.map