var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants, BroadCastEventKeys } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { MostSelectedType, OperationType } from '../enums/common-enums';
import { EntityLockDto } from '../models/entity-lock/entity-lockDto';
import { LockEntityRequest } from '../models/entity-lock/lock-entity-request';
import { ContentType } from '../models/jkc-object/jkc-object';
import { SystemComponentsEntityDetailLogDto } from '../models/system-component/system-component-entity-detail-logDto';
import { SystemComponentsMainEntityLogDto } from '../models/system-component/system-component-mian-entity-logDto';
import { BaseService } from './base-service';
import { SubSink } from 'subsink';
import { KeywordPopularItemDto } from '../models/popular/keyword-popular-itemDto';
let SystemComponentService = class SystemComponentService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, sessionManager, dialog, searchService, applicationSettingManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.sessionManager = sessionManager;
        this.dialog = dialog;
        this.searchService = searchService;
        this.applicationSettingManager = applicationSettingManager;
        this.DateJS = Date;
        this.subs = new SubSink();
        this.updateUserSetting = userSettingDto => {
            console.log('SystemComponentService -> updateUserSetting');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('updateUserSetting', userSettingDto);
            });
        };
        this.updateUserSettingForCalendarWeekView = enableWorkweekCheck => {
            console.log('SystemComponentService -> updateUserSettingForCalendarWeekView');
            let userSettingDto = new Object();
            userSettingDto.Key = "CalendarWeekView";
            userSettingDto.Value = enableWorkweekCheck;
            userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('updateUserSetting', userSettingDto);
            });
        };
        this.updateUserSettingForThemeSectionsArrangement = themeSectionArrangement => {
            console.log('SystemComponentService -> updateUserSettingForThemeSectionsArrangement');
            let userSettingDto = new Object();
            userSettingDto.Key = "ThemeSectionArrangement";
            userSettingDto.Value = themeSectionArrangement;
            userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('updateUserSetting', userSettingDto);
            });
        };
        this.logPopularEntity = keywordPopulatItemDto => {
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('logPopularEntity', keywordPopulatItemDto);
            });
        };
        this.getEntityLinkItems = (contentType, entityId, entitySource, getEntityLinkItemsCallback) => {
            this.getEntityLinkItemsResponse = getEntityLinkItemsCallback;
            console.log('Get entity link items request');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getEntityLinkItems', contentType, entityId, entitySource);
            });
        };
        this.getSourceLocations = (sourceLocationCallback) => {
            this.getSourceLocationsResponse = sourceLocationCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getSourceLocations');
            });
        };
        this.getEntityHistory = (objectType, objectId, objectSource, privateFields, entityHistoryCallback) => {
            console.log('Get entity history request');
            this.entityHistoryResponse = entityHistoryCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getEntityHistory', objectType, objectId, objectSource, privateFields);
            });
        };
        this.setMainEntity = mainEntity => {
            let mainEntityLogDto = new SystemComponentsMainEntityLogDto();
            if (mainEntity != null) {
                let userId = GlobalFunctions.getLoggedInUserId();
                let objectId = GlobalFunctions.getValueByPropertyName("Id", mainEntity);
                let objectSource = GlobalFunctions.getValueByPropertyName("ObjectSource", mainEntity);
                let contentType = GlobalFunctions.getContentTypeByPropertyName("RelatedEntityFqdn", mainEntity);
                if (objectId != null && objectSource != null) {
                    mainEntityLogDto.ObjectType = contentType;
                    mainEntityLogDto.ObjectId = objectId;
                    mainEntityLogDto.ObjectSource = objectSource;
                    mainEntityLogDto.UserId = userId;
                    mainEntityLogDto.RoleId = this.roleId;
                    mainEntityLogDto.Weight = 1;
                    mainEntityLogDto.UserType = 1;
                    mainEntityLogDto.OnDateTime = new Date();
                    mainEntityLogDto.EntityDetailLog = new SystemComponentsEntityDetailLogDto();
                    mainEntityLogDto.EntityDetailLog.ObjectId = mainEntityLogDto.ObjectId;
                    mainEntityLogDto.EntityDetailLog.ObjectSource = mainEntityLogDto.ObjectSource;
                    mainEntityLogDto.EntityDetailLog.UserId = userId;
                    //Note : No need to set the partial = true since we fetch all the information about the product during search result
                    let objectTypeName = GlobalFunctions.getObjectTypeName(contentType);
                    mainEntityLogDto.EntityDetailLog.ObjectItem = GlobalFunctions.setEntityType(mainEntity, GlobalFunctions.toJsonFqdnType(objectTypeName));
                }
            }
            return mainEntityLogDto;
        };
        this.handleCustomContextMenuItemsCallback = (response) => {
            this.sessionManager.customContextMenuItems = response.CustomContextMenuContentList;
        };
        this.customContextMenuItems = (setcustomContextMenuItemsResponseCallback) => {
            this.customContextMenuItemsResponseReceived = setcustomContextMenuItemsResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('GetCustomContextMenuItems');
            });
        };
        this.getLicenseSpecificFeature = (setLicenseSpecificFeatureResponseCallback) => {
            this.setLicenseSpecificFeatureResponse = setLicenseSpecificFeatureResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getLicenseSpecificFeature');
            });
        };
        this.clearAllEntityLock = () => {
            console.log('systemComponentService -> clearAllEntityLock');
            this.lockEntity(null, null, null);
        };
        //Merge letter template
        this.mergeLetterTemplate = (mergeTemplateDto, mergeTemplateType, createAs, letterTemplateId, mergeLetterTemplateCallback) => {
            this.mergeLetterTemplateResponse = mergeLetterTemplateCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('MergeLetterTemplate', JSON.stringify(mergeTemplateDto), mergeTemplateType, createAs, letterTemplateId);
            });
        };
        this.searchMostSelectedByMe = (userId, searchMostSelectedResponseCallback) => {
            console.log('systemComponentService -> searchMostSelectedByMe');
            this.searchMostSelectedResponseByMe = searchMostSelectedResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('SearchMostSelected', MostSelectedType.ByMe, userId);
            });
        };
        this.searchMostSelectedByRole = (roleId, searchMostSelectedResponseCallback) => {
            console.log('systemComponentService -> searchMostSelectedByRole');
            this.searchMostSelectedResponseByRole = searchMostSelectedResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('SearchMostSelected', MostSelectedType.ByRole, roleId);
            });
        };
        this.searchMostSelectedByEveryone = (searchMostSelectedResponseCallback) => {
            console.log('systemComponentService -> searchMostSelectedEveryone');
            this.searchMostSelectedResponseByEveryone = searchMostSelectedResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('SearchMostSelected', MostSelectedType.ByEveryone, "");
            });
        };
        this.searchFavourite = (searchFavouriteResponseCallback) => {
            console.log('systemComponentService -> searchFavourite');
            this.searchFavouriteResponse = searchFavouriteResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchFavourite');
            });
        };
        this.makeFavourite = (favouriteDto, mode) => {
            console.log('systemComponentService -> makeFavourite');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('makeFavourite', favouriteDto, mode);
            });
        };
        //News
        this.clearNewsCallbacks = () => {
            this.setSearchNewsResultFound = null;
            this.setUpdateSearchNewsStatus = null;
            this.setSearchNewsStarted = null;
            this.setSearchNewsCompleted = null;
            this.setRelatedNewsResultFound = null;
            this.setNewsDetailResponse = null;
            this.setViewerRelatedNewsResultFound = null;
        };
        this.searchNews = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, setSearchResultFoundCallback, setUpdateSearchStatusCallback, alternateSearchResponseFoundCallback, alternateSearchSuggestionsResponseFoundCallback) => {
            this.setSearchNewsResultFound = setSearchResultFoundCallback;
            this.setUpdateSearchNewsStatus = setUpdateSearchStatusCallback;
            this.newsMessageId = GlobalFunctions.getGuid();
            isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchNews', query, isAllSourceRequest, this.newsMessageId);
            });
        };
        this.setNewsRelatedResultCallback = (setRelatedNewsResultFoundCallback, messageId) => {
            this.newsMessageId = messageId;
            this.setRelatedNewsResultFound = setRelatedNewsResultFoundCallback;
        };
        this.setViewerNewsRelatedResultCallback = (setViewerRelatedNewsResultFoundCallback, messageId) => {
            this.viewerNewsMessageId = messageId;
            this.setViewerRelatedNewsResultFound = setViewerRelatedNewsResultFoundCallback;
        };
        this.setSearchNewsNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchNewsStarted = setSearchStartedNotificationCallback;
            this.setSearchNewsCompleted = setSearchCompletedNotificationCallback;
        };
        this.sendNewsRelatedRequest = (selectedEntity) => {
            if (GlobalFunctions.hasRight(ContentType.News, OperationType.View)) {
                let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity, '');
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('searchNewsRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.newsMessageId);
                });
            }
        };
        this.sendViewerNewsRelatedRequest = (selectedEntity) => {
            if (GlobalFunctions.hasRight(ContentType.News, OperationType.View)) {
                let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity, '');
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('searchNewsRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerNewsMessageId);
                });
            }
        };
        this.fetchNewsDetail = (partialDto, newsDetailResponseCallback) => {
            this.setNewsDetailResponse = newsDetailResponseCallback;
            console.log('systemComponentService -> fetchNewsDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchNewsDetail', partialDto);
            });
        };
        this.generateSummary = (summarizeDocumentRequest, summarizedDocumentResponseCallback, summarizedDocumentErrorCallback) => {
            console.log('summarizeDocumentService -> generating summary:', Date.now());
            this.getSummarizedDocumentResponse = summarizedDocumentResponseCallback;
            let cookie = this.isValidToken();
            let url = environment.system_component_config.replace("/signalr", "/post/PostSummarizeDocumentXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, summarizeDocumentRequest).subscribe({
                        next: result => {
                            console.log(result);
                        },
                        error: error => {
                            console.error('Summarize error:', error);
                            if (summarizedDocumentErrorCallback != null)
                                summarizedDocumentErrorCallback();
                        }
                    });
                }
            });
        };
        this.subs.sink = this.eventProvider.event(BroadCastEventKeys.LOAD_SELECTED_ENTITY_IN_DETAIL).subscribe(entity => {
            if (!GlobalFunctions.isEmpty(entity)) {
                var entityType = GlobalFunctions.getObjectTypeName(entity.RelatedEntityFqdn).toLowerCase();
                if (!GlobalFunctions.isEmpty(entityType) && entity.Partial == false && (entityType.toLowerCase().indexOf("product") == 0 || entityType.toLowerCase().indexOf("questionanswer") == 0 || (entityType.toLowerCase().indexOf("theme") == 0 && entity.locationUrl == null && entity.IsPublished == true))) {
                    this.storeMainEntity();
                }
                if (!GlobalFunctions.isEmpty(entityType) && entity.Partial == false && entityType.toLowerCase().indexOf("person") < 0 && this.searchService.selectedSearchOption != null && !GlobalFunctions.isEmpty(this.searchService.selectedSearchOption.searchType) && this.searchService.selectedSearchOption.searchType.indexOf(entityType) > -1 && (sessionManager.loadedFromRelatedView == undefined || (sessionManager.loadedFromRelatedView != undefined && !sessionManager.loadedFromRelatedView))) {
                    if ((entityType.toLowerCase().indexOf("theme") == 0 && entity.IsPublished == false))
                        return;
                    var selectedItemDto = this.setKeywordPopularItemDto(entity);
                    this.logPopularEntity(selectedItemDto);
                }
            }
        });
    }
    setKeywordPopularItemDto(selectedEntity) {
        let keywordPopularItemDto = new KeywordPopularItemDto();
        if (!GlobalFunctions.isEmpty(selectedEntity)) {
            let userId = GlobalFunctions.getLoggedInUserId();
            let objectId = GlobalFunctions.getValueByPropertyName("Id", selectedEntity);
            let objectSource = GlobalFunctions.getValueByPropertyName("ObjectSource", selectedEntity);
            let contentType = GlobalFunctions.getValueByPropertyName("RelatedEntityFqdn", selectedEntity);
            let objectDisplayName = GlobalFunctions.getValueByPropertyName("StringRepresentation", selectedEntity);
            if (!GlobalFunctions.isEmpty(objectId) && !GlobalFunctions.isEmpty(objectSource)) {
                keywordPopularItemDto.Keyword = this.searchService.searchQuery;
                keywordPopularItemDto.EntityId = objectId;
                keywordPopularItemDto.EntitySource = objectSource;
                keywordPopularItemDto.DisplayName = objectDisplayName;
                keywordPopularItemDto.ContentType = contentType;
                keywordPopularItemDto.CreatedBy = userId;
                keywordPopularItemDto.CreatedDate = new Date();
            }
        }
        return keywordPopularItemDto;
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.system_component_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_SYSTEM_COMPONENT'), this.translateService, this.dialog);
                        return reject('Failed to connect to system component service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`System component service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`System component service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for system component service');
        });
    }
    registerServerEvents() {
        this.proxy.on('logPopularEntityComplete', result => {
            console.log("systemComponentService -> logPopularEntityComplete:", result);
        });
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('updateSearchNewsStatus', result => {
            if (this.setUpdateSearchNewsStatus != null)
                this.setUpdateSearchNewsStatus(result);
        });
        this.proxy.on('businessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_NEWS'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('sendMailResponse', (response) => {
            console.log("systemComponentService -> setSendEmailResponseComplete", response);
            if (this.setSendEmailResponseComplete != null)
                this.setSendEmailResponseComplete(response);
        });
        this.proxy.on('getSourceLocationsResponse', response => {
            if (this.getSourceLocationsResponse != null)
                this.getSourceLocationsResponse(response);
        });
        this.proxy.on('getEntityLinkItemsResponse', response => {
            console.log('Received entity link items response --> ' + response);
            if (this.getEntityLinkItemsResponse != null)
                this.getEntityLinkItemsResponse(response);
        });
        this.proxy.on('linkUnlinkEntityItemsResponse', response => {
            console.log('Received link/unlink entity items response --> ' + response);
            if (this.linkUnlinkEntityItemsResponse != null)
                this.linkUnlinkEntityItemsResponse(response);
        });
        this.proxy.on('getCustomContextMenuItemsResponseReceived', result => {
            if (this.customContextMenuItemsResponseReceived != null)
                this.customContextMenuItemsResponseReceived(result);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_SYSTEM_COMPONENT'), this.translateService, this.dialog));
        this.proxy.on('getEntityHistoryResponse', result => {
            console.log("systemService -> entityHistoryResponse ");
            if (this.entityHistoryResponse != null)
                this.entityHistoryResponse(result);
        });
        this.proxy.on('getLicenseSpecificFeatureResponse', result => {
            if (this.setLicenseSpecificFeatureResponse != null)
                this.setLicenseSpecificFeatureResponse(result);
        });
        this.proxy.on('mergeLetterTemplateResponse', response => {
            console.log("systemService -> mergeLetterTemplateResponse ");
            if (this.mergeLetterTemplateResponse != null)
                this.mergeLetterTemplateResponse(response);
        });
        this.proxy.on('lockEntityResponse', response => {
            console.log("systemService -> lockEntityResponse ");
            if (this.lockEntityResponse != null)
                this.lockEntityResponse(response);
        });
        this.proxy.on('searchMostSelectedResponse', response => {
            console.log("systemService -> searchMostSelectedResponse ");
            if (response.MostSelectedResponseType == MostSelectedType.ByMe && this.searchMostSelectedResponseByMe != null)
                this.searchMostSelectedResponseByMe(response);
            else if (response.MostSelectedResponseType == MostSelectedType.ByRole && this.searchMostSelectedResponseByRole != null)
                this.searchMostSelectedResponseByRole(response);
            else if (this.searchMostSelectedResponseByEveryone != null)
                this.searchMostSelectedResponseByEveryone(response);
        });
        this.proxy.on('searchFavouriteResponse', response => {
            console.log("systemService -> searchFavouriteResponse ");
            if (this.searchFavouriteResponse != null)
                this.searchFavouriteResponse(response);
        });
        this.proxy.on('searchNewsResultFound', (result, messageId) => {
            if (this.newsMessageId == "" || this.newsMessageId == messageId) {
                if (this.setSearchNewsResultFound != null)
                    this.setSearchNewsResultFound(result);
            }
        });
        this.proxy.on('searchNewsStartedNotification', message => {
            if (this.newsMessageId == "" || this.newsMessageId == message.MessageId) {
                if (this.setSearchNewsStarted != null)
                    this.setSearchNewsStarted(message);
            }
        });
        this.proxy.on('searchNewsCompletedNotification', message => {
            if (this.newsMessageId == "" || this.newsMessageId == message.MessageId) {
                if (this.setSearchNewsCompleted != null)
                    this.setSearchNewsCompleted(message);
            }
        });
        this.proxy.on('newsDetailResponse', result => {
            console.log("systemService -> newsDetailResponse:", result);
            if (this.setNewsDetailResponse != null)
                this.setNewsDetailResponse(result);
        });
        this.proxy.on('relatedNewsResultFound', (result, messageId) => {
            console.log("systemService -> relatedNewsResultFound:", result);
            if (this.newsMessageId == "" || this.newsMessageId == messageId) {
                if (this.setRelatedNewsResultFound != null)
                    this.setRelatedNewsResultFound(result, "News", this.translateService.instant("LBL_NEWS"));
            }
            else if (this.viewerNewsMessageId == "" || this.viewerNewsMessageId == messageId) {
                if (this.setViewerRelatedNewsResultFound != null)
                    this.setViewerRelatedNewsResultFound(result, "News", this.translateService.instant("LBL_NEWS"));
            }
        });
        this.proxy.on('summarizeDocumentResponse', response => {
            console.log("systemService -> summarizeDocumentResponse ");
            if (this.getSummarizedDocumentResponse != null)
                this.getSummarizedDocumentResponse(response);
        });
    }
    linkUnlinkEntityItems(linkUnlinkEntityItemsRequest, linkUnlinkResponseCallback, linkUnlinkErrorCallback) {
        console.log('Send link/unlink entity items request', Date.now());
        this.linkUnlinkEntityItemsResponse = linkUnlinkResponseCallback;
        let cookie = this.isValidToken();
        let url = environment.system_component_config.replace("/signalr", "/post/PostLinkUnlinkEntityItemsXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.httpClient.post(url, linkUnlinkEntityItemsRequest).subscribe(result => {
                    console.log(result);
                }, err => {
                    if (linkUnlinkErrorCallback != null)
                        linkUnlinkErrorCallback();
                });
        });
    }
    ;
    storeMainEntity() {
        let mainEntityLogDto = this.setMainEntity(this.sessionManager.selectedEntity);
        //for removing description in theme scenario
        if (!GlobalFunctions.isEmpty(mainEntityLogDto.ObjectSource) && mainEntityLogDto.ObjectSource.toLowerCase().indexOf("theme") != -1 && !GlobalFunctions.isEmpty(mainEntityLogDto.EntityDetailLog.ObjectItem) && !GlobalFunctions.isEmpty(mainEntityLogDto.EntityDetailLog.ObjectItem.Description))
            mainEntityLogDto.EntityDetailLog.ObjectItem.Description = '';
        console.log('systemComponentService -> storing the entity loaded in the detail view :', Date.now());
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('logMainEntity', JSON.stringify(mainEntityLogDto));
        });
    }
    ;
    logUnsuccessfullAttempts(logUnsucessfullAttemptsRequest, errorCallback) {
        console.log('systemComponentService -> logUnsuccessfullAttempts');
        let cookie = this.isValidToken();
        let url = environment.system_component_config.replace("/signalr", "/post/PostUnsuccessfullAttemptsXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, logUnsucessfullAttemptsRequest).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (errorCallback)
                        errorCallback();
                });
            }
        });
    }
    ;
    lockEntity(id, relatedEntityFqdn, lockEntityResponseCallback) {
        console.log('systemComponentService -> lockEntity');
        this.lockEntityResponse = lockEntityResponseCallback;
        let lockEntityRequest = new LockEntityRequest();
        lockEntityRequest.EntityLockDto = new EntityLockDto();
        lockEntityRequest.EntityLockDto.LockedBy = GlobalFunctions.getLoggedInUserId();
        if (id != null) {
            lockEntityRequest.IsLocked = true;
            lockEntityRequest.EntityLockDto.EntityId = id;
            lockEntityRequest.EntityLockDto.EntityType = relatedEntityFqdn;
            lockEntityRequest.EntityLockDto.LockedOn = new this.DateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
        }
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('LockEntity', lockEntityRequest);
        });
    }
    ;
    clearSessionToken() {
        return new Promise(resolve => {
            const userId = GlobalFunctions.getLoggedInUserId();
            console.log('systemComponentService -> clearSessionToken:', userId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('ClearSessionToken', userId);
                return resolve();
            });
        });
    }
    search(query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback) {
        this.searchNews(query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, null, null);
    }
    clearCallbacks() {
        this.clearNewsCallbacks();
    }
};
SystemComponentService = __decorate([
    Injectable({ providedIn: 'root' })
], SystemComponentService);
export { SystemComponentService };
//# sourceMappingURL=system-component-service.js.map