var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { GlobalFunctions } from 'src/app/shared/global-functions';
import { DialogHelper } from 'src/app/shared/helper/dialog-helper';
import { SessionStatus, UIState } from '../enums/session-enum';
import { BaseService } from './base-service';
let SessionService = class SessionService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, taskService, translateService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.taskService = taskService;
        this.translateService = translateService;
        this.pendingCountMessageId = "";
    }
    searchSession(searchDto, messageId, searchSessionResponse, setUpdateSearchStatusResponse) {
        this.taskService.searchSession(searchDto, messageId, searchSessionResponse, setUpdateSearchStatusResponse);
    }
    createOrUpdateSession(sessionDto, createOrUpdateSessionResponse, exceptionCallbackStatus) {
        this.taskService.createOrUpdateSession(sessionDto, createOrUpdateSessionResponse, exceptionCallbackStatus);
    }
    handleSession(sessionId, handleSessionResponse) {
        this.taskService.handleSession(sessionId, handleSessionResponse);
    }
    hasPendingSession() {
        this.taskService.hasPendingSession();
    }
    lockOrUnlockSession(sessionId, sessionStatus) {
        this.taskService.lockOrUnlockSession(sessionId, sessionStatus);
    }
    getPendingSessionsCount(messageId, pendingSessionsCountCallback) {
        this.taskService.getPendingSessionsCount(messageId, pendingSessionsCountCallback);
    }
    keepSession(sessionManager, applicationFeatureManager, localize, callbackResponse, createSessionErrorCallback) {
        let sessionUIDetail = { uiState: UIState.ContactHistory, uiObject: null };
        if (sessionManager.jkcParentPanel && sessionManager.jkcParentPanel.parameters && sessionManager.jkcParentPanel.parameters.IsUsed) {
            let scope = sessionManager.jkcParentPanel.parameters.Scope;
            if (!GlobalFunctions.isEmpty(scope))
                sessionManager.getSessionUIDetails(scope, sessionUIDetail);
        }
        DialogHelper.closeDialog();
        let sessionDescription = this.translateService.instant("LBL_SAVED_SESSION");
        if (applicationFeatureManager.isShowNextEmailFeatureEnabled && !GlobalFunctions.isEmpty(sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(sessionManager.selectedEntity.RelatedEntityFqdn) && GlobalFunctions.getObjectTypeName(sessionManager.selectedEntity.RelatedEntityFqdn).toLowerCase() == "email" && !GlobalFunctions.isEmpty(sessionManager.selectedEntity.Header.Subject))
            sessionDescription = sessionManager.selectedEntity.Header.Subject;
        if (!GlobalFunctions.isEmpty(sessionManager.currentSession) && !GlobalFunctions.isEmpty(sessionManager.currentSession.Description))
            sessionDescription = sessionManager.currentSession.Description;
        let session = sessionManager.createCurrentSession(SessionStatus.Park, sessionDescription, null, sessionUIDetail.uiObject, sessionUIDetail.uiState, sessionManager.sessionStartDateTime);
        this.createOrUpdateSession(session, callbackResponse, createSessionErrorCallback);
    }
};
SessionService = __decorate([
    Injectable({ providedIn: 'root' })
], SessionService);
export { SessionService };
//# sourceMappingURL=session-service.js.map