var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { BroadCastEventKeys, RoutePath } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { validateSearchCriteriaFunctions } from '../../shared/validate-search-criteria-functions';
import { DEFAULTSEARCHTYPEOPTION, LicenseSpecificFeature, OperationType } from '../enums/common-enums';
import { EntityFqdn } from '../enums/core-enums';
import { SearchOption } from '../models/common/serach-option';
import { BaseService } from './base-service';
let SearchService = class SearchService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, applicationSettingManager, datePipe) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.datePipe = datePipe;
        this.searchQuery = '';
        this.searchOptions = [];
        this.advancedSearchQuery = '';
        this.advancedSearchOption = null;
        this.selectedSearchOption = null;
        this.isAdvancedSearch = false;
        this.isLeftMenuSearch = false;
        this.isAutoCompleteSearch = false;
        this.isSearchFromPopup = false;
        this.isLocalSearch = false;
        this.searchEntities = [
            { type: 'products', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Products_Entities_Product]), score: 100, validation: validateSearchCriteriaFunctions.isValidProductSearchCriteria, url: 'product' },
            { type: 'questionanswers', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Faqs_Entities_QuestionAnswer]), score: 90, validation: validateSearchCriteriaFunctions.isValidQuestionAnswerSearchCriteria, url: 'questionanswer' },
            { type: 'persons', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person]), score: 80, validation: validateSearchCriteriaFunctions.isValidPersonSearchCriteria, url: 'person' },
            { type: 'organizations', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization]), score: 70, validation: validateSearchCriteriaFunctions.isValidOrganizationSearchCriteria, url: 'organization' },
            { type: 'caseentity', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity]), score: 60, validation: validateSearchCriteriaFunctions.isValidCaseSearchCriteria, url: 'caseentity' },
            { type: 'documents', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Documents_Entities_Document]), score: 50, validation: validateSearchCriteriaFunctions.isValidNumber, url: 'document' },
            { type: 'fileentity', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Files_Entities_FileEntity]), score: 40, validation: validateSearchCriteriaFunctions.isValidText, url: 'fileentity' },
            { type: 'themes', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Themes_Entities_Theme]), score: 35, validation: validateSearchCriteriaFunctions.isValidText, url: 'theme' },
            { type: 'links', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Links_Entities_Link]), score: 30, validation: validateSearchCriteriaFunctions.isValidText, url: 'link' },
            { type: 'tickets', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Tickets_Entities_Ticket]), score: 30, validation: validateSearchCriteriaFunctions.isValidText, url: 'ticket' },
            { type: 'locations', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Locations_Entities_AddressableObjectMark]), score: 25, validation: validateSearchCriteriaFunctions.isValidAllSourceSearchCriteria, url: 'location' },
            { type: 'allSources', entityFqdn: '', score: 20, validation: validateSearchCriteriaFunctions.isValidAllSourceSearchCriteria, url: 'allsources' },
            { type: 'issues', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Issues_Entities_Issue]), score: 30, validation: validateSearchCriteriaFunctions.isValidText, url: 'issue' },
            { type: 'news', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_News_Entities_Item]), score: 30, validation: validateSearchCriteriaFunctions.isValidText, url: 'news' },
            { type: 'employee', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Employees_Entities_Employee]), score: 100, validation: null, url: 'employee' },
            { type: 'noteentity', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Notes_Entities_NoteEntity]), score: 100, validation: null, url: 'noteentity' },
            { type: 'task', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Tasks_Entities_Task]), score: 100, validation: null, url: 'task' },
            { type: 'email', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email]), score: 100, validation: null, url: 'email' },
            { type: 'socialmedia', entityFqdn: GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_SocialMedia_Entities_SocialMedia]), score: 100, validation: null, url: 'socialmedia' }
        ];
    }
    advanceSearch(advanceSearchOption) {
        this.advancedSearchOption = advanceSearchOption;
        this.loadSearchResult(advanceSearchOption);
    }
    ;
    searchOptionChanged(selectedSearchOption) {
        this.selectedSearchOption = selectedSearchOption;
        this.loadSearchResult(selectedSearchOption);
    }
    loadSearchResult(selectedSearchOption) {
        const selectedEntity = jlinq.from(this.searchEntities).starts("type", selectedSearchOption.searchType).first();
        const domain = selectedEntity == undefined ? selectedSearchOption.searchType : selectedEntity.url;
        if (selectedEntity != null && selectedEntity.type == "locations") {
            this.searchQuery = this.searchQuery.split('<div')[0];
            selectedSearchOption.searchQuery = this.searchQuery;
        }
        if (selectedSearchOption.selectable) // check CSN tag click
            this.searchQuery = selectedSearchOption.searchQuery;
        let newUrl = '';
        if (selectedSearchOption.searchFrom != undefined && selectedSearchOption.searchFrom === "dashboard")
            newUrl = `${RoutePath.DASHBOARD}/${RoutePath.LIST_PATH}/${domain}`;
        else
            newUrl = `${RoutePath.LIST_PATH}/${domain}`;
        if (this.router.url.includes(RoutePath.LIST_PATH))
            newUrl != this.router.url.substring(1) ? this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_SEARCH_VIEW, { domain, searchQuery: this.searchQuery }) : this.eventProvider.BroadcastEvent(BroadCastEventKeys.UPDATE_SEARCH_RESULTS, this.searchQuery);
        if (!selectedSearchOption.searchSubType) {
            if (selectedEntity?.type == 'email' && !GlobalFunctions.isEmpty(selectedSearchOption.filter)) {
                const queryParams = { filter: selectedSearchOption.filter };
                if (!GlobalFunctions.isEmpty(selectedSearchOption.mailboxId))
                    queryParams.mailbox = selectedSearchOption.mailboxId;
                this.router.navigate([newUrl], { queryParams });
            }
            else
                this.router.navigate([newUrl]);
        }
        else
            this.router.navigate([newUrl, selectedSearchOption.searchSubType]);
    }
    ;
    addSearchOption(searchQuery) {
        this.searchQuery = searchQuery;
        this.searchOptions = [];
        let defaultSelectionFromApplicationSettings = this.applicationSettingManager.getApplicationSettingValueByKey("DefaultSearchTypeOption");
        this.defaultSelectionForText = DEFAULTSEARCHTYPEOPTION[defaultSelectionFromApplicationSettings]?.toLowerCase();
        this.searchEntities.forEach(searchEntity => {
            if (searchEntity.entityFqdn == '' || GlobalFunctions.hasRight(searchEntity.entityFqdn, OperationType.View)) {
                if (searchEntity.type == "locations") {
                    if (GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.AddressesAndBuildings)) {
                        let locationTemplate = "";
                        if (!GlobalFunctions.isEmpty(this.applicationSettingManager.getApplicationSettingValueByKey("CurrentLocation")))
                            locationTemplate = '<div id="currentLocationBtn" style="cursor:pointer; float:right;" class="jkcLocation jkcSizeMedium popularHeader" title="' + this.translateService.instant('LBL_CURRENT_LOCATION') + '"></div>';
                        let searchOption = new SearchOption(this.searchQuery, "locations", true, null, this.translateService, '', true, 20, locationTemplate, false, searchEntity.entityFqdn);
                        this.searchOptions.push(searchOption);
                    }
                }
                else {
                    if (!this.checkLicenseForLicenseBasedFeature(searchEntity.type))
                        return;
                    if (searchEntity.type.toLowerCase() == this.defaultSelectionForText) {
                        if (!validateSearchCriteriaFunctions.isValidText(this.searchQuery))
                            this.defaultSelectionForText = "";
                        switch (this.defaultSelectionForText) {
                            case DEFAULTSEARCHTYPEOPTION[DEFAULTSEARCHTYPEOPTION.Persons].toLowerCase(): {
                                searchEntity.validation = validateSearchCriteriaFunctions.isValidPersonSearchCriteriaWithText;
                                break;
                            }
                            case DEFAULTSEARCHTYPEOPTION[DEFAULTSEARCHTYPEOPTION.Caseentity].toLowerCase(): {
                                searchEntity.validation = validateSearchCriteriaFunctions.isValidCaseSearchCriteriaWithText;
                                break;
                            }
                            case DEFAULTSEARCHTYPEOPTION[DEFAULTSEARCHTYPEOPTION.Documents].toLowerCase(): {
                                searchEntity.validation = validateSearchCriteriaFunctions.isValidDecoumentSearchCriteriaWithText;
                                break;
                            }
                        }
                    }
                    let searchOption = new SearchOption(this.searchQuery, searchEntity.type, true, null, this.translateService, '', searchEntity.validation(this.searchQuery), searchEntity.score, "", searchEntity.type.toLowerCase() == this.defaultSelectionForText ? true : false, searchEntity.entityFqdn);
                    this.searchOptions.push(searchOption);
                }
            }
        });
        this.searchOptions.forEach(option => {
            if (this.applicationSettingManager.sourceLocations[option.searchType.toUpperCase()] != undefined) {
                option.multipleSources = this.applicationSettingManager.sourceLocations[option.searchType.toUpperCase()];
                option.isMultiple = true;
                if (this.applicationSettingManager.getAllowMultipleSourceSearch(option.entityFqdn))
                    option.allowMultipleSourceSearch = true;
                else
                    option.allowMultipleSourceSearch = false;
            }
        });
    }
    ;
    checkLicenseForLicenseBasedFeature(searchEntityType) {
        switch (searchEntityType) {
            case "themes":
                return GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Theme);
            case "tickets":
                return GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Ticket);
            case "issues":
                return GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.Issue);
            case "task":
            case "email":
            case "employee":
            case "noteentity":
            case "socialmedia":
                return false;
            default:
                return true;
        }
    }
    ;
};
SearchService = __decorate([
    Injectable({ providedIn: 'root' })
], SearchService);
export { SearchService };
//# sourceMappingURL=search-service.js.map