var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { GlobalFunctions } from '../../shared/global-functions';
import { FieldDataType, RuleCriteriaType, RuleActionType } from '../enums/common-enums';
import { BaseService } from './base-service';
let RuleService = class RuleService extends BaseService {
    constructor(zone, router, httpClient, eventProvider) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.dateJS = Date;
        this.setHandlerCallback = null;
        this.descriptionFieldName = 'OMSCHRIJVING';
        this.resultFieldName = 'RESULTAAT';
    }
    criteria(ticket, criteria) {
        let isCriteriaPassed = false;
        let field = this.getField(ticket, criteria.FieldId);
        if (field.DataType == FieldDataType.ListMultiSelect) {
            if (!GlobalFunctions.isEmpty(criteria.Value) && !GlobalFunctions.isEmpty(field.DisplayData)) {
                let criteriaEntries = criteria.Value.split(';');
                switch (criteria.Type) {
                    case RuleCriteriaType.EqualsTo:
                        if (criteriaEntries.length != field.DisplayData.length)
                            return;
                        else {
                            for (let displayData of field.DisplayData) {
                                for (let criteriaEntry of criteriaEntries) {
                                    isCriteriaPassed = displayData.Key.toUpperCase() == criteriaEntry.toUpperCase();
                                    if (isCriteriaPassed)
                                        break;
                                }
                                if (!isCriteriaPassed)
                                    break;
                            }
                        }
                        break;
                    case RuleCriteriaType.NotEqualsTo:
                        if (criteriaEntries.length != field.DisplayData.length)
                            isCriteriaPassed = true;
                        else {
                            let isEntryFound = false;
                            for (let displayData of field.DisplayData) {
                                for (let criteriaEntry of criteriaEntries) {
                                    isEntryFound = displayData.Key.toUpperCase() == criteriaEntry.toUpperCase();
                                    if (isEntryFound)
                                        break;
                                }
                                if (!isEntryFound) {
                                    isCriteriaPassed = true;
                                    break;
                                }
                            }
                        }
                        break;
                }
            }
        }
        // Allow empty value like field.Data = "" (but don't allow null or undefined values)
        else if (field.Data !== null && field.Data !== undefined) {
            switch (criteria.Type) {
                case RuleCriteriaType.EqualsTo:
                    if (field.DataType == FieldDataType.DateTime)
                        isCriteriaPassed = new this.dateJS(field.Data.toString()).getTime() == new this.dateJS(criteria.Value.toString()).getTime();
                    else
                        isCriteriaPassed = criteria.Value.toString().toUpperCase() == field.Data.toString().toUpperCase();
                    break;
                case RuleCriteriaType.NotEqualsTo:
                    if (field.DataType == FieldDataType.DateTime)
                        isCriteriaPassed = new this.dateJS(field.Data.toString()).getTime() != new this.dateJS(criteria.Value.toString()).getTime();
                    else
                        isCriteriaPassed = criteria.Value.toString().toUpperCase() != field.Data.toString().toUpperCase();
                    break;
                case RuleCriteriaType.Contains:
                    isCriteriaPassed = field.Data.toUpperCase().indexOf(criteria.Value.toUpperCase()) > -1;
                    break;
                case RuleCriteriaType.LessThan:
                    if (field.DataType == FieldDataType.Numeric)
                        isCriteriaPassed = parseInt(field.Data) < parseInt(criteria.Value);
                    else if (field.DataType == FieldDataType.DateTime)
                        isCriteriaPassed = new this.dateJS(field.Data) < new this.dateJS(criteria.Value);
                    break;
                case RuleCriteriaType.GreaterThan:
                    if (field.DataType == FieldDataType.Numeric)
                        isCriteriaPassed = parseInt(field.Data) > parseInt(criteria.Value);
                    else if (field.DataType == FieldDataType.DateTime)
                        isCriteriaPassed = new this.dateJS(field.Data) > new this.dateJS(criteria.Value);
                    break;
                case RuleCriteriaType.LessThanEqualsTo:
                    if (field.DataType == FieldDataType.Numeric)
                        isCriteriaPassed = parseInt(field.Data) <= parseInt(criteria.Value);
                    else if (field.DataType == FieldDataType.DateTime)
                        isCriteriaPassed = new this.dateJS(field.Data) <= new this.dateJS(criteria.Value);
                    break;
                case RuleCriteriaType.GreaterThanEqualsTo:
                    if (field.DataType == FieldDataType.Numeric)
                        isCriteriaPassed = parseInt(field.Data) >= parseInt(criteria.Value);
                    else if (field.DataType == FieldDataType.DateTime)
                        isCriteriaPassed = new this.dateJS(field.Data) >= new this.dateJS(criteria.Value);
                    break;
                case RuleCriteriaType.Between:
                    if (field.DataType == FieldDataType.Numeric) {
                        let numericValues = criteria.Value.split(';');
                        if (!GlobalFunctions.isEmpty(numericValues) && numericValues.length == 2)
                            isCriteriaPassed = parseInt(field.Data) >= parseInt(numericValues[0]) && parseInt(field.Data) <= parseInt(numericValues[1]);
                    }
                    else if (field.DataType == FieldDataType.DateTime) {
                        let dates = criteria.Value.split(';');
                        if (!GlobalFunctions.isEmpty(dates) && dates.length == 2)
                            isCriteriaPassed = new this.dateJS(field.Data) >= new this.dateJS(dates[0]) && new this.dateJS(field.Data) <= new this.dateJS(dates[1]);
                    }
                    break;
                default:
                    break;
            }
        }
        else if (!GlobalFunctions.isEmpty(field.TooltipText)) {
            let fieldValue = '';
            if (field.TooltipText.toUpperCase().indexOf(this.descriptionFieldName) == 0)
                fieldValue = ticket.Description;
            else if (field.TooltipText.toUpperCase().indexOf(this.resultFieldName) == 0)
                fieldValue = ticket.Result;
            switch (criteria.Type) {
                case RuleCriteriaType.EqualsTo:
                    isCriteriaPassed = criteria.Value.toString().toUpperCase() == fieldValue.toUpperCase();
                    break;
                case RuleCriteriaType.NotEqualsTo:
                    isCriteriaPassed = criteria.Value.toString().toUpperCase() != fieldValue.toUpperCase();
                    break;
                case RuleCriteriaType.Contains:
                    isCriteriaPassed = fieldValue.toUpperCase().indexOf(criteria.Value.toUpperCase()) > -1;
                    break;
                default:
                    break;
            }
        }
        return isCriteriaPassed;
    }
    ;
    evaluateCriterias(ticket, criterias) {
        let isCriteriaPassed = false;
        for (let i = 0; i < criterias.length; i++) {
            let isPassed = this.criteria(ticket, criterias[i]);
            if (criterias.length > 1 && i > 0) {
                if (criterias[i - 1].IsAnd)
                    isCriteriaPassed = isPassed && isCriteriaPassed;
                else
                    isCriteriaPassed = isPassed || isCriteriaPassed;
            }
            else
                isCriteriaPassed = isPassed;
        }
        return isCriteriaPassed;
    }
    ;
    executeActions(ticket, actions, executeAction) {
        for (let action of actions) {
            let field = this.getField(ticket, action.FieldId);
            if (!GlobalFunctions.isEmpty(field)) {
                if (GlobalFunctions.isEmpty(action.SubFieldId)) {
                    switch (action.Type) {
                        case RuleActionType.Hide:
                            field.Visible = !executeAction;
                            break;
                        case RuleActionType.Required:
                            field.Required = executeAction;
                            break;
                        case RuleActionType.Filter:
                            if (executeAction && !GlobalFunctions.isEmpty(field.FieldList) && !GlobalFunctions.isEmpty(field.FieldList.Entries) && !GlobalFunctions.isEmpty(action.Value))
                                for (let entry of field.FieldList.Entries)
                                    entry.Visible = GlobalFunctions.isStringInList(action.Value.split(';'), entry.Key, true);
                            break;
                        case RuleActionType.Employee:
                            if (executeAction && !GlobalFunctions.isEmpty(this.setHandlerCallback) && !GlobalFunctions.isEmpty(action.Value))
                                this.setHandlerCallback(action.Value, 'Employee');
                            break;
                        case RuleActionType.Department:
                            if (executeAction && !GlobalFunctions.isEmpty(this.setHandlerCallback) && !GlobalFunctions.isEmpty(action.Value))
                                this.setHandlerCallback(action.Value, 'Department');
                            break;
                        case RuleActionType.Mailbox:
                            if (executeAction && !GlobalFunctions.isEmpty(this.setHandlerCallback) && !GlobalFunctions.isEmpty(action.Value))
                                this.setHandlerCallback(action.Value, 'Mailbox');
                            break;
                        default:
                            break;
                    }
                }
                else
                    this.executeSubFieldAction(field, action);
            }
        }
    }
    executeSubFieldAction(field, action) {
        if (field != null && action != null && !GlobalFunctions.isEmpty(action.SubFieldId)) {
            switch (action.SubFieldId) {
                case 'emailaddress':
                    if (action.Type == RuleActionType.Required)
                        field.EmailAddressRequired = true;
                    break;
                case 'phonenumber':
                    if (action.Type == RuleActionType.Required)
                        field.PhoneNumberRequired = true;
                    break;
                case 'mobilenumber':
                    if (action.Type == RuleActionType.Required)
                        field.MobileNumberRequired = true;
                    break;
            }
        }
    }
    evaluateRules(ticket, rules) {
        if (!GlobalFunctions.isEmpty(rules)) {
            const executeRules = [];
            for (let rule of rules) {
                if (rule.Enabled) {
                    if (this.evaluateCriterias(ticket, rule.Criteria))
                        executeRules.push(rule);
                    else
                        this.executeActions(ticket, rule.Actions, false);
                }
            }
            for (let rule of executeRules)
                this.executeActions(ticket, rule.Actions, true);
        }
    }
    ;
    getField(ticket, fieldId) {
        let field = null;
        if (!GlobalFunctions.isEmpty(ticket) && !GlobalFunctions.isEmpty(ticket.TicketType) && !GlobalFunctions.isEmpty(ticket.TicketType.FieldGroups)) {
            for (let fieldGroup of ticket.TicketType.FieldGroups) {
                if (!GlobalFunctions.isEmpty(fieldGroup.Fields)) {
                    field = jlinq.from(fieldGroup.Fields).equals("Id", fieldId).first();
                    if (!GlobalFunctions.isEmpty(field))
                        break;
                }
            }
        }
        return field;
    }
};
RuleService = __decorate([
    Injectable({ providedIn: 'root' })
], RuleService);
export { RuleService };
//# sourceMappingURL=rule-service.js.map