var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { map } from 'rxjs/operators';
import { environment } from '../../../environments/environment';
import { GlobalFunctions } from '../../shared/global-functions';
import { LicenseSpecificFeature, OperationType } from '../enums/common-enums';
import { EntityFqdn } from '../enums/core-enums';
import { SearchOption } from '../models/common/serach-option';
import { PopularItem } from '../models/popular/popular-itemDto';
import { PopularObject } from '../models/popular/popular-objectDto';
import { BaseService } from './base-service';
let PopularService = class PopularService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, searchService, translateService, applicationSettingManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.searchService = searchService;
        this.translateService = translateService;
        this.applicationSettingManager = applicationSettingManager;
        this.searchEntities = [['products', GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Products_Entities_Product])], ['questionanswers', GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Faqs_Entities_QuestionAnswer])], ['persons', GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Persons_Entities_Person])], ['organizations', GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Organizations_Entities_Organization])], ['caseentity', GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Cases_Entities_CaseEntity])], ['documents', GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Documents_Entities_Document])], ['locations', GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Locations_Entities_AddressableObjectMark])]];
        this.getPopularItems = function (completedPopularList) {
            let url = environment.oData_config + "/PopularItems?$expand=EntityDetailLog";
            let sessiontoken = GlobalFunctions.getSessionTokenAsString();
            if (sessiontoken != null)
                return this.http.get(url, { headers: this.getHeader() }).pipe(map((data) => {
                    let popularList = [];
                    let uniqueSet = [];
                    if (data != null && data.length > 0) {
                        for (let index = 0; index < data.length; index++) {
                            if (data[index].OBJECTTYPE != undefined && data[index].EntityDetailLog != undefined && data[index].EntityDetailLog.OBJECTDATA != undefined) {
                                let completeObject = jQuery.parseJSON(data[index].EntityDetailLog.OBJECTDATA);
                                let objectItem;
                                let completeObjectCount = 0;
                                for (let x in completeObject) {
                                    if (completeObjectCount == 1) {
                                        objectItem = completeObject[x];
                                        break;
                                    }
                                    completeObjectCount++;
                                }
                                if (objectItem != null) {
                                    let uniqueId = objectItem.Id + '|' + objectItem.ObjectSource;
                                    if ($.inArray(uniqueId, uniqueSet) < 0) {
                                        uniqueSet.push(uniqueId);
                                        let contentType = GlobalFunctions.getObjectTypeName(objectItem.RelatedEntityFqdn);
                                        if (GlobalFunctions.checkRights(contentType, OperationType.View)) {
                                            let hits = 0;
                                            if (data[index].Hits != undefined)
                                                hits = data[index].Hits;
                                            popularList.push(new PopularItem(objectItem, hits, "related" + contentType + "Icon"));
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (completedPopularList != null)
                        completedPopularList(popularList);
                }));
        };
    }
    fillEmptySearchOption() {
        this.searchService.searchOptions = [];
        this.searchEntities.forEach(searchEntity => {
            if (GlobalFunctions.hasRight(searchEntity[1], OperationType.View)) {
                if (searchEntity[0] == "locations") {
                    if (GlobalFunctions.isLicenseSpecificFeatureEnabled(LicenseSpecificFeature.AddressesAndBuildings)) {
                        let locationTemplate = "";
                        if (!GlobalFunctions.isEmpty(this.applicationSettingManager.getApplicationSettingValueByKey("CurrentLocation")))
                            locationTemplate = '<div id="currentLocationBtn" style="cursor:pointer; float:right;" class="jkcLocation jkcSizeMedium popularHeader" title="' + this.translateService.instant('LBL_CURRENT_LOCATION') + '"></div>';
                        this.searchService.searchOptions.push(new SearchOption("", 'locations', true, null, this.translateService, '', false, 20, locationTemplate));
                    }
                }
                else {
                    let formatedText = this.translateService.instant("LBL_SEARCHING") + " " + " in " + this.translateService.instant("LBL_" + searchEntity[0].toUpperCase());
                    let searchOption = new SearchOption("", searchEntity[0], true, null, this.translateService, this.searchService.searchOptions.length == 0 ? 'blueTopBorder' : '');
                    this.searchService.searchOptions.push(searchOption);
                }
            }
        });
    }
    ;
    fetchPopularList(completedPopularList) {
        if (GlobalFunctions.getSessionTokenAsString())
            return this.httpClient.get(environment.oData_config + '/PopularItems?$expand=EntityDetailLog', { headers: this.getHeader() }).pipe(map((data) => {
                let contentTypes = [];
                let popularList = [];
                let uniqueSet = [];
                if (data?.length > 0) {
                    for (let index = 0; index < data.length; index++) {
                        if (data[index].OBJECTTYPE != undefined && data[index].EntityDetailLog != undefined && data[index].EntityDetailLog.OBJECTDATA != undefined) {
                            let completeObject = jQuery.parseJSON(data[index].EntityDetailLog.OBJECTDATA);
                            let objectItem;
                            let completeObjectCount = 0;
                            for (let x in completeObject) {
                                if (completeObjectCount == 1) {
                                    objectItem = completeObject[x];
                                    break;
                                }
                                completeObjectCount++;
                            }
                            if (objectItem != null) {
                                let uniqueId = objectItem.Id + '|' + objectItem.ObjectSource;
                                if (!uniqueSet.includes(uniqueId)) {
                                    uniqueSet.push(uniqueId);
                                    if (GlobalFunctions.hasRight(data[index].OBJECTTYPE, OperationType.View)) {
                                        if (contentTypes.indexOf(data[index].OBJECTTYPE) == -1) {
                                            contentTypes.push(data[index].OBJECTTYPE);
                                            let contentTypeCaption = this.translateService.instant("LBL_" + GlobalFunctions.getObjectTypeName(data[index].OBJECTTYPE.toUpperCase()));
                                            popularList.push(new PopularObject(data[index].OBJECTTYPE, contentTypeCaption, []));
                                        }
                                        popularList[contentTypes.indexOf(data[index].OBJECTTYPE)].popularItems.push(objectItem);
                                    }
                                }
                            }
                        }
                    }
                }
                const fixedList = [];
                if (popularList?.length > 0) {
                    for (let i = 0; i < popularList.length; i++) {
                        fixedList.push(new SearchOption("<div style='padding:0px;width:100%' > <div class='tableCell popularListHeader' style='font-weight: bold;width:100%;'>" + popularList[i].contentTypeCaption + "</div> </div>", popularList[i].contentType, false, null, this.translateService));
                        if (popularList[i].popularItems?.length > 0) {
                            for (let j = 0; j < popularList[i].popularItems.length; j++) {
                                if (popularList[i].contentType.includes("Product") && popularList[i].popularItems[j].Links && !GlobalFunctions.isEmpty(popularList[i].popularItems[j].Links.LinkDto.UriText))
                                    fixedList.push(new SearchOption("<div style=\"width:80%\" class=\"fieldValueWithEllipsis\" title='" + popularList[i].popularItems[j].StringRepresentation + "'>" + popularList[i].popularItems[j].StringRepresentation + "</div>" + '<span id="eformBtn" style="margin-left:50px;margin-right:0px;margin-top:-6%;float:right" title="' + this.translateService.instant('LBL_OPEN_E_FORM_LINK') + popularList[i].popularItems[j].StringRepresentation + '"></span>', popularList[i].contentType, true, popularList[i].popularItems[j], this.translateService));
                                else
                                    fixedList.push(new SearchOption(popularList[i].popularItems[j].StringRepresentation, popularList[i].contentType, true, popularList[i].popularItems[j], this.translateService));
                            }
                        }
                    }
                }
                this.fillEmptySearchOption();
                if (completedPopularList)
                    completedPopularList(fixedList);
            }));
    }
    fetchKeywordPopularList(keyword, $scope, completedPopularList) {
        if (keyword.includes('\''))
            keyword = keyword.replace(/'/g, "''");
        let url = environment.oData_config + '/CacheKeywordPopularItem?$filter=KEYWORD%20eq%20%27' + encodeURIComponent(keyword) + '%27';
        return this.httpClient.get(url, { headers: this.getHeader() }).pipe(map((data) => {
            let contentTypes = [];
            let popularList = [];
            let uniqueSet = [];
            if (data != null && data.length > 0) {
                data = data.sort((a, b) => String(a.Count).localeCompare(String(b.Count)));
                for (let index = 0; index < data.length; index++) {
                    if (data[index].ContentType != undefined && data[index].EntityId != undefined && data[index].EntitySource != undefined) {
                        let contentType = GlobalFunctions.getObjectTypeName(data[index].ContentType);
                        if (GlobalFunctions.checkRights(contentType, OperationType.View)) {
                            let objectItem = data[index];
                            if (objectItem != null) {
                                let uniqueId = objectItem.Id + '|' + objectItem.ObjectSource;
                                if (!uniqueSet.includes(uniqueId)) {
                                    if (contentTypes.indexOf(data[index].ContentType) == -1) {
                                        contentTypes.push(data[index].ContentType);
                                        let contentTypeCaption = this.translateService.instant("LBL_" + contentType.toUpperCase());
                                        popularList.push(new PopularObject(objectItem.ContentType, contentTypeCaption, new Array()));
                                    }
                                    popularList[contentTypes.indexOf(data[index].ContentType)].popularItems.push(objectItem);
                                }
                            }
                        }
                    }
                }
            }
            let fixedList = [];
            if (popularList != null && popularList.length > 0) {
                for (let i = 0; i < popularList.length; i++) {
                    if (popularList[i].popularItems != null && popularList[i].popularItems.length > 0) {
                        for (let j = 0; j < popularList[i].popularItems.length; j++) {
                            let entityName = GlobalFunctions.getObjectTypeName(popularList[i].popularItems[j].ContentType).toLowerCase();
                            fixedList.push(new SearchOption("<div id=\"popularList\" style=\"width: 283px; float: right;margin-top: 3px;\" class=\"fieldValueWithEllipsis\" title='" + popularList[i].popularItems[j].DisplayName + "'>" + popularList[i].popularItems[j].DisplayName + "</div>" + '<span class="GreensourceData ' + entityName + '" style=\"float: left\">' + '</span>', popularList[i].ContentType + '_', true, popularList[i].popularItems[j], this.translateService));
                        }
                    }
                }
                if (fixedList != null && fixedList.length > 0)
                    fixedList[fixedList.length - 1].style = "blueBottomBorder";
                if (completedPopularList != null)
                    completedPopularList(fixedList);
            }
        }));
    }
};
PopularService = __decorate([
    Injectable({ providedIn: 'root' })
], PopularService);
export { PopularService };
//# sourceMappingURL=popular-service.js.map