var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { AlternateSearchType, OperationType } from '../enums/common-enums';
import { SearchObject } from '../models/common/search-objectDto';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let PersonService = class PersonService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, dialog, translateService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.dialog = dialog;
        this.translateService = translateService;
        this.setMultipleFetchDetailResponse = [];
        this.messageId = "";
        this.representativeMessageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setRelatedPersonResultFound = null;
            this.setDeleteResponse = null;
            this.setFetchDetailResponse = null;
            this.setMultipleFetchDetailResponse = [];
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setAlternateSearchResponseFound = null;
            this.setRelatedRepresentativeResultFound = null;
            this.setSearchPrivateFieldValidationResponseFound = null;
            this.setViewerRelatedPersonResultFound = null;
        };
        this.setRelatedResultCallback = (setRelatedPersonResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedPersonResultFound = setRelatedPersonResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedPersonResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedPersonResultFound = setViewerRelatedPersonResultFoundCallback;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.fetchDetail = (partialDto, fetchDetailCallback) => {
            this.setFetchDetailResponse = fetchDetailCallback;
            console.log('personService->fetchPersonDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', partialDto);
            });
        };
        this.prefetchDetail = (searchField, searchValue, prefetchDetailCallback) => {
            this.setPrefetchDetailResponse = prefetchDetailCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('prefetchDetail', searchField, searchValue);
            });
        };
        this.setMaritalStatusText = (selectedEntity) => {
            if (!GlobalFunctions.isEmpty(selectedEntity) && !GlobalFunctions.isEmpty(selectedEntity.AdministeredPersonDto) && !GlobalFunctions.isEmpty(selectedEntity.AdministeredPersonDto.CivilStatus)) {
                switch (selectedEntity.AdministeredPersonDto.CivilStatus) {
                    case 1:
                        selectedEntity.AdministeredPersonDto.MaritalStatusText = this.translateService.instant("LBL_ALWAYS_BEEN_SINGLE");
                        break;
                    case 2:
                        selectedEntity.AdministeredPersonDto.MaritalStatusText = this.translateService.instant("LBL_MARRIED");
                        break;
                    case 3:
                        selectedEntity.AdministeredPersonDto.MaritalStatusText = this.translateService.instant("LBL_DIVORCED");
                        break;
                    case 4:
                        selectedEntity.AdministeredPersonDto.MaritalStatusText = this.translateService.instant("LBL_WIDOW");
                        break;
                    case 5:
                        selectedEntity.AdministeredPersonDto.MaritalStatusText = this.translateService.instant("LBL_PARTNERSHIP");
                        break;
                    case 6:
                        selectedEntity.AdministeredPersonDto.MaritalStatusText = this.translateService.instant("LBL_ENDED_PARTNERSHIP");
                        break;
                    case 7:
                        selectedEntity.AdministeredPersonDto.MaritalStatusText = this.translateService.instant("LBL_ABANDONED");
                        break;
                    default:
                        selectedEntity.AdministeredPersonDto.MaritalStatusText = selectedEntity.AdministeredPersonDto.MaritalStatusText = " ";
                        break;
                }
            }
        };
        this.searchRelatedRepresentativeRequest = (setRelatedRepresentativeResultFoundCallBack, selectedEntity) => {
            this.setRelatedRepresentativeResultFound = setRelatedRepresentativeResultFoundCallBack;
            let mainObject = null;
            let contentType = GlobalFunctions.toString(selectedEntity.RelatedEntityFqdn);
            mainObject = new SearchObject(selectedEntity.Id, contentType, selectedEntity.ObjectSource, "");
            this.representativeMessageId = GlobalFunctions.createGuid();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRepresentativeRequest', JSON.stringify(mainObject), this.representativeMessageId);
            });
        };
        this.createPersonEntity = (createOrUpdatePersonRequest, addPersonCallback, errorCallback) => {
            this.setAddPersonCompleted = addPersonCallback;
            console.log('personService -> creating Person:', Date.now());
            let cookie = this.isValidToken();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    let url = environment.person_config.replace("/signalr", "/post/PostPersonXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
                    this.httpClient.post(url, createOrUpdatePersonRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (errorCallback)
                            errorCallback();
                    });
                }
            });
        };
        this.saveExternalData = (personDto, phoneNumber, emailAddress) => {
            if (personDto.ObjectSource.toLowerCase().indexOf("key2gbav") > -1 || personDto.ObjectSource.toLowerCase().indexOf("stuf0204") > -1) {
                if (!GlobalFunctions.isEmpty(phoneNumber) && GlobalFunctions.isEmpty(personDto.PhoneNumber))
                    personDto.PhoneNumber = phoneNumber;
                if (!GlobalFunctions.isEmpty(emailAddress) && GlobalFunctions.isEmpty(personDto.EmailAddress))
                    personDto.EmailAddress = emailAddress;
                let saveExternalDataRequest = new Object();
                saveExternalDataRequest.BaseList = new Array();
                saveExternalDataRequest.BaseList.push(personDto);
                console.log('personService -> save external data:', Date.now());
                let cookie = this.isValidToken();
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid) {
                        let url = environment.person_config.replace("/signalr", "/post/PostExternalDataXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
                        this.httpClient.post(url, saveExternalDataRequest).subscribe(result => {
                            console.log(result);
                        }, () => {
                            console.error("personService: error while sending external data request");
                        });
                    }
                });
            }
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.person_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_PERSON'), this.translateService, this.dialog);
                        return reject('Failed to connect to person service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Person service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Person service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for person service');
        });
    }
    registerServerEvents() {
        this.proxy.on('searchResultFound', (result, messageId) => {
            console.log("personService->searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null) {
                    this.parseResult(result);
                    this.setSearchResultFound(result, "Person");
                }
            }
        });
        this.proxy.on('updateSearchStatus', result => {
            console.log("personService->updateSearchStatus:", result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result, "Person");
        });
        this.proxy.on('createPersonResponseReceived', response => {
            console.log('add person response --> ' + response);
            if (this.setAddPersonCompleted != null)
                this.setAddPersonCompleted(response);
        });
        this.proxy.on('relatedPersonResultFound', (result, messageId) => {
            console.log("personService->relatedPersonResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedPersonResultFound != null) {
                    this.parseResult(result);
                    this.setRelatedPersonResultFound(result, "Person", this.translateService.instant("LBL_PERSON"));
                }
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedPersonResultFound != null) {
                    this.parseResult(result);
                    this.setViewerRelatedPersonResultFound(result, "Person", this.translateService.instant("LBL_PERSON"));
                }
            }
        });
        this.proxy.on('relatedRepresentativeResultFound', (result, messageId) => {
            console.log("personService->relatedRepresentativeResultFound:", result);
            if (this.representativeMessageId == "" || this.representativeMessageId == messageId) {
                if (this.setRelatedRepresentativeResultFound != null)
                    this.setRelatedRepresentativeResultFound(result, "Person", this.translateService.instant("LBL_PERSON"));
            }
        });
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('personBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_PERSON'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("personService->searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("personService->searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('alternateSearchResponseReceived', (message, messageId) => {
            console.log("personService->alternateSearchResponseReceived:", message);
            if (this.setAlternateSearchResponseFound != null) {
                this.setAlternateSearchResponseFound(message);
            }
        });
        this.proxy.on('searchPrivateFieldValidationResponse', (message) => {
            console.log("personService->searchPrivateFieldValidationResponse:", message);
            if (this.setSearchPrivateFieldValidationResponseFound != null) {
                this.setSearchPrivateFieldValidationResponseFound(message);
            }
        });
        this.proxy.on('personDetailResponse', (result) => {
            console.log("personService->personDetailResponse:", result);
            if (this.setFetchDetailResponse != null) {
                this.assignAge(result);
                this.setFetchDetailResponse(result);
            }
            if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0 && result != null)
                this.setMultipleFetchDetailResponse.forEach((element, index) => this.setMultipleFetchDetailResponse[index](result));
        });
        this.proxy.on('prefetchPersonResponse', (result) => {
            console.log("personService->prefetchPersonResponse:", result);
            if (this.setPrefetchDetailResponse != null)
                this.setPrefetchDetailResponse(result);
        });
        this.proxy.on('deletePersonResponse', response => {
            console.log("personService->deletePersonResponse:", response);
            if (this.setDeleteResponse != null)
                this.setDeleteResponse(response, this.translateService.instant("LBL_PERSON"));
        });
        this.proxy.on('mergePersonResponse', response => {
            console.log("personService->mergePersonResponse:", response);
            if (this.setMergeResponse != null)
                this.setMergeResponse(response);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_PERSON'), this.translateService, this.dialog));
    }
    parseResult(result) {
        if (result != null && result.length > 0) {
            for (let index = 0; index < result.length; index++) {
                if (!GlobalFunctions.isEmpty(result[index].Identification))
                    result[index].Identification = parseInt(result[index].Identification);
            }
        }
    }
    ;
    assignAge(result) {
        try {
            if (result && result.Details && result.Details.DateOfBirth && result.Details.DateOfBirth.indexOf('0001-01-01') == -1) {
                let dateOfBirth = new Date(result.Details.DateOfBirth);
                let ageDifMs;
                if (result.Details.DateOfExpiration && result.Details.DateOfExpiration.indexOf('0001-01-01') == -1 && GlobalFunctions.isValidDate(result.Details.DateOfExpiration)) {
                    let dateOfExpiration = new Date(result.Details.DateOfExpiration);
                    ageDifMs = dateOfExpiration.getTime() - dateOfBirth.getTime();
                }
                else
                    ageDifMs = Date.now() - dateOfBirth.getTime();
                let ageDate = new Date(ageDifMs);
                result.Details.Age = Math.abs(ageDate.getUTCFullYear() - 1970);
            }
        }
        catch (e) {
            console.error("personService->assignAge:", e);
        }
    }
    search(query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback, alternateSearchSuggestionsResponseReceived, searchPrivateFieldValidationResponseFoundCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
        this.setSearchPrivateFieldValidationResponseFound = searchPrivateFieldValidationResponseFoundCallback;
        this.searchQuery = query;
        alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
        handler = handler != undefined ? handler : "";
        sourceLocation = sourceLocation != undefined ? sourceLocation : "";
        this.messageId = GlobalFunctions.getGuid();
        console.log('personService->search:', this.searchQuery);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('search', this.searchQuery, isAllSourceRequest, alternateSearchType, sourceLocation, handler, this.messageId);
        });
    }
    ;
    delete(partialDto, deleteCallback) {
        this.setDeleteResponse = deleteCallback;
        console.log('personService->delete:', partialDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('Delete', partialDto);
        });
    }
    ;
    merge(targetId, sourceIds, mergeCallback) {
        this.setMergeResponse = mergeCallback;
        console.log('personService->mergeData:', targetId);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('Merge', targetId, sourceIds);
        });
    }
    ;
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Person, OperationType.View)) {
            this.viewerRelatedMessageId = GlobalFunctions.getGuid();
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Person, OperationType.View)) {
            this.relatedMessageId = GlobalFunctions.getGuid();
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    advancedSearch(searchDto, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback, alternateSearchSuggestionsResponseReceived, searchPrivateFieldValidationResponseFoundCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
        this.setSearchPrivateFieldValidationResponseFound = searchPrivateFieldValidationResponseFoundCallback;
        alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
        handler = handler != undefined ? handler : "";
        this.advancedSearchDto = searchDto;
        sourceLocation = sourceLocation != undefined ? sourceLocation : "";
        this.messageId = GlobalFunctions.createGuid();
        console.log('personService->advancedSearch:', searchDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('advancedSearch', searchDto, alternateSearchType, sourceLocation, handler, this.messageId);
        });
    }
    ;
};
PersonService = __decorate([
    Injectable({ providedIn: 'root' })
], PersonService);
export { PersonService };
//# sourceMappingURL=person-service.js.map