var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { AlternateSearchType, OperationType, RecordOperationMode } from '../enums/common-enums';
import { CreateRepresentativeRequest } from '../models/common/create-representive-request';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let OrganizationService = class OrganizationService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.dialog = dialog;
        this.setMultipleFetchDetailResponse = [];
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setFetchDetailResponse = null;
            this.setMultipleFetchDetailResponse = [];
            this.setRelatedOrganizationResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setAlternateSearchResponseFound = null;
            this.setSearchPrivateFieldValidationResponseFound = null;
            this.setDeleteResponse = null;
            this.setViewerRelatedOrganisationResultFound = null;
        };
        this.setRelatedResultCallback = (setRelatedOrganizationResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedOrganizationResultFound = setRelatedOrganizationResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedOrganizationResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedOrganisationResultFound = setViewerRelatedOrganizationResultFoundCallback;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.fetchDetail = (partialDto, fetchDetailCallback) => {
            this.setFetchDetailResponse = fetchDetailCallback;
            console.log('organizationService->fetchOrganizationDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', partialDto);
            });
        };
        this.search = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback, alternateSearchSuggestionsResponseReceived, searchPrivateFieldValidationResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
            this.setSearchPrivateFieldValidationResponseFound = searchPrivateFieldValidationResponseFoundCallback;
            isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
            alternateSearchType = alternateSearchType ? alternateSearchType : AlternateSearchType.None;
            handler = handler ? handler : "";
            this.searchQuery = query;
            sourceLocation = sourceLocation != undefined ? sourceLocation : "";
            this.messageId = GlobalFunctions.createGuid();
            console.log('organizationService->search:', this.searchQuery);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('search', this.searchQuery, isAllSourceRequest, alternateSearchType, sourceLocation, handler, this.messageId);
            });
        };
        this.searchRelatedToOrganization = (userId, organizationDto, messageId) => {
            if (!GlobalFunctions.hasRight(GlobalFunctions.toContentType("ORGANIZATION"), OperationType.View))
                return;
            this.messageId = messageId;
            console.log('organizationService->searchRelatedToOrganization');
            let baseEntity = new Object();
            baseEntity.Id = organizationDto.Id;
            baseEntity.ObjectSource = organizationDto.ObjectSource;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('SearchRelatedToOrganization', userId, baseEntity, messageId);
            });
        };
        this.createOrganizationEntity = (createOrUpdateOrganizationRequest, addOrganizationCallback, errorCallback) => {
            this.setAddOrganizationCompleted = addOrganizationCallback;
            console.log('organizationService->creating organization:', Date.now());
            let cookie = this.isValidToken();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    let url = environment.organization_config.replace("/signalr", "/post/PostOrganizationXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
                    this.httpClient.post(url, createOrUpdateOrganizationRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (errorCallback)
                            errorCallback();
                    });
                }
            });
        };
        this.createOrganizationRepresentativeEntity = (personDto, id, addOrganizationRepresentativeCallback, errorCallback, mode = RecordOperationMode.New) => {
            console.log('organizationService->creating representative:', Date.now());
            this.setCreateRepresentativeCompleted = addOrganizationRepresentativeCallback;
            let cookie = this.isValidToken();
            let createRepresentativeRequest = new CreateRepresentativeRequest();
            createRepresentativeRequest.PersonDto = JSON.stringify(personDto);
            createRepresentativeRequest.OrganizationId = id;
            createRepresentativeRequest.Mode = mode;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    let url = environment.organization_config.replace("/signalr", "/post/PostRepresentativeXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
                    this.httpClient.post(url, createRepresentativeRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (errorCallback)
                            errorCallback();
                    });
                }
            });
        };
        this.saveExternalData = (organizationDto, phoneNumber, emailAddress) => {
            if (organizationDto.ObjectSource.toLowerCase().indexOf("key2gbav") > -1 || organizationDto.ObjectSource.toLowerCase().indexOf("stuf0204") > -1) {
                if (!GlobalFunctions.isEmpty(phoneNumber) && GlobalFunctions.isEmpty(organizationDto.PhoneNumber))
                    organizationDto.PhoneNumber = phoneNumber;
                if (!GlobalFunctions.isEmpty(emailAddress) && GlobalFunctions.isEmpty(organizationDto.EmailAddress))
                    organizationDto.EmailAddress = emailAddress;
                let saveExternalDataRequest = new Object();
                saveExternalDataRequest.BaseList = new Array();
                saveExternalDataRequest.BaseList.push(organizationDto);
                console.log('organizationService -> save external data:', Date.now());
                let cookie = this.isValidToken();
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid) {
                        let url = environment.organization_config.replace("/signalr", "/post/PostExternalDataXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
                        this.httpClient.post(url, saveExternalDataRequest).subscribe(result => {
                            console.log(result);
                        }, () => {
                            console.error("OrganizationService: error while sending external data request");
                        });
                    }
                });
            }
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.organization_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_ORGANIZATION'), this.translateService, this.dialog);
                        return reject('Failed to connect to organization service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Organization service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Organization service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for organization service');
        });
    }
    registerServerEvents() {
        this.proxy.on('searchResultFound', (result) => {
            console.log("organizationService->searchResultFound:", result);
            if (this.setSearchResultFound != null)
                this.setSearchResultFound(result, "Organization");
        });
        this.proxy.on('updateSearchStatus', (result) => {
            console.log("organizationService->updateSearchStatus:", result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result, "Organization");
        });
        this.proxy.on('relatedOrganizationResultFound', (result, messageId) => {
            console.log("organizationService->relatedOrganizationResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedOrganizationResultFound != null)
                    this.setRelatedOrganizationResultFound(result, "Organization", this.translateService.instant("LBL_ORGANIZATION"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedOrganisationResultFound != null)
                    this.setViewerRelatedOrganisationResultFound(result, "Organization", this.translateService.instant("LBL_ORGANIZATION"));
            }
        });
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('organizationBusinessExceptionReceived', (result) => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_ORGANIZATION'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('createOrganizationResponseReceived', (response) => {
            console.log('add organization response --> ' + response);
            if (this.setAddOrganizationCompleted != null)
                this.setAddOrganizationCompleted(response);
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("organizationService->searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("organizationService->searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('alternateSearchResponseReceived', (message, messageId) => {
            console.log("organizationService->alternateSearchResponseReceived:", message);
            if (this.setAlternateSearchResponseFound != null)
                this.setAlternateSearchResponseFound(message);
        });
        this.proxy.on('searchPrivateFieldValidationResponse', (message) => {
            console.log("organizationService->searchPrivateFieldValidationResponse:", message);
            if (this.setSearchPrivateFieldValidationResponseFound != null)
                this.setSearchPrivateFieldValidationResponseFound(message);
        });
        this.proxy.on('organizationDetailResponse', (result, messageId) => {
            console.log("organizationService->organizationDetailResponse:", result);
            if (this.setFetchDetailResponse != null)
                this.setFetchDetailResponse(result);
            if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0 && result != null)
                this.setMultipleFetchDetailResponse.forEach((element, index) => this.setMultipleFetchDetailResponse[index](result));
        });
        this.proxy.on('createRepresentativeResponseReceived', response => {
            console.log('create representative response --> ' + response);
            if (this.setCreateRepresentativeCompleted != null)
                this.setCreateRepresentativeCompleted(response);
        });
        this.proxy.on('deleteOrganizationResponse', response => {
            console.log("organizationService->deleteOrganizationResponse:", response);
            if (this.setDeleteResponse != null)
                this.setDeleteResponse(response, this.translateService.instant("LBL_ORGANIZATION"));
        });
        this.proxy.on('mergeOrganizationResponse', response => {
            console.log("organizationService->mergeOrganizationResponse:", response);
            if (this.setMergeResponse != null)
                this.setMergeResponse(response);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_ORGANIZATION'), this.translateService, this.dialog));
    }
    ;
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Organization, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Organization, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
    delete(partialDto, deleteCallback) {
        this.setDeleteResponse = deleteCallback;
        console.log('organizationService->delete:', partialDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('Delete', partialDto);
        });
    }
    ;
    merge(targetId, sourceIds, mergeCallback) {
        this.setMergeResponse = mergeCallback;
        console.log('organizationService->mergeData:', targetId);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('Merge', targetId, sourceIds);
        });
    }
    ;
    advancedSearch(searchDto, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback, alternateSearchSuggestionsResponseReceived, searchPrivateFieldValidationResponseFoundCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
        this.setSearchPrivateFieldValidationResponseFound = searchPrivateFieldValidationResponseFoundCallback;
        this.advanceSearchDto = searchDto;
        alternateSearchType = alternateSearchType ? alternateSearchType : AlternateSearchType.None;
        handler = handler ? handler : "";
        this.messageId = GlobalFunctions.createGuid();
        sourceLocation = sourceLocation != undefined ? sourceLocation : "";
        console.log('organizationService->advancedSearch:', searchDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('advancedSearch', searchDto, alternateSearchType, sourceLocation, handler, this.messageId);
        });
    }
    ;
};
OrganizationService = __decorate([
    Injectable({ providedIn: 'root' })
], OrganizationService);
export { OrganizationService };
//# sourceMappingURL=organization-service.js.map