var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { OperationType } from '../enums/common-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { DeleteNoteRequest } from '../models/note/delete-note-request';
import { BaseService } from './base-service';
let NoteService = class NoteService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.dialog = dialog;
        this.setMultipleFetchDetailResponse = [];
        this.detailNotificationItem = [];
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.notificationMessageId = "";
        this.detailViewNotificationMessageId = "";
        this.notificationList = [];
        this.detailViewNotificationList = [];
        this.search = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
            this.searchQuery = query;
            this.messageId = GlobalFunctions.getGuid();
            console.log('noteService -> search:', this.searchQuery + Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('search', this.searchQuery, isAllSourceRequest, this.messageId);
            });
        };
        this.deleteNote = (noteDto, deleteNoteCallback) => {
            this.setNoteDeleteResponse = deleteNoteCallback;
            if (noteDto) {
                console.log('noteService -> deleting note:', Date.now());
                let deleteNoteRequest = new DeleteNoteRequest();
                deleteNoteRequest.NoteEntityDto = new Object();
                deleteNoteRequest.NoteEntityDto.Id = noteDto.Id;
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('DeleteNote', JSON.stringify(deleteNoteRequest));
                });
            }
        };
        this.advancedSearch = (searchDto, sourceLocation, searchResultFoundCallback, updateSearchStatusCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            this.advancedSearchDto = searchDto;
            this.messageId = GlobalFunctions.getGuid();
            console.log('noteService -> advancedSearch:', searchDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('advancedSearch', searchDto, this.messageId);
            });
        };
        this.fetchNotifications = (employeeId, departmentId, relatedEntityId = null) => {
            let uniqueMessageId = GlobalFunctions.getGuid();
            if (GlobalFunctions.isEmpty(relatedEntityId))
                this.notificationMessageId = uniqueMessageId;
            else
                this.detailViewNotificationMessageId = uniqueMessageId;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('fetchNotifications', employeeId, departmentId, relatedEntityId, uniqueMessageId);
            });
        };
        this.setNotificationMessageViewerStatus = (notificationMessageId, hideForEveryone = false) => {
            console.log('noteService -> setNotificationMessageViewerStatus:');
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('setNotificationMessageViewerStatus', notificationMessageId, hideForEveryone);
            });
        };
        this.addNoteRequest = (addNoteRequest, addNoteCallback, addNoteErrorCallback) => {
            this.setAddNoteCompleted = addNoteCallback;
            console.log('Send add note request');
            let cookie = this.isValidToken();
            let url = environment.note_config.replace("/signalr", "/post/PostNoteXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, addNoteRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (addNoteErrorCallback) {
                            addNoteErrorCallback();
                        }
                    });
                }
            });
        };
        this.fetchDetail = (partialDto, fetchDetailCallback) => {
            this.setSearchResultFound = fetchDetailCallback;
            this.messageId = "";
            console.log('noteService -> fetchNoteDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('fetchDetail', partialDto);
            });
        };
        this.clearCallbacks = () => {
            this.detailNotificationItem = [];
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setRelatedNoteResultFound = null;
            this.setFetchNotificationResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setMultipleFetchDetailResponse = [];
            this.notificationList = [];
            this.setViewerRelatedNoteResultFound = null;
        };
        this.clearDetailViewNotificationCallbacks = () => {
            this.detailViewNotificationMessageId = "";
            this.detailViewNotificationList = [];
            this.setFetchDetailViewNotificationResultFound = null;
        };
        this.setSelectedNotificationItem = (itemList) => {
            itemList.forEach(item => {
                if (item !== null && item !== undefined)
                    this.detailNotificationItem.push(item);
            });
        };
        this.bulkDeleteNote = (bulkDeleteNoteRequest, bulkDeleteNoteResponseCallback, errorCallback) => {
            this.setBulkDeleteNoteResponse = bulkDeleteNoteResponseCallback;
            console.log('note service -> bulk delete note:', Date.now());
            let cookie = this.isValidToken();
            let url = environment.note_config.replace("/signalr", "/post/PostBulkDeleteNoteXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, bulkDeleteNoteRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        if (errorCallback) {
                            errorCallback();
                        }
                    });
                }
            });
        };
        this.getSelectedNotificationItem = (selectedEntity) => {
            let result = null;
            if (this.detailNotificationItem !== undefined && this.detailNotificationItem !== null && selectedEntity !== null && selectedEntity !== undefined) {
                result = jlinq.from(this.detailNotificationItem)
                    .equals("NoteEntity.Id", selectedEntity.Id)
                    .select();
                if (result !== null && result.length > 0)
                    result = result[0];
                else
                    result = null;
            }
            return result;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.setSearchResultCallbacks = (setSearchResultFoundCallback, setUpdateSearchStatusCallback) => {
            this.setSearchResultFound = setSearchResultFoundCallback;
            this.setUpdateSearchStatus = setUpdateSearchStatusCallback;
        };
        this.setFetchNotificationResultCallbacks = setFetchNotificationResultFoundCallback => {
            this.setFetchNotificationResultFound = setFetchNotificationResultFoundCallback;
        };
        this.setFetchDetailViewNotificationResultCallbacks = setFetchDetailViewNotificationResultFoundCallback => {
            this.setFetchDetailViewNotificationResultFound = setFetchDetailViewNotificationResultFoundCallback;
        };
        this.setRelatedResultCallback = (setRelatedNoteResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedNoteResultFound = setRelatedNoteResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedNoteResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedNoteResultFound = setViewerRelatedNoteResultFoundCallback;
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.setCreateByToNoteList = (result, cacheManager) => {
            for (let index = 0; index < result.length; index++) {
                let employeeDto = cacheManager.getEmployeeById(result[index].NoteEntity.CreatedById);
                if (employeeDto != null) {
                    result[index].NoteEntity.CreatedBy = employeeDto;
                    result[index].CreatedEmployee = employeeDto;
                }
            }
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.note_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_NOTE'), this.translateService, this.dialog);
                        return reject('Failed to connect to note service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Note service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Note service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for note service');
        });
    }
    registerServerEvents() {
        this.proxy.on('searchResultFound', (result, messageId) => {
            console.log("noteService -> searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result);
            }
            if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0 && result != null && result.length > 0) {
                this.setMultipleFetchDetailResponse.forEach((element, index) => {
                    this.setMultipleFetchDetailResponse[index](result[0]);
                });
            }
        });
        this.proxy.on('deleteNoteEntityResponse', response => {
            console.log('noteService -> deleteNoteResponse');
            if (this.setNoteDeleteResponse != null)
                this.setNoteDeleteResponse(response);
        });
        this.proxy.on('updateSearchStatus', result => {
            console.log("noteService -> updateSearchStatus:", result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result);
        });
        this.proxy.on('fetchNotificationResultFound', (result, messageId) => {
            console.log("noteService -> fetchNotificationResultFound:", result);
            if (this.notificationMessageId == messageId) {
                if (!GlobalFunctions.isEmpty(result.NotificationMessageDtoList))
                    this.notificationList = this.notificationList.concat(result.NotificationMessageDtoList);
                if (result.IsLastResponse) {
                    if (this.setFetchNotificationResultFound != null)
                        this.setFetchNotificationResultFound(this.notificationList);
                    this.notificationList = [];
                }
            }
            else if (this.detailViewNotificationMessageId == messageId) {
                if (!GlobalFunctions.isEmpty(result.NotificationMessageDtoList))
                    this.detailViewNotificationList = this.detailViewNotificationList.concat(result.NotificationMessageDtoList);
                if (result.IsLastResponse) {
                    if (this.setFetchDetailViewNotificationResultFound != null)
                        this.setFetchDetailViewNotificationResultFound(this.detailViewNotificationList);
                    this.detailViewNotificationList = [];
                }
            }
        });
        this.proxy.on('tokenFailedResponse', () => {
            this.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('noteBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_NOTE'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('relatedNoteResultFound', (result, messageId) => {
            console.log("noteService -> relatedNoteResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedNoteResultFound != null)
                    this.setRelatedNoteResultFound(result, "NoteEntity", this.translateService.instant("LBL_NOTE"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedNoteResultFound != null)
                    this.setViewerRelatedNoteResultFound(result, "NoteEntity", this.translateService.instant("LBL_NOTE"));
            }
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("noteService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('addNoteCompleted', response => {
            console.log('add note response --> ' + response);
            if (this.setAddNoteCompleted != null)
                this.setAddNoteCompleted(response);
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("noteService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('bulkDeleteNoteResponse', result => {
            console.log("noteService -> bulkDeleteNoteResponse", result);
            if (this.setBulkDeleteNoteResponse != null)
                this.setBulkDeleteNoteResponse(result);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_NOTE'), this.translateService, this.dialog));
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Note, OperationType.View)) {
            this.relatedMessageId = GlobalFunctions.getGuid();
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Note, OperationType.View)) {
            this.relatedMessageId = GlobalFunctions.getGuid();
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
};
NoteService = __decorate([
    Injectable({ providedIn: 'root' })
], NoteService);
export { NoteService };
//# sourceMappingURL=note-service.js.map