var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { AlternateSearchType, OperationType } from '../enums/common-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { DeleteLinkRequest } from '../models/link/delete-link-request';
import { BaseService } from './base-service';
let LinkService = class LinkService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, cacheManager, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.cacheManager = cacheManager;
        this.translateService = translateService;
        this.dialog = dialog;
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.setRelatedResultCallback = (setRelatedLinkResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedLinkResultFound = setRelatedLinkResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedLinkResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedLinkResultFound = setViewerRelatedLinkResultFoundCallback;
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                resolve(true);
            if (!this.isLicensed)
                resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.link_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_QUICK_LINK'), this.translateService, this.dialog);
                        reject('Failed to connect to link service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Link service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Link service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                reject('Authentication failed for link service');
        });
    }
    registerServerEvents() {
        this.proxy.on('createLinkResponse', (result, response) => {
            console.log("linkService -> createLinkComplete", result);
            if (this.setCreateLinkComplete != null)
                this.setCreateLinkComplete(response);
        });
        this.proxy.on('deleteLinkResponse', (response) => {
            console.log('linkService -> deleteLinkResponse');
            if (this.setLinkDeleteResponse != null)
                this.setLinkDeleteResponse(response);
        });
        this.proxy.on('detailResponse', (result) => {
            console.log("linkService -> detailResponse:", result);
            if (this.setFetchDetailResponse != null)
                this.setFetchDetailResponse(result);
        });
        this.proxy.on('searchResultFound', (result, messageId) => {
            console.log("linkService -> searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null) {
                    for (let index = 0; index < result.length; index++) {
                        let employeeDto = this.cacheManager.getEmployeeById(result[index].CreatedById);
                        if (employeeDto != null) {
                            result[index].CreatedBy = employeeDto.StringRepresentation;
                        }
                    }
                    this.setSearchResultFound(result);
                }
            }
        });
        this.proxy.on("searchStartedNotification", message => {
            console.log("linkService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on("searchCompletedNotification", message => {
            console.log("linkService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('updateSearchStatus', (result, messageId) => {
            console.log("linkService -> updateSearchStatus:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setUpdateSearchStatus != null)
                    this.setUpdateSearchStatus(result);
            }
        });
        this.proxy.on('relatedLinkResultFound', (result, messageId) => {
            console.log("linkService->relatedLinkResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedLinkResultFound != null)
                    this.setRelatedLinkResultFound(result, "Link", this.translateService.instant("LBL_LINKS"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedLinkResultFound != null)
                    this.setViewerRelatedLinkResultFound(result, "Link", this.translateService.instant("LBL_LINKS"));
            }
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_QUICK_LINK'), this.translateService, this.dialog));
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
    }
    ;
    clearCallbacks() {
        this.setSearchResultFound = null;
        this.setUpdateSearchStatus = null;
        this.setSearchStartedNotification = null;
        this.setSearchCompletedNotification = null;
        this.setRelatedLinkResultFound = null;
        this.setViewerRelatedLinkResultFound = null;
    }
    ;
    createLink(link, createLinkCompleteCallback, errorCallbackFunction) {
        this.setCreateLinkComplete = createLinkCompleteCallback;
        let cookie = this.isValidToken();
        let url = environment.link_config.replace("/signalr", "/post/PostLinkXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.httpClient.post(url, link).subscribe(result => {
            console.log(result);
        }, err => {
            if (errorCallbackFunction != null)
                errorCallbackFunction();
        });
    }
    ;
    search(query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.searchQuery = query;
        alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
        isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
        handler = handler != undefined ? handler : "";
        this.messageId = GlobalFunctions.createGuid();
        console.log('linkService->search:', this.searchQuery);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('search', this.searchQuery, this.messageId, isAllSourceRequest);
        });
    }
    ;
    advancedSearch(searchDto, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
        handler = handler != undefined ? handler : "";
        sourceLocation = sourceLocation != undefined ? sourceLocation : "";
        this.messageId = GlobalFunctions.createGuid();
        console.log('linkService->advancedSearch:', searchDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('advancedSearch', searchDto, this.messageId);
        });
    }
    ;
    fetchDetail(partialDto, fetchDetailCallback, partialDtoList) {
        this.setFetchDetailResponse = fetchDetailCallback;
        console.log('linkService -> fetchDetail:', partialDto);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('FetchDetail', partialDto, partialDtoList);
        });
    }
    ;
    deleteLink(linkDto, entityDeleteResponseCallback) {
        this.setLinkDeleteResponse = entityDeleteResponseCallback;
        if (linkDto) {
            console.log('linkService -> deleting link:', Date.now());
            let deleteLinkRequest = new DeleteLinkRequest();
            deleteLinkRequest.LinkDto = new Object();
            deleteLinkRequest.LinkDto.Id = linkDto.Id;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('DeleteLink', JSON.stringify(deleteLinkRequest));
            });
        }
    }
    ;
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Link, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Link, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
};
LinkService = __decorate([
    Injectable({ providedIn: 'root' })
], LinkService);
export { LinkService };
//# sourceMappingURL=link-service.js.map