var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { AlternateSearchType, OperationType } from '../enums/common-enums';
import { EntityFqdn } from '../enums/core-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let IssueService = class IssueService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, dialog, translateService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.dialog = dialog;
        this.translateService = translateService;
        this.initializing = false;
        this.lastAppliedFilters = [];
        this.filterOptions = [];
        this.resultCompleteList = [];
        this.isConnected = false;
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.isLicensed = false;
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.setRelatedResultCallback = (setRelatedIssueResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedIssueResultFound = setRelatedIssueResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedIssueResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedIssueResultFound = setViewerRelatedIssueResultFoundCallback;
        };
        this.advancedSearch = (searchDto, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
            handler = handler != undefined ? handler : "";
            sourceLocation = sourceLocation != undefined ? sourceLocation : "";
            this.messageId = GlobalFunctions.createGuid();
            console.log('issueService->advancedSearch:', searchDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('advancedSearch', searchDto, this.messageId, sourceLocation);
            });
        };
    }
    clearCallbacks() {
        this.setSearchResultFound = null;
        this.setSearchStartedNotification = null;
        this.setSearchCompletedNotification = null;
        this.setRelatedIssueResultFound = null;
        this.setFetchDetailResponse = null;
        this.setAlternateSearchResponseFound = null;
        this.setViewerRelatedIssueResultFound = null;
    }
    ;
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.issue_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB_ISSUE);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_ISSUE'), this.translateService, this.dialog);
                        return reject('Failed to connect to issue service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Issue service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Issue service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for issue service');
        });
    }
    registerServerEvents() {
        this.proxy.on("searchStartedNotification", message => {
            console.log("issueService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on("searchCompletedNotification", message => {
            console.log("issueService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('relatedIssueResultFound', (result, messageId) => {
            console.log("issueService -> relatedIssueResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedIssueResultFound != null) {
                    this.setRelatedIssueResultFound(result, "Issue", this.translateService.instant("LBL_ISSUES"));
                }
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedIssueResultFound != null) {
                    this.setViewerRelatedIssueResultFound(result, "Issue", this.translateService.instant("LBL_ISSUES"));
                }
            }
        });
        this.proxy.on("updateSearchStatus", (result, messageId) => {
            console.log("issueService -> updateSearchStatus:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setUpdateSearchStatus != null)
                    this.setUpdateSearchStatus(result, "Issue");
            }
        });
        this.proxy.on("searchResultFound", (result, messageId) => {
            console.log("issueService -> searchResultFound:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result, "Issue");
            }
        });
        this.proxy.on("fetchIssueDetailResponse", (result) => {
            console.log("issueService -> fetchIssueDetailResponse:", result);
            if (this.setFetchDetailResponse != null)
                this.setFetchDetailResponse(result);
        });
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Issue, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity, EntityFqdn.Decos_Kcs_Issues_Entities_Issue);
            let userId = GlobalFunctions.getLoggedInUserId();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', userId, JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Issue, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity, EntityFqdn.Decos_Kcs_Issues_Entities_Issue);
            let userId = GlobalFunctions.getLoggedInUserId();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', userId, JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
    fetchDetailRequest(emailAddress, fetchResultFoundCallback) {
        this.setFetchDetailResponse = fetchResultFoundCallback;
        console.log('issueService -> fetchDetail:', emailAddress);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('fetchDetail', emailAddress);
        });
    }
    search(query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) {
        this.setSearchResultFound = searchResultFoundCallback;
        this.setUpdateSearchStatus = updateSearchStatusCallback;
        this.setAlternateSearchResponseFound = alternateSearchResponseFoundCallback;
        this.searchQuery = query;
        alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
        isAllSourceRequest = isAllSourceRequest ? isAllSourceRequest : false;
        handler = handler != undefined ? handler : "";
        sourceLocation = sourceLocation != undefined ? sourceLocation : "";
        this.messageId = GlobalFunctions.getGuid();
        console.log("issueService->search:", this.searchQuery);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke("search", this.searchQuery, this.messageId, isAllSourceRequest, sourceLocation);
        });
    }
};
IssueService = __decorate([
    Injectable({ providedIn: 'root' })
], IssueService);
export { IssueService };
//# sourceMappingURL=issue-service.js.map