var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { GlobalFunctions } from '../../shared/global-functions';
import { BaseService } from './base-service';
let GeoLayerService = class GeoLayerService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, cacheManager, searchService, userSettingManager, systemComponentService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.cacheManager = cacheManager;
        this.searchService = searchService;
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.test = {
            searchLayerName: ''
        };
        this.vendors = [];
        this.baseLayer = {
            selected: 'Achtergrondkaart'
        };
        this.showLayerDiv = false;
        this.anyLayerSelected = false;
    }
    init(type, selectedEntity, scope) {
        this.type = type;
        this.selectedEntity = selectedEntity;
        this.scope = scope;
    }
    plotGeoMap() {
        $("#map").empty();
        let geoCoordinatesCriteria = "";
        let geoSearchCriteria = "";
        if (this.selectedEntity) {
            if (this.type.toLowerCase() == "location" && !GlobalFunctions.isEmpty(this.selectedEntity)) {
                geoSearchCriteria = this.selectedEntity.GeoSeachCriteria;
                geoCoordinatesCriteria = this.selectedEntity.GeoCoordinatesCriteria;
            }
            else if (this.selectedEntity.Partial == false) {
                geoSearchCriteria = this.getSearchCriteriaForGeo();
                geoCoordinatesCriteria = this.getCoordinatesForGeo();
            }
            if (!GlobalFunctions.isEmpty(geoCoordinatesCriteria))
                this.plotGeoMapWithCoordinates(geoCoordinatesCriteria);
            else
                this.plotGeoMapWithSearchCriteria(geoSearchCriteria);
        }
        this.addLayersToMap();
    }
    ;
    getCoordinatesForGeo() {
        let geoCoordinates = "";
        if (this.type.toLowerCase() != 'location' && this.selectedEntity && this.selectedEntity.LocationLatitude && this.selectedEntity.LocationLatitude > 0 && this.selectedEntity.LocationLongitude && this.selectedEntity.LocationLongitude > 0)
            geoCoordinates = this.selectedEntity.LocationLatitude + ',' + this.selectedEntity.LocationLongitude;
        return geoCoordinates;
    }
    ;
    getSearchCriteriaForGeo() {
        let searchCriteria = "";
        switch (this.type.toLowerCase()) {
            case "location":
                searchCriteria = this.searchService.selectedSearchOption.searchQuery;
                break;
            case "person":
                if (this.selectedEntity && this.selectedEntity.ResidentialAddress) {
                    let addressDto = this.selectedEntity.ResidentialAddress.Address;
                    searchCriteria = this.getSearchCriteriaFromAddress(addressDto);
                }
                break;
            case "organization":
                if (this.selectedEntity && this.selectedEntity.RegistrationAddress != null && this.selectedEntity.RegistrationAddress.Address != null) {
                    let addressDto = this.selectedEntity.RegistrationAddress.Address;
                    searchCriteria = this.getSearchCriteriaFromAddress(addressDto);
                }
                break;
            case "caseentity":
                if (this.selectedEntity && this.selectedEntity.Address) {
                    let addressDto = this.selectedEntity.Address;
                    searchCriteria = this.getSearchCriteriaFromAddress(addressDto);
                }
                break;
        }
        return searchCriteria;
    }
    ;
    getSearchCriteriaFromAddress(addressDto) {
        let searchCriteria = "";
        if (addressDto != null) {
            if (!GlobalFunctions.isEmpty(addressDto.StreetName))
                searchCriteria = addressDto.StreetName + " ";
            if (!GlobalFunctions.isEmpty(addressDto.HouseNumber) && addressDto.HouseNumber != 0) {
                let houseNumber = addressDto.HouseNumber.toString();
                if (!GlobalFunctions.isEmpty(addressDto.HouseNumberAddition))
                    searchCriteria += (houseNumber + addressDto.HouseNumberAddition.toString() + ",");
                else
                    searchCriteria += houseNumber + ",";
            }
            if (!GlobalFunctions.isEmpty(addressDto.ZipCode))
                searchCriteria += addressDto.ZipCode.replace(/ /g, '');
        }
        return searchCriteria;
    }
    ;
    addLayersToMap() {
        if (this.pdokApi && this.cacheManager.geoVendors && this.cacheManager.geoVendors.length > 0) {
            this.vendors = [...this.cacheManager.geoVendors];
            for (let i = 0; i < this.vendors.length; i++) {
                this.vendors[i];
                this.scope[this.vendors[i].id + "DivModel"] = true;
                this.scope[this.vendors[i].id + "SpanModel"] = true;
                this.scope[this.vendors[i].id + "MainDivModel"] = true;
            }
        }
        this.addDataLayers();
    }
    ;
    addDataLayers() {
        let settingKey = this.type.toLowerCase() + "Layers";
        let userLayerSetting = this.userSettingManager.getUserSettingValueByKey(settingKey);
        let userLayerSettingObject;
        if (userLayerSetting)
            userLayerSettingObject = JSON.parse(userLayerSetting);
        this.baseLayer.selected = userLayerSettingObject && userLayerSettingObject["selectedBaseLayer"] ? userLayerSettingObject["selectedBaseLayer"] : this.baseLayer.selected;
        this.baseLayerClick(this.baseLayer.selected, false);
        if (userLayerSettingObject) {
            for (let id in userLayerSettingObject) {
                if (id != "selectedBaseLayer") {
                    let title = id.split("_")[0];
                    let foundVendor = jlinq.from(this.vendors).equals("title", title).select();
                    if (foundVendor && foundVendor.length > 0) {
                        for (let i = 0; i < foundVendor.length; i++) {
                            let foundLayer = jlinq.from(foundVendor[i].layers).equals("id", id).select();
                            if (foundLayer && foundLayer.length > 0) {
                                foundLayer[0].visible = true;
                                foundLayer[0].visibleInSelectedLayerPanel = true;
                                if (!this.pdokApi.isDataLayerExist(id, this.pdokApi.map)) {
                                    this.pdokApi.defaultLayers[id] = foundLayer[0];
                                    this.pdokApi.addLayers([foundLayer[0]], this.pdokApi.map);
                                }
                            }
                        }
                    }
                }
            }
            this.pdokApi.activateFeatures(this.pdokApi.map);
            this.checkAnyLayerSelected();
        }
    }
    ;
    checkAnyLayerSelected() {
        this.anyLayerSelected = false;
        for (let i = 0; i < this.vendors.length; i++) {
            let vendor = this.vendors[i];
            let isAnyLayerSelected = jlinq.from(vendor.layers).starts("visibleInSelectedLayerPanel", true).first();
            if (isAnyLayerSelected) {
                this.anyLayerSelected = true;
                break;
            }
        }
    }
    ;
    baseLayerClick(layername, doUpdate = true) {
        this.baseLayer.selected = layername;
        let layerSwitcher = this.pdokApi.map.controls[5];
        layerSwitcher.updateMap(layername, true, true);
        if (doUpdate)
            this.updateUserLayerSettings();
    }
    ;
    updateUserLayerSettings() {
        let settingKey = this.scope.type.toLowerCase() + "Layers";
        let settingValueObject = {};
        settingValueObject["selectedBaseLayer"] = this.baseLayer.selected;
        for (let i = 0; i < this.vendors.length; i++) {
            let vendor = this.vendors[i];
            let selectedLayers = jlinq.from(vendor.layers).starts("visible", true).select();
            if (selectedLayers && selectedLayers.length > 0) {
                for (let k = 0; k < selectedLayers.length; k++) {
                    let layer = selectedLayers[k];
                    settingValueObject[layer.id] = true;
                }
            }
        }
        let settingValue = JSON.stringify(settingValueObject);
        this.userSettingManager.setUserSettingValueByKey(settingKey, settingValue);
        let userSettingDto = new Object();
        userSettingDto.Key = settingKey;
        userSettingDto.Value = settingValue;
        userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
        this.systemComponentService.updateUserSetting(userSettingDto);
    }
    ;
    plotGeoMapWithCoordinates(geoCoordinatesCriteria) {
        let o = OpenLayers.Util.getParameters();
        if (o && !GlobalFunctions.isEmpty(geoCoordinatesCriteria)) {
            o.loc = geoCoordinatesCriteria;
            o.mloc = o.loc;
            o.zoom = "13";
            let m2MarkerStyle = window.location.protocol + '//' + window.location.host + '/assets/map/pdok/bag/m2.png';
            o.mimg = m2MarkerStyle;
        }
        this.pdokApi = new Pdok.Api(o);
        this.pdokApi.disablePopups();
        this.addPhotoLayer(this.pdokApi.map);
        let navigation = this.pdokApi.map.controls[2];
        navigation.handlers.wheel.deactivate();
        $('.olControlLayerSwitcher').css('z-index', '751');
        $('.olMapViewport').click(() => {
            if (!navigation.handlers.wheel.active)
                navigation.handlers.wheel.activate();
        });
        $('.olMapViewport').mouseleave(() => {
            if (navigation.handlers.wheel.active)
                navigation.handlers.wheel.deactivate();
        });
    }
    ;
    plotGeoMapWithSearchCriteria(geoSearchCriteria) {
        let o = OpenLayers.Util.getParameters();
        o.loc = "";
        o.mloc = o.loc;
        this.pdokApi = new Pdok.Api(o);
        this.pdokApi.disablePopups();
        this.addPhotoLayer(this.pdokApi.map);
        let geocoder = this.pdokApi.map.controls[4];
        geocoder.search(geoSearchCriteria);
        let navigation = this.pdokApi.map.controls[2];
        navigation.handlers.wheel.deactivate();
        $('.olControlLayerSwitcher').css('z-index', '751');
        $('.olMapViewport').click(() => {
            if (!navigation.handlers.wheel.active)
                navigation.handlers.wheel.activate();
        });
        $('.olMapViewport').mouseleave(() => {
            if (navigation.handlers.wheel.active)
                navigation.handlers.wheel.deactivate();
        });
    }
    ;
    addPhotoLayer(map) {
        let wmts = new OpenLayers.Layer.WMTS({
            name: "Luchtfoto's",
            url: "https://service.pdok.nl/hwh/luchtfotorgb/wmts/v1_0",
            layer: "Actueel_ortho25",
            matrixSet: "EPSG:28992",
            matrixIds: ['00', '01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12', '13'],
            numZoomLevels: 14,
            format: "image/jpeg",
            style: "default",
            attribution: "Kaartgegevens: Geospatial Data Service Centre",
            isBaseLayer: true
        });
        map.addLayers([wmts]);
    }
    ;
    layerFilterChange() {
        if (this.test.searchLayerName.length > 0) {
            for (let i = 0; i < this.vendors.length; i++) {
                let vendor = this.vendors[i];
                if (vendor.layers && vendor.layers.length > 0) {
                    this.scope[vendor.id + "DivModel"] = false;
                    this.scope[vendor.id + "SpanModel"] = false;
                }
                else
                    this.scope[vendor.id + "MainDivModel"] = false;
            }
        }
        else {
            for (let i = 0; i < this.vendors.length; i++) {
                let vendor = this.vendors[i];
                this.scope[vendor.id + "DivModel"] = false;
                this.scope[vendor.id + "SpanModel"] = false;
            }
        }
    }
    ;
    toggleLayer(vendorId) {
        this.scope[vendorId + "DivModel"] = !this.scope[vendorId + "DivModel"];
        this.scope[vendorId + "SpanModel"] = !this.scope[vendorId + "SpanModel"];
    }
    ;
    layerClick(layer, isChecked, isFromSelectedLayerPanel = false) {
        if (layer) {
            if (isFromSelectedLayerPanel)
                layer.visibleInSelectedLayerPanel = true;
            else
                layer.visibleInSelectedLayerPanel = isChecked;
            if (!this.pdokApi.isDataLayerExist(layer.id, this.pdokApi.map)) {
                this.pdokApi.defaultLayers[layer.id] = layer;
                this.pdokApi.addLayers([layer], this.pdokApi.map);
                if (layer.objectLayer)
                    this.pdokApi.activateFeatures(this.pdokApi.map);
            }
            let layerSwitcher = this.pdokApi.map.controls[5];
            layerSwitcher.updateMap(layer.id, isChecked);
        }
        this.checkAnyLayerSelected();
        this.updateUserLayerSettings();
    }
    ;
    toggleLayerDiv() {
        this.showLayerDiv = !this.showLayerDiv;
    }
    ;
};
GeoLayerService = __decorate([
    Injectable({ providedIn: 'root' })
], GeoLayerService);
export { GeoLayerService };
//# sourceMappingURL=geo-layer-service.js.map