var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { map } from 'rxjs/operators';
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { OperationType } from '../enums/common-enums';
import { EmployeesDepartmentEntity } from '../models/employee/employee-department-entities';
import { EmployeesManagerEntity } from '../models/employee/employee-manager-entities';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let X2JS = require('x2js');
let EmployeeService = class EmployeeService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, availabilityService, availabilityRuleService, dialog, employeeFilterPipe, removeNativeEmployeePipe) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.availabilityService = availabilityService;
        this.availabilityRuleService = availabilityRuleService;
        this.dialog = dialog;
        this.employeeFilterPipe = employeeFilterPipe;
        this.removeNativeEmployeePipe = removeNativeEmployeePipe;
        this.departments = [];
        this.managers = [];
        this.globalEventEmployeeFetchCompleted = null;
        this.isEmployeesReceived = false;
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.loggedInEmployee = null;
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.getDepartmentList = () => this.departments;
        this.getManagerList = () => this.managers;
        this.getEmployeeList = () => this.employees;
        this.getTaskMailboxList = () => this.taskMailboxes;
        this.getEmployeeIdByAvailabilityStatusResponse = this.getEmployeeIdByAvailabilityStatusResponse.bind(this);
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.employee_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_EMPLOYEE'), this.translateService, this.dialog);
                        return reject('Failed to connect to employee service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Employee service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Employee service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for employee service');
        });
    }
    clearCallbacks() {
        this.setSearchResultFound = null;
        this.setUpdateSearchStatus = null;
        this.setSearchStartedNotification = null;
        this.setSearchCompletedNotification = null;
        this.setCurrentEmployeeStatusCallback = null;
        this.setSearchAgendaFound = null;
        this.setUpdateEmployeeCompleted = null;
        this.setViewerRelatedEmployeeResultFound = null;
    }
    ;
    setRelatedResultCallback(setRelatedEmployeeResultFoundCallback, messageId) {
        this.relatedMessageId = messageId;
        this.setRelatedEmployeeResultFound = setRelatedEmployeeResultFoundCallback;
    }
    ;
    setViewerRelatedResultCallback(setViewerRelatedEmployeeResultFoundCallback, messageId) {
        this.viewerRelatedMessageId = messageId;
        this.setViewerRelatedEmployeeResultFound = setViewerRelatedEmployeeResultFoundCallback;
    }
    ;
    registerServerEvents() {
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('relatedEmployeeResultFound', (result, messageId) => {
            console.log("employeeService -> relatedEmployeeResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedEmployeeResultFound != null)
                    this.setRelatedEmployeeResultFound(result, "Employee", this.translateService.instant("LBL_EMPLOYEE"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedEmployeeResultFound != null)
                    this.setViewerRelatedEmployeeResultFound(result, "Employee", this.translateService.instant("LBL_EMPLOYEE"));
            }
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("employeeService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("employeeService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('employeeBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_EMPLOYEE'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('getEmployeeStatusResponse', message => {
            console.log("employeeService -> getEmployeeStatusResponse:", message);
            if (this.setCurrentEmployeeStatusCallback != null)
                this.setCurrentEmployeeStatusCallback(message.EmployeeStatus);
        });
        this.proxy.on('searchAgendaFound', result => {
            console.log("employeeService -> searchAgendaFound:", result);
            if (this.setSearchAgendaFound != null)
                this.setSearchAgendaFound(result);
        });
        this.proxy.on('updateEmployeeCompleted', response => {
            console.log('update employee response --> ' + response);
            if (this.setUpdateEmployeeCompleted != null)
                this.setUpdateEmployeeCompleted(response);
        });
    }
    search(searchQuery, isAllSourceRequest, alternateSearchType, sourceLocation, handler, setSearchResultFoundCallback, setUpdateSearchStatusCallback) {
        this.setSearchResultFound = setSearchResultFoundCallback;
        this.setUpdateSearchStatus = setUpdateSearchStatusCallback;
        console.log('employeeService -> search:', searchQuery);
        let result = [];
        let updateSearchStatus = new Object();
        updateSearchStatus.ActiveHandlers = [];
        if (this.setUpdateSearchStatus != null) {
            updateSearchStatus.ActiveHandlers.push("Employee");
            this.setUpdateSearchStatus(updateSearchStatus);
        }
        if (this.employees != null && this.employees.length > 0) {
            let allEmployeeList = this.employeeFilterPipe.transform(this.employees, searchQuery);
            result = this.removeNativeEmployeePipe.transform(allEmployeeList);
            result = jlinq.from(result).contains("IsDeleted", "false").select();
        }
        if (this.setSearchResultFound != null)
            this.setSearchResultFound(result);
        if (this.setUpdateSearchStatus != null) {
            updateSearchStatus.ActiveHandlers = [];
            this.setUpdateSearchStatus(updateSearchStatus);
        }
    }
    ;
    fetchEmployeesFromDatabase(completedEmployeesFetch) {
        if (this.employees == null || this.employees.length == 0) {
            this.employees = [];
            let sessionToken = GlobalFunctions.getSessionTokenAsString();
            if (sessionToken != null) {
                let url = environment.oData_config + '/Employees';
                return this.httpClient.get(url, { headers: { sessionToken } }).pipe(map((data) => {
                    console.log('callback of employee odata response');
                    if (data != null && data.length > 0 && (this.employees == null || this.employees.length == 0)) {
                        let privateFields = GlobalFunctions.getAllowedDataRights(ContentType.Employee, OperationType.PrivateField);
                        for (let index = 0; index < data.length; index++) {
                            if (data[index].Id != undefined) {
                                let employee = data[index];
                                if (!GlobalFunctions.isEmpty(employee.DepartmentId) && this.departments != null && this.departments.length > 0) {
                                    let departmentSelected = $.grep(this.departments, dept => dept.Id == employee.DepartmentId);
                                    if (departmentSelected != null && departmentSelected.length > 0) {
                                        employee.Department = new EmployeesDepartmentEntity();
                                        employee.Department.Id = departmentSelected[0].Id;
                                        employee.Department.Name = departmentSelected[0].Name;
                                        employee.Department.Email = departmentSelected[0].Email;
                                    }
                                }
                                if (!GlobalFunctions.isEmpty(employee.ManagerId) && this.managers != null && this.managers.length > 0) {
                                    let managerSelected = $.grep(this.managers, manager => manager.Id == employee.ManagerId);
                                    if (managerSelected != null && managerSelected.length > 0) {
                                        employee.Manager = new EmployeesManagerEntity();
                                        employee.Manager.Id = managerSelected[0].Id;
                                        employee.Manager.Name = managerSelected[0].Name;
                                    }
                                }
                                if (!GlobalFunctions.isEmpty(employee.SkillsJson))
                                    employee.Skills = typeof (employee.SkillsJson === String) ? JSON.parse(employee.SkillsJson) : employee.SkillsJson;
                                employee.FunctionWithDepartment = "";
                                if (employee.Department != null && !GlobalFunctions.isEmpty(employee.Department.Name) && (GlobalFunctions.isEmpty(privateFields) || privateFields.indexOf("|DEPARTMENTNAME|") === -1)) {
                                    employee.FunctionWithDepartment = employee.Department.Name;
                                }
                                if (!GlobalFunctions.isEmpty(employee.Function) && (GlobalFunctions.isEmpty(privateFields) || privateFields.indexOf("|FUNCTION|") === -1)) {
                                    if (GlobalFunctions.isEmpty(employee.FunctionWithDepartment))
                                        employee.FunctionWithDepartment = employee.Function;
                                    else
                                        employee.FunctionWithDepartment = employee.Function + ", " + employee.FunctionWithDepartment;
                                }
                                if (employee.PictureData == null || employee.PictureData == '')
                                    employee.PictureData = 'assets/images/nophoto.png';
                                else
                                    employee.PictureData = 'assets/images/employee/' + employee.PictureData;
                                this.employees.push(employee);
                            }
                            if ((index + 1) == data.length) {
                                this.isEmployeesReceived = true;
                                if (completedEmployeesFetch != null)
                                    completedEmployeesFetch();
                                if (this.globalEventEmployeeFetchCompleted != null)
                                    this.globalEventEmployeeFetchCompleted();
                            }
                        }
                    }
                }));
            }
        }
        else {
            if (completedEmployeesFetch != null)
                completedEmployeesFetch();
            return new BehaviorSubject(true);
        }
    }
    ;
    cacheLoggedInUser() {
        let employeeId = GlobalFunctions.getLoggedInUserId();
        if (!GlobalFunctions.isEmpty(employeeId) && this.loggedInEmployee == null) {
            let url = environment.oData_config + '/Employees?$filter=ID%20eq%20%27' + employeeId + '%27';
            return this.httpClient.get(url, { headers: this.getHeader() }).pipe(map(data => {
                if (data != null && data.length > 0) {
                    let employee = data[0];
                    if (!GlobalFunctions.isEmpty(employee.FirstName) && !GlobalFunctions.isEmpty(employee.Surname)) {
                        if (GlobalFunctions.isEmpty(employee.Prefix))
                            employee.LoggedInUserName = employee.FirstName + ' ' + employee.Surname;
                        else
                            employee.LoggedInUserName = employee.FirstName + ' ' + employee.Prefix + ' ' + employee.Surname;
                    }
                    else if (!GlobalFunctions.isEmpty(employee.FirstName))
                        employee.LoggedInUserName = employee.FirstName;
                    else if (!GlobalFunctions.isEmpty(employee.Surname))
                        employee.LoggedInUserName = employee.Surname;
                    if (employee.PictureData == null || employee.PictureData == '')
                        employee.PictureData = 'assets/images/nophoto.png';
                    else
                        employee.PictureData = 'assets/images/employee/' + employee.PictureData;
                    this.loggedInEmployee = employee;
                    this.loggedInEmployee.IsNative = this.loggedInEmployee.ObjectSource.indexOf('Native') != -1;
                }
            }));
        }
        else
            return new BehaviorSubject(this.loggedInEmployee);
    }
    fetchDepartments(completedDepartmentFetch) {
        if (this.departments && this.departments.length > 0) {
            if (completedDepartmentFetch != null)
                completedDepartmentFetch();
            return new BehaviorSubject(true);
        }
        this.departments = [];
        let url = environment.oData_config + '/Departments';
        return this.getData(url).pipe(map(data => {
            console.log('callback of department odata response');
            if (data != null && data.length > 0) {
                for (let index = 0; index < data.length; index++) {
                    if (data[index].Id != undefined && data[index].IsDeleted != undefined && data[index].IsDeleted == false)
                        this.departments.push(data[index]);
                    if ((index + 1) == data.length) {
                        if (completedDepartmentFetch != null)
                            completedDepartmentFetch();
                    }
                }
            }
        }));
    }
    ;
    fetchManagers(completedManagerFetch) {
        if (this.managers && this.managers.length > 0) {
            if (completedManagerFetch != null)
                completedManagerFetch();
            return;
        }
        this.managers = new Array();
        let url = environment.oData_config + '/Managers';
        return this.getData(url).pipe(map(data => {
            console.log('callback of manager odata response');
            if (data != null && data.length > 0) {
                for (let index = 0; index < data.length; index++) {
                    if (data[index].Id != undefined)
                        this.managers.push(data[index]);
                    if ((index + 1) == data.length) {
                        if (completedManagerFetch != null)
                            completedManagerFetch();
                    }
                }
            }
        }));
    }
    ;
    fetchTaskMailboxes(completedTaskMailboxesFetch) {
        this.taskMailboxes = [];
        let url = environment.oData_config + '/TaskMailboxes';
        let sessiontoken = GlobalFunctions.getSessionTokenAsString();
        if (sessiontoken != null) {
            return this.getData(url).pipe(map(data => {
                console.log('callback of task mailboxes odata response');
                if (data != null && data.length > 0) {
                    for (let index = 0; index < data.length; index++) {
                        if (data[index].Id != undefined)
                            this.taskMailboxes.push(data[index]);
                        if ((index + 1) == data.length) {
                            if (completedTaskMailboxesFetch != null)
                                completedTaskMailboxesFetch();
                        }
                    }
                }
            }));
        }
    }
    ;
    getEmployeeIdByAvailabilityStatusResponse(employeeIdList) {
        let resultedEmployee = [];
        let allEmployees = this.removeNativeEmployeePipe.transform(this.employees);
        if (!GlobalFunctions.isEmpty(employeeIdList) && !GlobalFunctions.isEmpty(allEmployees)) {
            for (let e = 0; e < allEmployees.length; e++) {
                let employee = allEmployees[e];
                let id = jlinq.from(employeeIdList).equals("EMPLOYEEID", employee.Id).select();
                if (!GlobalFunctions.isEmpty(id)) {
                    resultedEmployee.push(employee);
                }
            }
        }
        if (this.setFilteredEmployeeByAvailabilityCallback != null)
            this.setFilteredEmployeeByAvailabilityCallback(resultedEmployee);
    }
    ;
    getAllEmployeeWithAvailability(status, operator, setFilteredEmployeeByAvailabilityCompleted) {
        this.setFilteredEmployeeByAvailabilityCallback = setFilteredEmployeeByAvailabilityCompleted;
        this.availabilityService.getEmployeeIdByAvailabilityStatus(status, operator, this.getEmployeeIdByAvailabilityStatusResponse);
    }
    setEmployeeAvailability(employeeList, setEmployeeAvailabilityCompleted) {
        try {
            if (employeeList?.length > 0) {
                this.availabilityService.getAvailabilityByMultipleKey(employeeList).then(availabilityList => {
                    for (let e = 0; e < employeeList.length; e++) {
                        let employee = employeeList[e];
                        if (!employee || (!GlobalFunctions.isEmpty(employee?.IsPopular) && employee?.IsPopular))
                            continue;
                        let availabilityCollection = [];
                        if (!GlobalFunctions.isEmpty(availabilityList) && !GlobalFunctions.isEmpty(availabilityList)) {
                            for (let t = 0; t < availabilityList.length; t++) {
                                if (availabilityList[t].EmployeeAvailabilityId != null && availabilityList[t].EmployeeAvailabilityId != '' && employee.EmailAddress != null && employee.EmailAddress != '' && availabilityList[t].EmployeeAvailabilityId.toLowerCase() == employee.EmailAddress.toLowerCase())
                                    availabilityCollection.push(availabilityList[t]);
                            }
                        }
                        employee.AvailabilityStatusInfo = this.availabilityRuleService.getAvailabilityStatusInfo(availabilityCollection);
                    }
                    if (setEmployeeAvailabilityCompleted != null)
                        setEmployeeAvailabilityCompleted();
                });
            }
        }
        catch (e) {
            console.log("error " + e);
        }
    }
    getAvailabilityStatusList(availabilitySetting) {
        let availabilityStatusList = [];
        availabilityStatusList.push({
            key: "-1",
            value: this.translateService.instant("LBL_ALL_AVAILABILITY"),
            color: "orange",
            code: ""
        });
        if (!GlobalFunctions.isEmpty(availabilitySetting)) {
            let x2Js = new X2JS();
            let availabilitySettingJson = x2Js.xml2js(availabilitySetting);
            if (availabilitySettingJson != null && availabilitySettingJson.EmployeeAvailabilityStatuses != null && availabilitySettingJson.EmployeeAvailabilityStatuses.EmployeeAvailabilityStatus != null && availabilitySettingJson.EmployeeAvailabilityStatuses.EmployeeAvailabilityStatus.length > 0) {
                availabilitySettingJson.EmployeeAvailabilityStatuses.EmployeeAvailabilityStatus.forEach((employeeAvailabilityStatus) => {
                    availabilityStatusList.push({
                        key: employeeAvailabilityStatus._AvailabilityStatusIndex,
                        value: employeeAvailabilityStatus._AvailabilityStatusText,
                        color: employeeAvailabilityStatus._AvailabilityColor,
                        code: GlobalFunctions.isEmpty(employeeAvailabilityStatus._AvailabilityPhoneCode) ? "" : employeeAvailabilityStatus._AvailabilityPhoneCode
                    });
                });
            }
        }
        return availabilityStatusList;
    }
    updateEmployeeAvailabilityStatus(updateAvailabilityStatusRequest) {
        if (!GlobalFunctions.isEmpty(this.loggedInEmployee) && !GlobalFunctions.isEmpty(this.loggedInEmployee.EmailAddress)) {
            updateAvailabilityStatusRequest.UserId = GlobalFunctions.getLoggedInUserId();
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('updateEmployeeStatus', updateAvailabilityStatusRequest);
            });
        }
    }
    getEmployeeStatusByKey(currentEmployeeStatusCallback) {
        this.setCurrentEmployeeStatusCallback = currentEmployeeStatusCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('getCurrentEmployeeStatus');
        });
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Employee, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            let employeeIdList = this.getEmployeeIdList(relatedObject);
            if (employeeIdList != null && employeeIdList.length > 0) {
                let result = [];
                if (this.employees != null && this.employees.length > 0) {
                    for (let index = 0; index < employeeIdList.length; index++) {
                        let employee = jlinq.from(this.employees).equals("Id", employeeIdList[index]).select();
                        if (employee != null && employee.length > 0)
                            result.push(employee[0]);
                    }
                }
                if (this.setViewerRelatedEmployeeResultFound != null)
                    this.setViewerRelatedEmployeeResultFound(result, "Employee", this.translateService.instant("LBL_EMPLOYEE"));
            }
            //Send for manual linking if any @ server side
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Employee, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            let employeeIdList = this.getEmployeeIdList(relatedObject);
            if (employeeIdList != null && employeeIdList.length > 0) {
                let result = [];
                if (this.employees != null && this.employees.length > 0) {
                    for (let index = 0; index < employeeIdList.length; index++) {
                        let employee = jlinq.from(this.employees).equals("Id", employeeIdList[index]).select();
                        if (employee != null && employee.length > 0)
                            result.push(employee[0]);
                    }
                }
                if (this.setRelatedEmployeeResultFound != null)
                    this.setRelatedEmployeeResultFound(result, "Employee", this.translateService.instant("LBL_EMPLOYEE"));
            }
            //Send for manual linking if any @ server side
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
    getEmployeeIdList(relatedObject) {
        let employeeIdList = [];
        if (relatedObject != null && relatedObject.nativeObjectList != null && relatedObject.nativeObjectList.length > 0) {
            for (let index = 0; index < relatedObject.nativeObjectList.length; index++) {
                let searchObject = relatedObject.nativeObjectList[index];
                if (searchObject.ObjectType == "Decos.Kcs.Employees.Entities.Employee")
                    employeeIdList.push(searchObject.ObjectId);
            }
        }
        return employeeIdList;
    }
    updateEmployeeRequest(updateEmployeeRequest, updateEmpolyeeCallback, updateEmployeeErrorCallback) {
        this.setUpdateEmployeeCompleted = updateEmpolyeeCallback;
        const cookie = this.isValidToken();
        const url = environment.employee_config.replace("/signalr", "/post/PostEmployeeXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid) {
                this.httpClient.post(url, JSON.stringify(updateEmployeeRequest)).subscribe(result => {
                    console.log(result);
                }, () => {
                    if (updateEmployeeErrorCallback)
                        updateEmployeeErrorCallback();
                });
            }
        });
    }
    searchAgenda(employeeIdList, startDate, endDate, setSearchAgendaFoundCallback) {
        this.setSearchAgendaFound = setSearchAgendaFoundCallback;
        if (endDate == null)
            endDate = new Date(startDate.getFullYear(), startDate.getMonth(), startDate.getDate(), 10, 0, 0, 0);
        startDate = new Date(startDate.getFullYear(), startDate.getMonth(), startDate.getDate(), 10, 0, 0, 0);
        console.log('employeeService -> searchAgenda: start: ' + startDate + ' end: ' + endDate);
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('searchAgenda', employeeIdList, startDate, endDate);
        });
    }
    setEmployeePicture(employeeList) {
        if (employeeList?.length > 0) {
            employeeList.forEach(employeeSelected => {
                if (!GlobalFunctions.isEmpty(employeeSelected.IsPopular) && employeeSelected.IsPopular)
                    return;
                if (!employeeSelected.PictureData)
                    employeeSelected.PictureData = 'assets/images/nophoto.png';
            });
        }
    }
};
EmployeeService = __decorate([
    Injectable({ providedIn: 'root' })
], EmployeeService);
export { EmployeeService };
//# sourceMappingURL=employee-service.js.map