var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { AppConstants, BroadCastEventKeys } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { OperationType, PendingItemType } from '../enums/common-enums';
import { EntityFqdn } from '../enums/core-enums';
import { DeleteEmailRequest } from '../models/email/delete-email-request';
import { EmailCountDto } from '../models/email/email-countDto';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let X2JS = require('x2js');
let EmailService = class EmailService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, sessionManager, userService, userSettingManager, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.sessionManager = sessionManager;
        this.userService = userService;
        this.userSettingManager = userSettingManager;
        this.translateService = translateService;
        this.dialog = dialog;
        this.setMultipleFetchDetailResponse = [];
        this.uniqueId = "";
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.selectedEmailOption = "";
        this.lastSelectedEmailOption = "";
        this.selectedMailbox = "";
        this.lastSelectedMailbox = "";
        this.userMailboxPreference = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setRelatedToEmailResultFound = null;
            this.setFetchEmailAddressReceived = null;
            this.setDownalodEmailFileDocumentResultFound = null;
            this.setUpdateMemoResponse = null;
            this.setMultipleFetchDetailResponse = [];
            this.setViewerRelatedToEmailResultFound = null;
        };
        this.setRelatedResultCallback = (setRelatedToEmailResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedToEmailResultFound = setRelatedToEmailResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedToEmailResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedToEmailResultFound = setViewerRelatedToEmailResultFoundCallback;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.downloadFileDocument = (fileDocumentDto, callbackFunction) => {
            console.log('documentService->downloadFileDocument');
            this.setDownalodEmailFileDocumentResultFound = callbackFunction;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('downloadFileDocument', fileDocumentDto);
            });
        };
        this.fetchEmailAddress = (query, fetchEmailAddressReceivedCallback) => {
            this.setFetchEmailAddressReceived = fetchEmailAddressReceivedCallback;
            console.log("emailService -> fetchEmailAddress");
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchEmailAddress', query);
            });
        };
        this.fetchEmails = (query, emailSource, retrieveMyEmails, mailboxName, searchResultFoundCallback, searchStartedCallback, searchCompletedCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setSearchStartedNotification = searchStartedCallback;
            this.setSearchCompletedNotification = searchCompletedCallback;
            this.messageId = GlobalFunctions.getGuid();
            console.log('emailService -> fetchEmails:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('fetchEmails', query, emailSource, retrieveMyEmails, mailboxName, this.messageId);
            });
        };
        this.fetchDetail = (partialDto, emailDetailFoundCallback) => {
            this.setEmailDetailFound = emailDetailFoundCallback;
            console.log('emailService -> fetchDetail:', partialDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', partialDto);
            });
        };
        this.lockEmail = (emailUniqueId) => {
            console.log('emailService -> lockEmail:', emailUniqueId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('lockEmail', emailUniqueId);
            });
        };
        this.unlockEmail = (emailUniqueId) => {
            console.log('emailService -> UnlockEmail:', emailUniqueId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('unlockEmail', emailUniqueId);
            });
        };
        this.getOldestPendingEmail = (emailDetailFoundCallback, mailboxes) => {
            this.setEmailDetailFound = emailDetailFoundCallback;
            console.log('emailService -> getOldestPendingEmail:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getOldestPendingEmail', mailboxes);
            });
        };
        this.getPendingEmailsCount = () => {
            console.log('EmailService -> getPendingEmailCount:', Date.now());
            this.sessionManager.pendingCount.AllEmailsCount = "...";
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke("GetPendingItemsCount", GlobalFunctions.getLoggedInUserId());
            });
        };
        this.updateMemo = (memo, emailId, setUpdateMemoResponseCallback) => {
            this.setUpdateMemoResponse = setUpdateMemoResponseCallback;
            console.log('emailService -> update memo:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('UpdateMemo', memo, emailId);
            });
        };
        this.deleteMailRecord = (emailDto, emailDeleteResposeCallback) => {
            if (emailDto) {
                this.setEmailDeleteResposeReceived = emailDeleteResposeCallback;
                console.log('emailService -> deleting mail:', Date.now());
                let emailUniqueNumberList = [];
                emailUniqueNumberList.push(emailDto.Id);
                let deleteEmailRequest = new DeleteEmailRequest();
                deleteEmailRequest.EmailUniqueNumberList = emailUniqueNumberList;
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('DeleteEmailRequest', JSON.stringify(deleteEmailRequest));
                });
            }
        };
        this.archiveEmail = (emailDto, setArchiveEmailResponseCallback) => {
            if (emailDto) {
                this.setArchiveEmailResponse = setArchiveEmailResponseCallback;
                console.log('emailService -> archiving mail:', Date.now());
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('ArchiveEmailRequest', emailDto.Id);
                });
            }
        };
        this.assignEmail = (emailUniqueId, selectedUserId, assignEmailResponseCallback) => {
            this.assignEmailResponseReceived = assignEmailResponseCallback;
            console.log('systemComponentService -> assignEmail:', emailUniqueId, selectedUserId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('assignEmail', emailUniqueId, selectedUserId);
            });
        };
        this.linkUnlinkEntityItems = (linkEmailDto, linkUnlinkResponseCallback) => {
            console.log('Send link/unlink entity items request', Date.now());
            this.linkUnlinkEntityItemsResponse = linkUnlinkResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('LinkEmail', linkEmailDto);
            });
        };
        this.processEWSMailbox = (multipleMailboxConfigValue) => {
            if (GlobalFunctions.isEmpty(this.sessionManager.userMailboxes) || GlobalFunctions.isEmpty(this.sessionManager.pendingCount.EmailCount)) {
                this.userService.setUserMailboxes(multipleMailboxConfigValue);
                this.userSettingManager.cacheUserSetting(GlobalFunctions.getLoggedInUserId()).subscribe(() => {
                    this.userMailboxPreference = this.userSettingManager.getUserSettingValueByKey("mailboxPreference");
                    //if (GlobalFunctions.isEmpty(this.userMailboxPreference) && !GlobalFunctions.isEmpty(this.sessionManager.userMailboxes))
                    // dialogManager.OpenMailboxPreferences(true); // [TODO] - Open Mailbox prefrence in dialog
                    let mailboxesPreference;
                    if (!GlobalFunctions.isEmpty(this.userMailboxPreference))
                        mailboxesPreference = this.userMailboxPreference.split('|');
                    if (!GlobalFunctions.isEmpty(mailboxesPreference) && mailboxesPreference.length > 1 && !GlobalFunctions.isEmpty(mailboxesPreference[0])) {
                        let preferredMailboxArray = mailboxesPreference[0].split(';');
                        for (let i = 0; i < preferredMailboxArray.length; i++) {
                            for (let mailboxId = 0; mailboxId < this.sessionManager.userMailboxes.length; mailboxId++) {
                                if (this.sessionManager.userMailboxes[mailboxId].MailboxId.toUpperCase() == preferredMailboxArray[i].toUpperCase()) {
                                    this.sessionManager.userMailboxes[mailboxId].IsMarked = true;
                                    this.sessionManager.userMailboxes[mailboxId].IsDefault = this.sessionManager.userMailboxes[mailboxId].MailboxId.toUpperCase() == mailboxesPreference[1].toUpperCase();
                                    break;
                                }
                            }
                        }
                    }
                    if (!GlobalFunctions.isEmpty(multipleMailboxConfigValue)) {
                        this.updateMailboxes(multipleMailboxConfigValue);
                    }
                });
            }
            else
                this.getPendingEmailsCount();
        };
        //<<Email/Mailboxes process
        this.addEmailAndRelatedPersonOrOrganizationIntoSession = (cacheManager) => {
            this.sessionManager.addItemsToDetailViewCacheList(this.sessionManager.selectedEntity, GlobalFunctions.toString(EntityFqdn[EntityFqdn.Decos_Kcs_Email_Entities_Email]), true);
            this.sessionManager.addRelatedPersonOrOrganizationIntoSession(cacheManager);
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.email_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_EMAIL'), this.translateService, this.dialog);
                        return reject('Failed to connect to email service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Email service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Email service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for email service');
        });
    }
    registerServerEvents() {
        this.proxy.on('pendingItemCountResponse', (result) => {
            console.log("EmailService -> pendingItemCountResponse:", result);
            this.updatePendingEmailCount(result);
        });
        this.proxy.on('searchResultFound', (result, messageId) => {
            if (this.messageId == "" || this.messageId == messageId) {
                console.log("emailService -> searchResultFound:", result);
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result);
            }
        });
        this.proxy.on('updateSearchStatus', (result, messageId) => {
            console.log("emailService -> updateSearchStatus:", result);
            if (this.messageId == "" || this.messageId == messageId) {
                if (this.setUpdateSearchStatus != null)
                    this.setUpdateSearchStatus(result);
            }
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("emailService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("emailService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('tokenFailedResponse', () => {
            super.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('downloadFileDocumentResultFound', message => {
            console.log("emailService->downloadFileDocumentResultFound:", message);
            if (this.setDownalodEmailFileDocumentResultFound != null)
                this.setDownalodEmailFileDocumentResultFound(message);
        });
        this.proxy.on('emailBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_EMAIL'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('emailDetailFound', result => {
            console.log("emailService -> emailDetailFound:", result);
            if (this.setEmailDetailFound != null)
                this.setEmailDetailFound(result);
            if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0) {
                this.setMultipleFetchDetailResponse.forEach((element, index) => { this.setMultipleFetchDetailResponse[index](result); });
            }
        });
        this.proxy.on('relatedToEmailResultFound', (result, messageId) => {
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                console.log("emailService -> relatedToEmailResultFound:", result);
                if (this.setRelatedToEmailResultFound != null) {
                    if (result.ResponseEntityType.toUpperCase().indexOf("FILEDOCUMENT") != -1)
                        this.setRelatedToEmailResultFound(result.DtoList, "FileDocument", this.translateService.instant("LBL_FILE_DOCUMENT"));
                    else
                        this.setRelatedToEmailResultFound(result.DtoList, "Email", this.translateService.instant("LBL_EMAILS"));
                }
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                console.log("emailService -> relatedToEmailResultFound:", result);
                if (this.setViewerRelatedToEmailResultFound != null) {
                    if (result.ResponseEntityType.toUpperCase().indexOf("FILEDOCUMENT") != -1)
                        this.setViewerRelatedToEmailResultFound(result.DtoList, "FileDocument", this.translateService.instant("LBL_FILE_DOCUMENT"));
                    else
                        this.setViewerRelatedToEmailResultFound(result.DtoList, "Email", this.translateService.instant("LBL_EMAILS"));
                }
            }
        });
        this.proxy.on('fetchEmailAddressResponseReceived', result => {
            console.log("emailService ->  fetchEmailAddressResponseReceived", result);
            if (this.setFetchEmailAddressReceived != null)
                this.setFetchEmailAddressReceived(result);
        });
        this.proxy.on('deletedMailRecord', response => {
            console.log("emailService -> deletedMailRecord");
            if (this.setEmailDeleteResposeReceived != null)
                this.setEmailDeleteResposeReceived(response);
        });
        this.proxy.on('archiveEmailResponse', response => {
            console.log("emailService -> archiveEmailResponse");
            if (this.setArchiveEmailResponse != null)
                this.setArchiveEmailResponse(response);
        });
        this.proxy.on('assignEmailResponseReceived', result => {
            console.log("emailService -> assignEmailResponseReceived:", result);
            if (this.assignEmailResponseReceived != null)
                this.assignEmailResponseReceived(result);
        });
        this.proxy.on('linkEmailResponse', response => {
            console.log('emailService -> link email response --> ' + response);
            if (this.linkUnlinkEntityItemsResponse != null)
                this.linkUnlinkEntityItemsResponse(response);
        });
        this.proxy.on('updateMemoResponse', response => {
            console.log('emailService -> update memo response --> ' + response);
            if (this.setUpdateMemoResponse != null)
                this.setUpdateMemoResponse(response);
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_EMAIL'), this.translateService, this.dialog));
    }
    ;
    sendViewerRelatedRequest(selectedEntity, isShowNextEmailFeatureEnabled = false) {
        if (GlobalFunctions.hasRight(ContentType.Email, OperationType.View) || isShowNextEmailFeatureEnabled) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity, EntityFqdn.Decos_Kcs_Email_Entities_Email);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity, isShowNextEmailFeatureEnabled = false) {
        if (GlobalFunctions.hasRight(ContentType.Email, OperationType.View) || isShowNextEmailFeatureEnabled) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity, EntityFqdn.Decos_Kcs_Email_Entities_Email);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
    updatePendingEmailCount(response) {
        try {
            if (response) {
                console.log('pendingEmailsCountReceived', response);
                let result = response.PendingItemsCountDtoList;
                this.sessionManager.pendingCount.AllEmailsCount = response.TotalCount;
                if (result.length > 0) {
                    this.sessionManager.pendingCount.EmailCountInfo = "";
                    for (let index = 0; index < result.length; index++) {
                        if (!GlobalFunctions.isEmpty(result[index])) {
                            let item = result[index];
                            if (this.sessionManager.isEWSEnabled) {
                                if (!GlobalFunctions.isEmpty(item.ObjectSource) && !GlobalFunctions.isEmpty(this.sessionManager.pendingCount.EmailCount)) {
                                    //If multiple mailboxes
                                    for (let i = 0; i < this.sessionManager.pendingCount.EmailCount.length; i++) {
                                        if (this.sessionManager.pendingCount.EmailCount[i].MailboxId.toLowerCase() == item.ObjectSource.toLowerCase()) {
                                            if (GlobalFunctions.isEmpty(item.UserID)) {
                                                if (item.ItemType == PendingItemType.Email) {
                                                    this.sessionManager.pendingCount.EmailCount[i].InboxCount = item.Count;
                                                    if (item.Count > 0)
                                                        this.sessionManager.pendingCount.EmailCountInfo = this.sessionManager.pendingCount.EmailCountInfo + this.sessionManager.pendingCount.EmailCount[i].MailboxName + ": " + item.Count + "\n";
                                                }
                                                else
                                                    this.sessionManager.pendingCount.EmailCount[i].ArchiveCount = item.Count;
                                            }
                                            else
                                                this.sessionManager.pendingCount.EmailCount[i].MyCount = item.Count;
                                        }
                                    }
                                }
                            }
                            else {
                                //Single mailbox
                                if (GlobalFunctions.isEmpty(this.sessionManager.pendingCount.EmailCount))
                                    this.sessionManager.pendingCount.EmailCount.push(new EmailCountDto());
                                if (item.ItemType == PendingItemType.Email || item.ItemType == null) {
                                    if (item.UserID == "all")
                                        this.sessionManager.pendingCount.EmailCount[0].InboxCount = item.Count;
                                    else
                                        this.sessionManager.pendingCount.EmailCount[0].MyCount = item.Count;
                                }
                                else if (item.ItemType == PendingItemType.ArchiveEmail)
                                    this.sessionManager.pendingCount.EmailCount[0].ArchiveCount = item.Count;
                                if (GlobalFunctions.isEmpty(this.sessionManager.pendingCount.AllEmailsCount) || this.sessionManager.pendingCount.AllEmailsCount == 0)
                                    this.sessionManager.pendingCount.AllEmailsCount = this.sessionManager.pendingCount.EmailCount[0].InboxCount;
                            }
                        }
                    }
                }
                this.eventProvider.BroadcastEvent(BroadCastEventKeys.FETCH_SPECIFIC_STATISTIC, { Type: 'TOTALOPENEMAILPERMAILBOX', TotalCount: this.sessionManager.pendingCount.AllEmailsCount, TooltipText: this.sessionManager.pendingCount.EmailCountInfo });
            }
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    updateMailboxes(multipleEmailConfigValue) {
        let x2js = new X2JS();
        let jsonObj = x2js.xml2js(multipleEmailConfigValue);
        if (jsonObj != null && jsonObj.MAILBOXES != null && jsonObj.MAILBOXES.MAILBOX != null) {
            jsonObj.MAILBOXES.MAILBOX = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jsonObj.MAILBOXES.MAILBOX);
            for (let mailboxNumber = 0; mailboxNumber < jsonObj.MAILBOXES.MAILBOX.length; mailboxNumber++) {
                let mailbox = new EmailCountDto();
                mailbox.MailboxName = jsonObj.MAILBOXES.MAILBOX[mailboxNumber].MAILBOXNICENAME;
                mailbox.MailboxId = jsonObj.MAILBOXES.MAILBOX[mailboxNumber].MAILBOXLOGINNAME;
                for (let mailboxId = 0; mailboxId < this.sessionManager.userMailboxes.length; mailboxId++) {
                    if (this.sessionManager.userMailboxes[mailboxId].MailboxId.toUpperCase() == jsonObj.MAILBOXES.MAILBOX[mailboxNumber].MAILBOXLOGINNAME.toUpperCase()) {
                        mailbox.IsMarked = this.sessionManager.userMailboxes[mailboxId].IsMarked;
                        mailbox.IsDefault = this.sessionManager.userMailboxes[mailboxId].IsDefault;
                        mailbox.Id = GlobalFunctions.createGuid();
                        delete this.sessionManager.userMailboxes[mailboxId].IsDefault;
                        break;
                    }
                }
                this.sessionManager.pendingCount.EmailCount.push(mailbox);
            }
        }
        setTimeout(() => {
            this.sessionManager.pendingCount.EmailCount;
        });
        this.getPendingEmailsCount();
    }
    ;
};
EmailService = __decorate([
    Injectable({ providedIn: 'root' })
], EmailService);
export { EmailService };
//# sourceMappingURL=email-service.js.map