var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { cloneDeep } from "lodash";
import { environment } from '../../../environments/environment';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { AlternateSearchType, FieldDataType, OperationType } from '../enums/common-enums';
import { ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
let DomainService = class DomainService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, translateService, dialog) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.translateService = translateService;
        this.dialog = dialog;
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setRelatedDomainResultFound = null;
            this.setViewerRelatedDomainResultFound = null;
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.setRelatedResultCallback = (setRelatedDomainResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedDomainResultFound = setRelatedDomainResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedDomainResultFoundCallback, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedDomainResultFound = setViewerRelatedDomainResultFoundCallback;
        };
        this.createOrUpdateDomain = (domain, createOrUpdateDomainResponseHandlerCallback) => {
            this.createOrUpdateDomainResponseHandler = createOrUpdateDomainResponseHandlerCallback;
            let createOrUpdateDomainRequest = new Object();
            createOrUpdateDomainRequest.DomainDto = domain;
            let cookie = this.isValidToken();
            let url = environment.domain_config.replace("/signalr", "/post/PostDomainXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.httpClient.post(url, createOrUpdateDomainRequest).subscribe(result => {
                console.log(result);
                console.log(result);
            }, err => {
                console.log('Domains ->createOrUpdateDomain: error');
            });
        };
        this.fetchDetail = (domainId, detailHandlerCallback) => {
            this.getDetailHandlerCallback = detailHandlerCallback;
            console.log('domainService -> fetchDetail:', domainId);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', domainId);
            });
        };
        this.search = (query, isAllSourceRequest, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            isAllSourceRequest = GlobalFunctions.isEmpty(isAllSourceRequest) ? false : isAllSourceRequest;
            alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
            handler = handler != undefined ? handler : "";
            this.messageId = GlobalFunctions.getGuid();
            console.log("domainService->search:", query);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke("search", query, this.messageId, isAllSourceRequest, sourceLocation);
            });
        };
        this.advancedSearch = (searchDto, alternateSearchType, sourceLocation, handler, searchResultFoundCallback, updateSearchStatusCallback, alternateSearchResponseFoundCallback) => {
            this.setSearchResultFound = searchResultFoundCallback;
            this.setUpdateSearchStatus = updateSearchStatusCallback;
            alternateSearchType = alternateSearchType != undefined ? alternateSearchType : AlternateSearchType.None;
            handler = handler != undefined ? handler : "";
            sourceLocation = sourceLocation != undefined ? sourceLocation : "";
            this.messageId = GlobalFunctions.createGuid();
            console.log('domainService->advancedSearch:', searchDto);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('advancedSearch', searchDto, this.messageId, sourceLocation);
            });
        };
        this.initializeData = function (domainDto, screen) {
            if (domainDto != null && screen != null) {
                let fieldGroups = cloneDeep(screen.FieldGroups);
                if (!GlobalFunctions.isEmpty(fieldGroups)) {
                    fieldGroups = jlinq.from(fieldGroups).sort("Order").select();
                    for (let i = 0; i < fieldGroups.length; i++) {
                        if (!GlobalFunctions.isEmpty(fieldGroups[i].Fields)) {
                            fieldGroups[i].Fields = jlinq.from(fieldGroups[i].Fields).sort("Order").select();
                            for (let j = 0; j < fieldGroups[i].Fields.length; j++) {
                                let fieldDataItem = jlinq.from(domainDto.FieldDataList).equals("FieldId", fieldGroups[i].Fields[j].Id).first();
                                if (!GlobalFunctions.isEmpty(fieldDataItem)) {
                                    let fieldData = fieldDataItem.Data;
                                    if (fieldGroups[i].Fields[j].DataType == FieldDataType.List) {
                                        if (!GlobalFunctions.isEmpty(fieldData)) {
                                            let fieldListEntry = jlinq.from(fieldGroups[i].Fields[j].FieldList.Entries).equals("Key", fieldData).first();
                                            if (!GlobalFunctions.isEmpty(fieldListEntry))
                                                fieldGroups[i].Fields[j].Data = fieldListEntry.Key;
                                        }
                                    }
                                    else if (fieldGroups[i].Fields[j].DataType == FieldDataType.ListMultiSelect) {
                                        fieldGroups[i].Fields[j].DisplayData = [];
                                        let existingValues = !GlobalFunctions.isEmpty(fieldData) ? fieldData.split(';') : '';
                                        if (fieldGroups[i].Fields[j].FieldList && !GlobalFunctions.isEmpty(fieldGroups[i].Fields[j].FieldList.Entries)) {
                                            let entryList = fieldGroups[i].Fields[j].FieldList.Entries;
                                            for (let e = 0; e < entryList.length; e++) {
                                                if (GlobalFunctions.isStringInList(existingValues, entryList[e].Key))
                                                    fieldGroups[i].Fields[j].DisplayData.push(entryList[e]);
                                            }
                                        }
                                    }
                                    else
                                        fieldGroups[i].Fields[j].Data = fieldData;
                                }
                            }
                        }
                    }
                    domainDto.FieldGroups = fieldGroups;
                }
            }
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.domain_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_DOMAIN'), this.translateService, this.dialog);
                        return reject('Failed to connect to domain service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Domain service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Domain service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for domain service');
        });
    }
    registerServerEvents() {
        this.proxy.on('fetchDomainDetailResponse', (response) => {
            console.log("domainService -> fetchDomainDetailResponse", response);
            if (this.getDetailHandlerCallback != null) {
                this.getDetailHandlerCallback(response.DetailDto);
            }
        });
        this.proxy.on('createOrUpdateDomainResponse', (response) => {
            console.log("domainService -> createOrUpdateDomainResponse", response);
            this.updateDomainInformation(response.Domain);
            if (this.createOrUpdateDomainResponseHandler != null) {
                this.createOrUpdateDomainResponseHandler(response);
            }
        });
        this.proxy.on("searchStartedNotification", message => {
            console.log("domainService -> searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on("searchCompletedNotification", message => {
            console.log("domainService -> searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on("updateSearchStatus", (message) => {
            console.log("domainService -> updateSearchStatus:", message.MessageId);
            if (this.messageId == "" || this.messageId == message.MessageId) {
                if (this.setUpdateSearchStatus != null)
                    this.setUpdateSearchStatus(message.SearchStatus, "Domain");
            }
        });
        this.proxy.on("searchResultFound", (message) => {
            console.log("domainService -> searchResultFound:", message.MessageId);
            if (this.messageId == "" || this.messageId == message.MessageId) {
                if (this.setSearchResultFound != null) {
                    //TODO:DOMAIN - this.updateDomainHandler(result);
                    this.setSearchResultFound(message.DomainDtoList, "Domain_" + message.SubContentType);
                }
            }
        });
        this.proxy.on('relatedDomainResultFound', (message) => {
            console.log("domainService -> relatedDomainResultFound:", message.MessageId);
            if (this.relatedMessageId == "" || this.relatedMessageId == message.MessageId) {
                if (this.setRelatedDomainResultFound != null) {
                    //TODO:DOMAIN - this.updateDomainHandler(result);
                    this.setRelatedDomainResultFound(message.DtoList, "Domain_" + message.ResponseSubEntityType, message.ResponseSubEntityType);
                }
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == message.MessageId) {
                if (this.setViewerRelatedDomainResultFound != null) {
                    //TODO:DOMAIN - this.updateDomainHandler(result);
                    this.setViewerRelatedDomainResultFound(message.DtoList, "Domain_" + message.ResponseSubEntityType, message.ResponseSubEntityType);
                }
            }
        });
        this.proxy.on('domainBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_DOMAIN'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Domain, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.Domain, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
};
DomainService = __decorate([
    Injectable({ providedIn: 'root' })
], DomainService);
export { DomainService };
//# sourceMappingURL=domain-service.js.map