var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from "@angular/core";
import { MessageboxComponent } from "../../components/common/messagebox/messagebox.component";
import { PrintComponent } from "../../components/common/print/print.component";
import { GlobalFunctions } from "../../shared/global-functions";
import { DialogHelper } from "../../shared/helper/dialog-helper";
import { ContentType } from "../models/jkc-object/jkc-object";
import { CreateExportReportRequest } from "../models/report/create-export-report-request";
import { BaseService } from "./base-service";
let X2JS = require('x2js');
let ContextMenuService = class ContextMenuService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, dialog, taskService, sessionManager, employeeService, translateService, userSettingManager, contactHistoryService, applicationSettingManager, downloadService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.dialog = dialog;
        this.taskService = taskService;
        this.sessionManager = sessionManager;
        this.employeeService = employeeService;
        this.translateService = translateService;
        this.userSettingManager = userSettingManager;
        this.contactHistoryService = contactHistoryService;
        this.applicationSettingManager = applicationSettingManager;
        this.downloadService = downloadService;
        this.ignoreActionList = "PRODUCTID|ADDTICKET|SENDTOTASK|CUSTOMCONTEXTMENU";
        this.actionButtons = [];
        this.selectedIndex = 0;
        this.USERDETAILVIEWACTIONS = null;
        this.createReportResponse = this.createReportResponse.bind(this);
    }
    loadActionButton(contentType) {
        this.actionButtons = [];
        if (!GlobalFunctions.isEmpty(this.sessionManager.selectedEntity) && !GlobalFunctions.isEmpty(this.sessionManager.selectedEntity.RelatedEntityFqdn) && this.sessionManager.selectedEntity.RelatedEntityFqdn.toLowerCase().indexOf("location") > 0)
            return;
        let xmlText = this.userSettingManager.getUserSettingValueByKey("USERDETAILVIEWACTIONS");
        let relatedEntityFqdn = GlobalFunctions.getObjectTypeName(contentType);
        if (!GlobalFunctions.isEmpty(xmlText)) {
            let x2js = new X2JS();
            let jsonObj = x2js.xml2js(xmlText.toUpperCase());
            this.USERDETAILVIEWACTIONS = jsonObj;
            if (jsonObj != null && jsonObj.ROOT != null && jsonObj.ROOT.USERCONTENTTYPEOPTION != null && !GlobalFunctions.isEmpty(relatedEntityFqdn)) {
                let i;
                let actionKey;
                jsonObj.ROOT.USERCONTENTTYPEOPTION = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jsonObj.ROOT.USERCONTENTTYPEOPTION);
                for (i = 0; i < jsonObj.ROOT.USERCONTENTTYPEOPTION.length; i++) {
                    let contentType = GlobalFunctions.getObjectTypeName(jsonObj.ROOT.USERCONTENTTYPEOPTION[i]._CONTENTTYPE);
                    if (contentType.toUpperCase() == relatedEntityFqdn.toUpperCase()) {
                        this.actionButtons = [];
                        if (Array.isArray(jsonObj.ROOT.USERCONTENTTYPEOPTION[i].CONTEXTMENUOPTION)) {
                            for (let index = 0; index < jsonObj.ROOT.USERCONTENTTYPEOPTION[i].CONTEXTMENUOPTION.length; index++) {
                                actionKey = jsonObj.ROOT.USERCONTENTTYPEOPTION[i].CONTEXTMENUOPTION[index]._KEY;
                                this.addActionButton(jsonObj.ROOT.USERCONTENTTYPEOPTION[i].CONTEXTMENUOPTION[index], actionKey);
                            }
                        }
                        else if (jsonObj.ROOT.USERCONTENTTYPEOPTION[i].CONTEXTMENUOPTION != undefined) {
                            actionKey = jsonObj.ROOT.USERCONTENTTYPEOPTION[i].CONTEXTMENUOPTION._KEY;
                            this.addActionButton(jsonObj.ROOT.USERCONTENTTYPEOPTION[i].CONTEXTMENUOPTION, actionKey);
                        }
                        this.actionButtons.sort((x, y) => x._COUNT + y._COUNT);
                        this.actionButtons = this.actionButtons.slice(0, 2);
                        this.actionButtons.forEach(value => value.CONTENTTYPE = contentType);
                        break;
                    }
                }
            }
        }
        if (this.actionButtons.length == 0 || this.actionButtons.length == 1) {
            let EntityFqdn = GlobalFunctions.toEntityFqdnString(contentType);
            this.addDefaultActionsMenu(EntityFqdn);
        }
    }
    addActionButton(actionButton, actionKey) {
        if (!GlobalFunctions.isOperationExcluded(actionKey) && this.isKeyPresentInContextMenu(actionKey) && !this.isActionButtonExists(actionKey) && !this.ignoreActionList.includes(actionKey.toUpperCase()))
            this.actionButtons.push(actionButton);
    }
    isActionButtonExists(key) {
        return this.actionButtons.some(el => el._KEY === key);
    }
    isKeyPresentInContextMenu(key) {
        return this.sessionManager.contextMenu.menuItems.some(el => el.key === key);
    }
    addDefaultActionsMenu(loadedEnityContentType) {
        let xmlText = this.applicationSettingManager.getApplicationSettingValueByKey("APPLICATIONDETAILVIEWACTIONS");
        let x2js = new X2JS();
        let jsonObj = x2js.xml2js(xmlText?.toUpperCase());
        if (!GlobalFunctions.isEmpty(jsonObj) && !GlobalFunctions.isEmpty(jsonObj.ROOT) && !GlobalFunctions.isEmpty(jsonObj.ROOT.APPLICATIONCONTENTTYPE) && !GlobalFunctions.isEmpty(loadedEnityContentType)) {
            loadedEnityContentType = this.checkContentType(GlobalFunctions.toString(loadedEnityContentType));
            loadedEnityContentType = GlobalFunctions.getObjectTypeName(loadedEnityContentType);
            let i;
            let actionKey;
            jsonObj.ROOT.APPLICATIONCONTENTTYPE = GlobalFunctions.ConvertToArrayIfOnlySingleObject(jsonObj.ROOT.APPLICATIONCONTENTTYPE);
            for (i = 0; i < jsonObj.ROOT.APPLICATIONCONTENTTYPE.length; i++) {
                let contentType = GlobalFunctions.getObjectTypeName(jsonObj.ROOT.APPLICATIONCONTENTTYPE[i]._CONTENTTYPE);
                if (contentType.toUpperCase() == loadedEnityContentType.toUpperCase()) {
                    if (Array.isArray(jsonObj.ROOT.APPLICATIONCONTENTTYPE[i].DEFAULTCONTENTMENUOPTION)) {
                        for (let index = 0; index < jsonObj.ROOT.APPLICATIONCONTENTTYPE[i].DEFAULTCONTENTMENUOPTION.length; index++) {
                            actionKey = jsonObj.ROOT.APPLICATIONCONTENTTYPE[i].DEFAULTCONTENTMENUOPTION[index]._KEY;
                            this.addActionButton({ '_KEY': actionKey, '_COUNT': 1 }, actionKey);
                        }
                    }
                    else if (jsonObj.ROOT.APPLICATIONCONTENTTYPE[i].DEFAULTCONTENTMENUOPTION != undefined) {
                        actionKey = jsonObj.ROOT.APPLICATIONCONTENTTYPE[i].DEFAULTCONTENTMENUOPTION._KEY;
                        this.addActionButton({ '_KEY': actionKey, '_COUNT': 1 }, actionKey);
                    }
                    this.actionButtons.sort((x, y) => (x._COUNT + y._COUNT));
                    this.actionButtons = this.actionButtons.slice(0, 2);
                    this.actionButtons.forEach(value => value.CONTENTTYPE = contentType);
                    break;
                }
            }
        }
    }
    checkContentType(contentType) {
        let actualContentType = contentType;
        if (!GlobalFunctions.isEmpty(contentType)) {
            switch (contentType.toUpperCase()) {
                case ContentType.Appointment.toUpperCase():
                case ContentType.CallbackNote.toUpperCase():
                case ContentType.Assignment.toUpperCase():
                case ContentType.ReportImprovement.toUpperCase():
                case ContentType.InformationRequest.toUpperCase():
                    {
                        actualContentType = ContentType.Task;
                        break;
                    }
            }
        }
        return actualContentType;
    }
    ;
    sendReminder(filteredList) {
        if (GlobalFunctions.isEmpty(filteredList)) {
            let header = this.translateService.instant("LBL_TASK");
            let message = this.translateService.instant("LBL_MSG_NOT_SENDING_REMINDERS");
            DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message });
        }
        else {
            if (filteredList.length > 0) {
                let message = this.translateService.instant("LBL_MSG_SEND_REMINDERS_CONFIRMATION");
                message = GlobalFunctions.formatStringValue(message, [filteredList.length]);
                let header = this.translateService.instant("LBL_TASK");
                DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message }).afterClosed().subscribe(result => {
                    if (result) {
                        if (!GlobalFunctions.isEmpty(filteredList))
                            this.taskService.sendReminder(this.getTaskIdFromList(filteredList));
                        let header = this.translateService.instant("LBL_TASK");
                        let message = this.translateService.instant("LBL_MSG_SEND_REMINDERS");
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: header, textMsg: message });
                    }
                });
            }
        }
    }
    getTaskIdFromList(taskList) {
        let taskIdList = [];
        if (!GlobalFunctions.isEmpty(taskList)) {
            taskList.forEach(taskItem => {
                if (!GlobalFunctions.isEmpty(taskItem) && !GlobalFunctions.isEmpty(taskItem.ObjectSourceDto))
                    taskIdList.push(taskItem.ObjectSourceDto.Id);
            });
        }
        return taskIdList;
    }
    sendToReport(documentFormat, filteredList) {
        if (!GlobalFunctions.isEmpty(filteredList)) {
            DialogHelper.openDialog(this.dialog, PrintComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState)).afterClosed().subscribe(() => this.close());
            let exportReportRequest = new CreateExportReportRequest();
            exportReportRequest.DocumentFormat = documentFormat;
            exportReportRequest.SearchQuery = this.sessionManager.localSearchQuery;
            exportReportRequest.LogOnName = this.employeeService.loggedInEmployee.LoggedInUserName;
            if (this.router.url.toLowerCase().indexOf("task") > -1) {
                exportReportRequest.EntityIdList = this.getTaskIdFromList(filteredList);
                this.taskService.createReport(exportReportRequest, this.createReportResponse);
            }
            if (this.router.url.toLowerCase().indexOf("contacthistory") > -1)
                this.contactHistoryService.createReport(this.getContactHistoryIdFromList(filteredList), documentFormat, this.employeeService.loggedInEmployee.LoggedInUserName, this.sessionManager.localSearchQuery, this.createReportResponse);
        }
    }
    ;
    createReportResponse(response) {
        this.close();
        if (!GlobalFunctions.isEmpty(response) && !GlobalFunctions.isEmpty(response.DownloadTicketId)) {
            let baseUrl = this.downloadService.DOWNLOAD_API_URL.replace('{0}', response.DownloadTicketId).replace('{1}', GlobalFunctions.getSessionTokenAsString());
            if (!GlobalFunctions.isEmpty(baseUrl))
                window.open(baseUrl, "_blank");
        }
    }
    ;
    getContactHistoryIdFromList(chList) {
        let contactHistoryIdList = [];
        if (!GlobalFunctions.isEmpty(chList)) {
            chList.forEach(ch => {
                if (!GlobalFunctions.isEmpty(ch))
                    contactHistoryIdList.push(ch.Id);
            });
        }
        return contactHistoryIdList;
    }
    close(result) {
        if (this.dialog.getDialogById('PrintComponent'))
            this.dialog.getDialogById('PrintComponent').close(result);
    }
    ;
};
ContextMenuService = __decorate([
    Injectable({ providedIn: 'root' })
], ContextMenuService);
export { ContextMenuService };
//# sourceMappingURL=context-menu.service.js.map