var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { environment } from '../../../environments/environment';
import { ContactSessionNotesComponent } from '../../components/common/contact-session-notes/contact-session-notes.component';
import { MessageboxComponent } from '../../components/common/messagebox/messagebox.component';
import { AppConstants } from '../../shared/constants';
import { GlobalFunctions } from '../../shared/global-functions';
import { DialogHelper } from '../../shared/helper/dialog-helper';
import { ExceptionHelper } from '../../shared/helper/exception-helper';
import { ContactSessionNotesUIState, DateCompareType, OperationType } from '../enums/common-enums';
import { BoolCriteriaDto } from '../models/common/bool-criteriaDto';
import { DateCriteriaDto } from '../models/common/date-criteria';
import { SearchDto } from '../models/common/searchDto';
import { ContactHistoryHandlerDto } from '../models/contact-history/contact-history-handlerDto';
import { ContactHistoryObjectDto } from '../models/contact-history/contact-history-objectDto';
import { DeleteContactHistoryRequest } from '../models/contact-history/delete-contact-history-request';
import { ContactHistorySearchField, ContentType } from '../models/jkc-object/jkc-object';
import { BaseService } from './base-service';
const JsPanel = require('../../../../node_modules/jspanel4/dist/jspanel.min.js');
let ContactHistoryService = class ContactHistoryService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, dialog, sessionManager, translateService, userSettingManager, systemComponentService, applicationSettingManager) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.dialog = dialog;
        this.sessionManager = sessionManager;
        this.translateService = translateService;
        this.userSettingManager = userSettingManager;
        this.systemComponentService = systemComponentService;
        this.applicationSettingManager = applicationSettingManager;
        this.dateJS = Date;
        this.setMultipleFetchDetailResponse = [];
        this.messageId = "";
        this.relatedMessageId = "";
        this.viewerRelatedMessageId = "";
        this.clearCallbacks = () => {
            this.setSearchResultFound = null;
            this.setUpdateSearchStatus = null;
            this.setRelatedContactHistoryResultFound = null;
            this.setSearchStartedNotification = null;
            this.setSearchCompletedNotification = null;
            this.setRelatedCallbackAttemptResultFound = null;
            this.setMultipleFetchDetailResponse = [];
            this.setSearchPrivateFieldValidationResponseFound = null;
            this.setViewerRelatedContactHistoryResultFound = null;
        };
        this.setRecentHistoryCallbacks = (setSearchResultFoundCallback, setUpdateSearchStatusCallback) => {
            this.setSearchResultFound = setSearchResultFoundCallback;
            this.setUpdateSearchStatus = setUpdateSearchStatusCallback;
        };
        this.setRelatedResultCallback = (setRelatedContactHistoryResultFoundCallback, messageId) => {
            this.relatedMessageId = messageId;
            this.setRelatedContactHistoryResultFound = setRelatedContactHistoryResultFoundCallback;
        };
        this.setViewerRelatedResultCallback = (setViewerRelatedContactHistoryResultFound, messageId) => {
            this.viewerRelatedMessageId = messageId;
            this.setViewerRelatedContactHistoryResultFound = setViewerRelatedContactHistoryResultFound;
        };
        this.setSearchNotificationCallbacks = (setSearchStartedNotificationCallback, setSearchCompletedNotificationCallback) => {
            this.setSearchStartedNotification = setSearchStartedNotificationCallback;
            this.setSearchCompletedNotification = setSearchCompletedNotificationCallback;
        };
        this.setFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setFetchDetailResponse = setFetchDetailCallback;
        };
        this.setMultipleFetchDetailResponseCallback = setFetchDetailCallback => {
            this.setMultipleFetchDetailResponse.push(setFetchDetailCallback);
        };
        this.deleteContactHistory = contactHistoryDtoId => {
            if (contactHistoryDtoId) {
                console.log('contactHistoryService -> deleting contactHistory:', Date.now());
                let deleteContactHistoryRequest = new DeleteContactHistoryRequest();
                deleteContactHistoryRequest.ContactHistoryId = contactHistoryDtoId;
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('DeleteContactHistory', JSON.stringify(deleteContactHistoryRequest));
                });
            }
        };
        this.bulkDeleteContactHistory = (contactHistoryIdList, setContactHistoryDeleteCallback) => {
            if (!GlobalFunctions.isEmpty(contactHistoryIdList)) {
                this.setContactHistoryDeleteResponse = setContactHistoryDeleteCallback;
                console.log('contactHistoryService -> Bulk deleting contactHistory:', Date.now());
                let deleteContactHistoryRequest = new DeleteContactHistoryRequest();
                deleteContactHistoryRequest.ContactHistoryIdList = contactHistoryIdList;
                this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                    if (isValid)
                        this.proxy.invoke('DeleteContactHistory', JSON.stringify(deleteContactHistoryRequest));
                });
            }
        };
        this.setContactHistoryDeleteResponseReceived = (setEntityDeleteResponseReceived) => {
            this.setContactHistoryDeleteResponse = setEntityDeleteResponseReceived;
        };
        this.createContactMoment = (contactMomentDto, statusCallback) => {
            console.log('contactHistoryService->creating new contact history:', Date.now());
            let cookie = this.isValidToken();
            let url = environment.contact_history_config.replace("/signalr", "/post/PostContactHistoryXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, contactMomentDto).subscribe(() => {
                        if (statusCallback)
                            statusCallback(0);
                    }, () => {
                        if (statusCallback)
                            statusCallback(1);
                    });
                }
            });
        };
        this.setCreateContactHistoryCallback = setCreateContactHistoryCompleteCallback => {
            this.setCreateContactHistoryComplete = setCreateContactHistoryCompleteCallback;
        };
        this.getRecentContactHistories = () => {
            console.log('contactHistoryService->fetching recent contact histories:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getRecentContactHistories');
            });
        };
        this.getRecentActivities = (query) => {
            console.log('contactHistoryService->fetching recent contact activities:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('getRecentActivities', query, this.relatedMessageId);
            });
        };
        this.advancedSearch = (searchDto, avoidSearchFilterOption = false, searchPrivateFieldValidationResponseFoundCallback) => {
            this.messageId = GlobalFunctions.createGuid();
            this.setSearchPrivateFieldValidationResponseFound = searchPrivateFieldValidationResponseFoundCallback;
            console.log('advancedSearch->fetching contact histories:', Date.now());
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('advancedSearch', searchDto, avoidSearchFilterOption, this.messageId);
            });
        };
        this.search = query => {
            this.searchQuery = query;
            this.messageId = GlobalFunctions.getGuid();
            console.log('ContactHistoryService->search:', this.searchQuery);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('search', this.searchQuery, this.messageId);
            });
        };
        this.getHandlerDto = () => {
            let handlerDto = new ContactHistoryHandlerDto();
            handlerDto.UserId = GlobalFunctions.getLoggedInUserId();
            return handlerDto;
        };
        this.getContactObjects = selectAll => {
            let cachedEntities = this.sessionManager.detailViewCachedEntityList;
            let contactObjectDtoList = [];
            if (cachedEntities != null && cachedEntities.length > 0) {
                cachedEntities.forEach((value, key) => {
                    if (value != null && value.key != null && value.key != undefined) {
                        if (value.key.IsMarked || selectAll) {
                            let contactObject = new ContactHistoryObjectDto();
                            contactObject.ObjectType = value.value;
                            contactObject.ObjectId = value.key.Id;
                            contactObject.ObjectSource = value.key.ObjectSource;
                            contactObjectDtoList.push(contactObject);
                        }
                    }
                });
            }
            return contactObjectDtoList;
        };
        this.fetchDetail = partialDto => {
            let baseEntity = new Object();
            baseEntity.Id = partialDto.Id;
            baseEntity.ObjectSource = partialDto.ObjectSource;
            console.log('contactHistoryService->fetchDetail:', baseEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('FetchDetail', baseEntity);
            });
        };
        this.searchRelatedCallbackAttemptToEntity = (contentType, baseDto, messageId, setRelatedCallbackAttemptResultFoundCallback) => {
            this.setRelatedCallbackAttemptResultFound = setRelatedCallbackAttemptResultFoundCallback;
            messageId = messageId;
            console.log('contactHistoryService->searchRelatedCallbackAttemptToEntity');
            let baseEntity = new Object();
            baseEntity.Id = baseDto.Id;
            baseEntity.ObjectSource = baseDto.ObjectSource;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedCallbackAttemptToEntity', contentType, baseEntity, messageId);
            });
        };
        this.createReport = (contactHistoryIdList, documentFormat, loggedInUserName, localSearchQuery, createReportCallback) => {
            console.log('contactHistoryService -> createReport');
            this.setCreateReportResponse = createReportCallback;
            let createReportRequest = {
                EntityIdList: contactHistoryIdList,
                DocumentFormat: documentFormat,
                SearchQuery: localSearchQuery,
                LogOnName: loggedInUserName
            };
            let cookie = this.isValidToken();
            let url = environment.contact_history_config.replace("/signalr", "/post/PostCreateContactHistoryReportXDoc?SessionId=" + cookie.Id + "&UICulture=" + this.getLanguageCode() + "&connectionid=" + this.connection.id);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid) {
                    this.httpClient.post(url, createReportRequest).subscribe(result => {
                        console.log(result);
                    }, () => {
                        console.error('Error occured while creating report');
                    });
                }
            });
        };
        this.resizeContactSessionNotesBodyContent = () => {
            let newHeight = $("#contactSessionNotesPanel").height() - $("#contactSessionNotesHeader").height() - $("#contactSessionNotesFooter").height();
            $("#contactSessionNotesBody").height(newHeight + "px");
        };
        this.resizeContactSessionNotes = () => {
            let contactSessionNotesPanelElement = $("#contactSessionNotesPanel");
            switch (this.sessionManager.contactSessionNotesState.UIState) {
                case ContactSessionNotesUIState.None:
                case "0":
                case ContactSessionNotesUIState.Pinned:
                case "1":
                case ContactSessionNotesUIState.Unpinned:
                case "2":
                    if (this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen) {
                        contactSessionNotesPanelElement.css({ 'height': $(window).height() - 58 - 5 + "px" });
                        contactSessionNotesPanelElement.find(".jsPanel-content").css({ 'height': "100%" });
                        this.resizeContactSessionNotesBodyContent();
                    }
                    break;
                case ContactSessionNotesUIState.Minimize:
                case "3":
                    contactSessionNotesPanelElement.css({ 'height': "42px", 'top': ($(window).height() - 142) + "px", 'left': ($(window).width() / 2 - (contactSessionNotesPanelElement.width() / 2)) + "px" });
                    break;
            }
        };
        this.changePanelState = (ignoreLastPosition = false) => {
            if (this.sessionManager.contactSessionNotesState.UIState != ContactSessionNotesUIState.Float) {
                this.contactSessionNotesPanel.dragit('disable');
                this.contactSessionNotesPanel.resizeit('disable');
            }
            else {
                this.contactSessionNotesPanel.dragit('enable');
                this.contactSessionNotesPanel.resizeit('enable');
            }
            const contactSessionNotesPanelElement = $("#contactSessionNotesPanel");
            switch (this.sessionManager.contactSessionNotesState.UIState) {
                case ContactSessionNotesUIState.Pinned:
                case "1":
                    this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen = true;
                    contactSessionNotesPanelElement.css({ 'display': 'flex' });
                    setTimeout(() => this.setDefaultPositionAndHeightToPanel(), 10);
                    break;
                case ContactSessionNotesUIState.Unpinned:
                case "2":
                    contactSessionNotesPanelElement.css({ 'left': this.sessionManager.contactSessionNotesState.DefaultPosition.Left, 'display': "none", 'margin-left': this.sessionManager.contactSessionNotesState.DefaultPosition.LeftMargin });
                    this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen = false;
                    this.sessionManager.contactSessionNotesState.UIState = ContactSessionNotesUIState.None;
                    this.sessionManager.resetJkcPanel();
                    break;
                case ContactSessionNotesUIState.Minimize:
                case "3":
                    this.sessionManager.contactSessionNotesState.LastPosition.Left = contactSessionNotesPanelElement.offset().left + 28;
                    this.sessionManager.contactSessionNotesState.LastPosition.Top = contactSessionNotesPanelElement.offset().top - 100;
                    this.sessionManager.contactSessionNotesState.LastPosition.Height = contactSessionNotesPanelElement.height();
                    this.sessionManager.contactSessionNotesState.LastPosition.Width = contactSessionNotesPanelElement.width();
                    contactSessionNotesPanelElement.css({ 'height': "42px", 'top': ($(window).height() - 142) + "px", 'left': ($(window).width() / 2 - (contactSessionNotesPanelElement.width() / 2)) + "px" });
                    break;
                case ContactSessionNotesUIState.Float:
                case "6":
                    let height;
                    let width;
                    let windowHeight = $(window).height();
                    let leftPosition = !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.LastPosition.Left) && !ignoreLastPosition ? this.sessionManager.contactSessionNotesState.LastPosition.Left : this.sessionManager.contactSessionNotesState.DefaultPosition.Left;
                    let topPosition = !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.LastPosition.Top) && !ignoreLastPosition ? this.sessionManager.contactSessionNotesState.LastPosition.Top : this.sessionManager.contactSessionNotesState.DefaultPosition.Top;
                    if (!GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.LastPosition.Height) && this.sessionManager.contactSessionNotesState.LastPosition.Height !== 0 && !ignoreLastPosition)
                        height = this.sessionManager.contactSessionNotesState.LastPosition.Height;
                    else {
                        if (!GlobalFunctions.isEmpty(topPosition))
                            height = windowHeight - topPosition - 5 + "px";
                        else
                            height = windowHeight - contactSessionNotesPanelElement.offset().top - 5 + "px";
                    }
                    width = !GlobalFunctions.isEmpty(this.sessionManager.contactSessionNotesState.LastPosition.Width) && this.sessionManager.contactSessionNotesState.LastPosition.Width !== 0 && !ignoreLastPosition ? this.sessionManager.contactSessionNotesState.LastPosition.Width : this.sessionManager.contactSessionNotesState.DefaultPosition.Width;
                    contactSessionNotesPanelElement.css({ 'height': height, 'width': width, 'top': topPosition, 'left': leftPosition, 'transition': ".5s" });
                    if (!this.sessionManager.contactSessionNotesState.isSuggestionPanelOpen)
                        $("#contactSessionNotes").width("100%");
                    setTimeout(() => this.resizeContactSessionNotesBodyContent(), 500);
                    this.sessionManager.resetJkcPanel();
                    break;
                case ContactSessionNotesUIState.None:
                case "0":
                    this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen = false;
                    contactSessionNotesPanelElement.css({ 'display': 'none' });
                    windowHeight = $(window).height();
                    height = windowHeight - $("#contactSessionNotesHeader").height() - $("#contactSessionNotesFooter").height() - contactSessionNotesPanelElement.position().top - 5 + "px";
                    $("#contactSessionNotesBody").height(height);
                    $("#contactSessionNotes").width($(window).width() / 4 + "px");
                    contactSessionNotesPanelElement.find(".jsPanel-content").width($(window).width() / 4 + "px");
                    setTimeout(() => {
                        height = $("#contactSessionNotesHeader").height() + $("#contactSessionNotesBody").height() + $("#contactSessionNotesFooter").height() + "px";
                        contactSessionNotesPanelElement.css({ 'height': height, 'width': $(window).width() / 4 + "px", 'top': this.sessionManager.contactSessionNotesState.DefaultPosition.Top, 'left': "73%", 'transition': 'unset', 'display': 'none' });
                        contactSessionNotesPanelElement.find(".jsPanel-content").height(height);
                        this.resizeContactSessionNotesBodyContent();
                    }, 1);
                    break;
            }
        };
        this.setDefaultPositionAndHeightToPanel = () => {
            this.sessionManager.contactSessionNotesState.DefaultPosition.Left = this.sessionManager.contactSessionNotesState.isSuggestionPanelOpen ? "82%" : "75%";
            this.sessionManager.contactSessionNotesState.DefaultPosition.Width = this.sessionManager.contactSessionNotesState.isSuggestionPanelOpen ? "18%" : "25%";
            let contactSessionNotesPanelElement = $("#contactSessionNotesPanel");
            contactSessionNotesPanelElement.css({ 'top': this.sessionManager.contactSessionNotesState.DefaultPosition.Top, 'left': this.sessionManager.contactSessionNotesState.DefaultPosition.Left, 'height': $(window).height() - 58 + "px", 'width': this.sessionManager.contactSessionNotesState.DefaultPosition.Width, 'margin-left': "0px", 'transition': "unset" });
            contactSessionNotesPanelElement.find(".jsPanel-content").css({ 'height': "100%", 'width': "100%" });
            this.resizeContactSessionNotesBodyContent();
            this.sessionManager.resetJkcPanel();
        };
        this.updateContactSessionNoteUIState = () => {
            const panelStateJson = JSON.stringify({ LastPosition: this.sessionManager.contactSessionNotesState.LastPosition, State: this.sessionManager.contactSessionNotesState.UIState });
            this.userSettingManager.setUserSettingValueByKey("ContactSessionNoteUIState", panelStateJson);
            const userSettingDto = new Object();
            userSettingDto.Key = "ContactSessionNoteUIState";
            userSettingDto.Value = panelStateJson;
            userSettingDto.UserId = GlobalFunctions.getLoggedInUserId();
            this.systemComponentService.updateUserSetting(userSettingDto);
        };
        this.fetchStatistic = (fetchStatisticResponseCallback) => {
            console.log('contactHistoryService->fetchStatistic');
            this.setFetchStatisticResponse = fetchStatisticResponseCallback;
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('fetchStatistic', this.roleId);
            });
        };
        this.setDefaultUIState = () => {
            this.userSettingManager.cacheUserSetting(GlobalFunctions.getLoggedInUserId()).subscribe(() => {
                this.sessionManager.contactSessionNotesState.UIState = ContactSessionNotesUIState.None;
                let contactSessionNoteUiState = this.userSettingManager.getUserSettingValueByKey("ContactSessionNoteUIState");
                if (!GlobalFunctions.isEmpty(contactSessionNoteUiState)) {
                    if (contactSessionNoteUiState.toUpperCase() == "TRUE") {
                        this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen = true;
                        this.sessionManager.contactSessionNotesState.UIState = ContactSessionNotesUIState.Pinned;
                        this.changePanelState();
                    }
                    else if (contactSessionNoteUiState.toUpperCase() == "FALSE")
                        this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen = false;
                    else {
                        let panelState = JSON.parse(contactSessionNoteUiState);
                        if (!GlobalFunctions.isEmpty(panelState) && !GlobalFunctions.isEmpty(panelState.State)) {
                            this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen = panelState.State !== ContactSessionNotesUIState.None;
                            if (this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen)
                                $("#contactSessionNotesPanel").css({ 'display': 'flex' });
                            else
                                $("#contactSessionNotesPanel").css({ 'display': 'none' });
                            this.sessionManager.contactSessionNotesState.LastPosition = panelState.LastPosition;
                            this.sessionManager.contactSessionNotesState.UIState = panelState.State;
                        }
                        this.changePanelState();
                    }
                }
                else {
                    this.sessionManager.contactSessionNotesState.isContactSessionNotesOpen = true;
                    this.sessionManager.contactSessionNotesState.UIState = ContactSessionNotesUIState.Pinned;
                    this.changePanelState();
                }
            });
        };
    }
    connect() {
        return new Promise((resolve, reject) => {
            if (this.isConnected)
                return resolve(true);
            if (!this.isLicensed)
                return resolve(false);
            if (this.isConnecting)
                this.waitForConnection(resolve);
            const cookie = this.isValidToken();
            if (cookie) {
                if (!this.connection || this.connection.state === 4) {
                    this.isConnecting = true;
                    this.connection = $.hubConnection(environment.contact_history_config);
                    this.connection.qs = { SessionId: cookie.Id, UICulture: this.getLanguageCode() };
                    this.proxy = this.connection.createHubProxy(AppConstants.KCS_HUB);
                    this.registerServerEvents();
                    this.connection.start()
                        .done(() => {
                        this.isConnected = true;
                        this.isConnecting = false;
                        return resolve(true);
                    })
                        .fail(() => {
                        this.isConnected = false;
                        this.isConnecting = false;
                        super.serviceStopped(this.translateService.instant('LBL_CONTACT_HISTORY'), this.translateService, this.dialog);
                        return reject('Failed to connect to contact history service');
                    });
                    this.connection.disconnected(() => {
                        this.isConnected = false;
                        console.error(`Contact history service disconnected: ${this.connection.lastError}`);
                    });
                    this.connection.connectionSlow(() => {
                        this.proxy.invoke('ping');
                        console.warn(`Contact history service connection is slow: sending ping to the hub`);
                    });
                }
            }
            else
                return reject('Authentication failed for contact history service');
        });
    }
    registerServerEvents() {
        this.proxy.on('tokenFailedResponse', () => {
            this.sessionExpired(this.translateService, this.dialog);
        });
        this.proxy.on('searchResultFound', (result, messageId) => {
            if (this.messageId == "" || this.messageId == messageId) {
                console.log("contactHistoryService->searchResultFound:", result);
                if (this.setSearchResultFound != null)
                    this.setSearchResultFound(result);
            }
        });
        this.proxy.on('updateSearchStatus', result => {
            console.log("contactHistoryService->updateSearchStatus:", result);
            if (this.setUpdateSearchStatus != null)
                this.setUpdateSearchStatus(result);
        });
        this.proxy.on('relatedContactHistoryResultFound', (result, messageId) => {
            console.log("contactHistoryService->relatedContactHistoryResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedContactHistoryResultFound != null)
                    this.setRelatedContactHistoryResultFound(result, "ContactMoment", this.translateService.instant("LBL_CONTACT_HISTORIES"));
            }
            else if (this.viewerRelatedMessageId == "" || this.viewerRelatedMessageId == messageId) {
                if (this.setViewerRelatedContactHistoryResultFound != null)
                    this.setViewerRelatedContactHistoryResultFound(result, "ContactMoment", this.translateService.instant("LBL_CONTACT_HISTORIES"));
            }
        });
        this.proxy.on('relatedCallbackAttemptResultFound', (result, messageId) => {
            console.log("contactHistoryService->relatedCallbackAttemptResultFound:", result);
            if (this.relatedMessageId == "" || this.relatedMessageId == messageId) {
                if (this.setRelatedCallbackAttemptResultFound != null)
                    this.setRelatedCallbackAttemptResultFound(result, "ContactMoment", this.translateService.instant("LBL_CONTACT_HISTORIES"));
            }
        });
        this.proxy.on('deleteContacthistoryEntityResponse', response => {
            console.log('contactHistoryService -> deleteContactHistoryResponse');
            if (this.setContactHistoryDeleteResponse != null)
                this.setContactHistoryDeleteResponse(response);
        });
        this.proxy.on('contactHistoryBusinessExceptionReceived', result => {
            let exception = ExceptionHelper.create(result.InnerExceptionMessage, result.HelpText, this.translateService.instant('LBL_CONTACT_HISTORIES'));
            ExceptionHelper.showException(this.dialog, exception, true);
        });
        this.proxy.on('searchStartedNotification', (message) => {
            console.log("contactHistoryService->searchStartedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchStartedNotification != null)
                    this.setSearchStartedNotification(message);
            }
        });
        this.proxy.on('searchCompletedNotification', (message) => {
            console.log("contactHistoryService->searchCompletedNotification:", message);
            if ((this.messageId == "" && this.relatedMessageId == "") || this.messageId == message.MessageId || this.relatedMessageId == message.MessageId) {
                if (this.setSearchCompletedNotification != null)
                    this.setSearchCompletedNotification(message);
            }
        });
        this.proxy.on('detailResponse', result => {
            console.log("contactHistoryService->detailResponse:", result);
            if (this.setFetchDetailResponse != null)
                this.setFetchDetailResponse(result);
            if (this.setMultipleFetchDetailResponse != null && this.setMultipleFetchDetailResponse.length > 0) {
                this.setMultipleFetchDetailResponse.forEach((value, index) => {
                    this.setMultipleFetchDetailResponse[index](result);
                });
            }
        });
        this.proxy.on('createReportResponse', result => {
            console.log("contactHistoryService -> createReportResponse");
            if (this.setCreateReportResponse != null)
                this.setCreateReportResponse(result);
        });
        this.proxy.on('createContactHistoryResult', (result, response) => {
            console.log("Contact History -> createContactHistoryResult", result);
            if (this.setCreateContactHistoryComplete != null)
                this.setCreateContactHistoryComplete(result, response);
            else {
                let createContactHistoryResponse = JSON.parse(response);
                switch (createContactHistoryResponse.Result) {
                    case 0:
                        break;
                    case 1:
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CONTACT_HISTORY"), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_CONTACT_HISTORY") });
                        break;
                    default:
                        DialogHelper.openDialog(this.dialog, MessageboxComponent, '100%', 'auto', '50vh', DialogHelper.checkUIState(this.sessionManager.contactSessionNotesState.UIState), { messageHeader: this.translateService.instant("LBL_CONTACT_HISTORY"), textMsg: this.translateService.instant("LBL_MESSAGE_FAIL_SAVE_CONTACT_HISTORY") });
                }
            }
        });
        this.proxy.on('serviceNotRunningResult', () => super.serviceStopped(this.translateService.instant('LBL_CONTACT_HISTORY'), this.translateService, this.dialog));
        this.proxy.on('fetchContactQuestionAnswerResponse', response => {
            console.log("contactHistoryService -> fetchContactQuestionAnswerResponse");
            if (this.setFetchContactQuestionAnswer != null) {
                this.setFetchContactQuestionAnswer(response);
                this.setFetchContactQuestionAnswer = null;
            }
        });
        this.proxy.on('markDeleteStateContactHistoryResponse', response => {
            console.log('contactHistoryService -> markDeleteStateContactHistoryResponse');
            if (this.setMarkDeleteStateContactHistoryResponse != null)
                this.setMarkDeleteStateContactHistoryResponse(response);
        });
        this.proxy.on('searchPrivateFieldValidationResponse', (message) => {
            console.log("personService->searchPrivateFieldValidationResponse:", message);
            if (this.setSearchPrivateFieldValidationResponseFound != null) {
                this.setSearchPrivateFieldValidationResponseFound(message);
            }
        });
        this.proxy.on('fetchStatisticResponse', response => {
            console.log("contactHistoryService -> fetchStatisticResponse");
            if (this.setFetchStatisticResponse != null)
                this.setFetchStatisticResponse(response);
        });
    }
    sendViewerRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.ContactMoment, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.viewerRelatedMessageId);
            });
        }
    }
    ;
    sendRelatedRequest(selectedEntity) {
        if (GlobalFunctions.hasRight(ContentType.ContactMoment, OperationType.View)) {
            let relatedObject = GlobalFunctions.getRelatedObjects(selectedEntity);
            this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
                if (isValid)
                    this.proxy.invoke('searchRelatedRequest', JSON.stringify(relatedObject.mainObject), JSON.stringify(relatedObject.nativeObjectList), this.relatedMessageId);
            });
        }
    }
    ;
    fetchContactQuestionAnswerList(fetchContactQuestionAnswerCallback) {
        console.log('contactHistoryService -> fetchContactQuestionAnswerList');
        this.setFetchContactQuestionAnswer = fetchContactQuestionAnswerCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('fetchContactQuestionAnswerList');
        });
    }
    markDeleteStateContactHistory(idList, deleteState, markDeleteStateContactHistoryCallback) {
        this.setMarkDeleteStateContactHistoryResponse = markDeleteStateContactHistoryCallback;
        this.setSessionToken(this, this.translateService, this.dialog).then(isValid => {
            if (isValid)
                this.proxy.invoke('markDeleteStateContactHistory', idList, deleteState);
        });
    }
    getDuration(selectedEntity) {
        let endDate = new Date(selectedEntity.StartDate);
        let startDate = new Date(selectedEntity.EndDate);
        let millisecondsPerDay = 1000 * 60 * 60 * 24;
        let millisecondsPerHour = 1000 * 60 * 60;
        let millisecondsPerMinute = 1000 * 60;
        let millisBetween = endDate.getTime() - startDate.getTime();
        millisBetween = millisBetween < 0 ? -millisBetween : millisBetween;
        let days = 0, hours = 0, minutes = 0, seconds = 0;
        days = millisBetween / millisecondsPerDay;
        days = Math.floor(days);
        let leftMillis = millisBetween % millisecondsPerDay;
        if (leftMillis > 0) {
            hours = leftMillis / millisecondsPerHour;
            hours = Math.floor(hours);
            leftMillis = leftMillis % millisecondsPerHour;
            if (leftMillis > 0) {
                minutes = leftMillis / millisecondsPerMinute;
                minutes = Math.floor(minutes);
                leftMillis = leftMillis % millisecondsPerMinute;
                if (leftMillis > 0) {
                    seconds = leftMillis / 1000;
                    seconds = Math.floor(seconds);
                }
            }
        }
        let retValue = "";
        if (days > 0 || hours > 0 || minutes > 0 || seconds > 0) {
            retValue = this.pad(days) + ":" + this.pad(hours) + ":" + this.pad(minutes) + ":" + this.pad(seconds);
        }
        return retValue;
    }
    ;
    pad(d) {
        return (d < 10) ? '0' + d.toString() : d.toString();
    }
    ;
    getPrivacySearchDto() {
        let numberOfDays = this.applicationSettingManager.privacyPropertyList.NumberOfDaysToDeleteContactHistory;
        let searchDto = new SearchDto();
        searchDto.DateCriteriaList = [];
        let dateCriteriaDto = new DateCriteriaDto();
        dateCriteriaDto.Name = ContactHistorySearchField.StartDate;
        if (GlobalFunctions.isEmpty(numberOfDays)) {
            dateCriteriaDto.Value = new this.dateJS().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            dateCriteriaDto.CompareType = DateCompareType.GreaterThan;
        }
        else {
            let date = Date;
            dateCriteriaDto.Value = date.today().add(numberOfDays * -1).days().toString(this.sessionManager.defaultOptions.mdyyyyhhmmss);
            dateCriteriaDto.CompareType = DateCompareType.LessThanEqualsTo;
        }
        dateCriteriaDto.DisplayName = "_START_DATE_";
        searchDto.DateCriteriaList.push(dateCriteriaDto);
        let boolCriteriaDto = new BoolCriteriaDto();
        boolCriteriaDto.Name = ContactHistorySearchField.NeverDelete;
        boolCriteriaDto.Value = false;
        searchDto.BoolCriteriaList.push(boolCriteriaDto);
        return searchDto;
    }
    ;
    showContactSessionNotesPanel(viewContainerRef) {
        if (!GlobalFunctions.checkRights("ContactHistory", OperationType.Add))
            return this.sessionManager.resetJkcPanel();
        $("#contactSessionNoteContainer").empty();
        const componentRef = viewContainerRef.createComponent(ContactSessionNotesComponent);
        const element = componentRef.location.nativeElement;
        JsPanel.ziBase = 9999;
        this.contactSessionNotesPanel = JsPanel.create({
            container: '#contactSessionNoteContainer',
            id: "contactSessionNotesPanel",
            borderRadius: '5px 5px 0px 0px',
            contentOverflow: 'hidden',
            content: element,
            header: false,
            dragit: {
                opacity: 0.6,
                containment: [-47, -28, 0, 28],
                handles: '.jspanel-header',
                start: () => $("#contactSessionNotesPanel").css({ 'transition': 'unset' }),
                stop: () => {
                    if (this.sessionManager.contactSessionNotesState.UIState != "3") {
                        const contactSessionNotesPanelElement = $("#contactSessionNotesPanel");
                        this.sessionManager.contactSessionNotesState.LastPosition.Left = contactSessionNotesPanelElement.offset().left + 28;
                        this.sessionManager.contactSessionNotesState.LastPosition.Top = contactSessionNotesPanelElement.offset().top - 100;
                        this.sessionManager.contactSessionNotesState.LastPosition.Height = contactSessionNotesPanelElement.height();
                        this.sessionManager.contactSessionNotesState.LastPosition.Width = contactSessionNotesPanelElement.width();
                        this.updateContactSessionNoteUIState();
                    }
                }
            },
            resizeit: {
                containment: [-47, -28, 0, 28],
                minWidth: 255,
                handles: 'w, sw, s, se, e',
                resize: () => this.resizeContactSessionNotesBodyContent(),
                start: () => $("#contactSessionNotesPanel").css({ 'transition': 'unset' }),
                stop: () => {
                    if (this.sessionManager.contactSessionNotesState.UIState != "3") {
                        const contactSessionNotesPanelElement = $("#contactSessionNotesPanel");
                        this.sessionManager.contactSessionNotesState.LastPosition.Left = contactSessionNotesPanelElement.offset().left + 28;
                        this.sessionManager.contactSessionNotesState.LastPosition.Top = contactSessionNotesPanelElement.offset().top - 100;
                        this.sessionManager.contactSessionNotesState.LastPosition.Height = contactSessionNotesPanelElement.height();
                        this.sessionManager.contactSessionNotesState.LastPosition.Width = contactSessionNotesPanelElement.width();
                        this.updateContactSessionNoteUIState();
                    }
                }
            }
        });
        let contactSessionNotesPanelElement = $("#contactSessionNotesPanel");
        contactSessionNotesPanelElement.css({
            'width': this.sessionManager.contactSessionNotesState.DefaultPosition.Width,
            'top': this.sessionManager.contactSessionNotesState.DefaultPosition.Top,
            'left': this.sessionManager.contactSessionNotesState.DefaultPosition.Left,
            'margin-left': this.sessionManager.contactSessionNotesState.DefaultPosition.LeftMargin,
            'background-color': 'transparent'
        });
        if (!GlobalFunctions.isEmpty(contactSessionNotesPanelElement.position())) {
            let windowHeight = $(window).height();
            let newHeight = windowHeight - $("#contactSessionNotesHeader").height() - $("#contactSessionNotesFooter").height() - contactSessionNotesPanelElement.position().top - 10;
            $("#contactSessionNotesBody").height(newHeight + 'px');
        }
    }
    ;
};
ContactHistoryService = __decorate([
    Injectable({ providedIn: 'root' })
], ContactHistoryService);
export { ContactHistoryService };
//# sourceMappingURL=contact-history-service.js.map