var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { Injectable } from '@angular/core';
import { BaseService } from './base-service';
let AllSourceService = class AllSourceService extends BaseService {
    constructor(zone, router, httpClient, eventProvider, personService, organizationService, caseentityService, documentService, productService, noteService, questionAnswerService, systemComponentService, employeeService, fielService, linkService, themeService, issueService, applicationSettingManager, searchService) {
        super(zone, router, httpClient, eventProvider);
        this.zone = zone;
        this.router = router;
        this.httpClient = httpClient;
        this.eventProvider = eventProvider;
        this.personService = personService;
        this.organizationService = organizationService;
        this.caseentityService = caseentityService;
        this.documentService = documentService;
        this.productService = productService;
        this.noteService = noteService;
        this.questionAnswerService = questionAnswerService;
        this.systemComponentService = systemComponentService;
        this.employeeService = employeeService;
        this.fielService = fielService;
        this.linkService = linkService;
        this.themeService = themeService;
        this.issueService = issueService;
        this.applicationSettingManager = applicationSettingManager;
        this.searchService = searchService;
        this.sourceCount = 0;
        this.updateSearchStatus = [];
        this.searchResultFound = this.searchResultFound.bind(this);
        this.updatedSearchStatus = this.updatedSearchStatus.bind(this);
    }
    clearCallbacks() {
        this.setSearchResultFound = null;
        this.setUpdateSearchStatus = null;
    }
    ;
    updatedSearchStatus(result) {
        this.sourceCount = 0;
        this.updateSearchStatus[result.ContentType] = result.ActiveHandlers != undefined || result.ActiveHandlers != null ? result.ActiveHandlers.length : 0;
        this.updateSearchStatus.forEach((value, key) => {
            this.sourceCount = this.sourceCount + value;
        });
        if (this.setUpdateSearchStatus != null)
            this.setUpdateSearchStatus({ ActiveHandlers: Array(this.sourceCount) });
    }
    searchResultFound(result) {
        if (this.setSearchResultFound != null)
            this.setSearchResultFound(result);
    }
    setSearchResultCallbacks(setSearchResultFoundCallback, setUpdateSearchStatusCallback) {
        this.setSearchResultFound = setSearchResultFoundCallback;
        this.setUpdateSearchStatus = setUpdateSearchStatusCallback;
    }
    ;
    searchInRespectedSource(service, query) {
        try {
            service.clearCallbacks();
            service.search(query, true, null, "", null, this.searchResultFound, this.updatedSearchStatus);
        }
        catch (e) {
            console.error(e);
        }
    }
    ;
    search(query) {
        this.updateSearchStatus = [];
        if (this.searchService.isAdvancedSearch)
            query = query.match(/'([^']*)'/)?.[1] || "";
        this.searchInRespectedSource(this.personService, query);
        this.searchInRespectedSource(this.organizationService, query);
        this.searchInRespectedSource(this.caseentityService, query);
        this.searchInRespectedSource(this.documentService, query);
        this.searchInRespectedSource(this.productService, query);
        this.searchInRespectedSource(this.noteService, query);
        this.searchInRespectedSource(this.questionAnswerService, query);
        this.searchInRespectedSource(this.systemComponentService, query);
        if (this.applicationSettingManager.isEnableAllSources("Decos.Kcs.Employees.Ldap"))
            this.searchInRespectedSource(this.employeeService, query);
        this.searchInRespectedSource(this.fielService, query);
        this.searchInRespectedSource(this.themeService, query);
        this.searchInRespectedSource(this.linkService, query);
        this.searchInRespectedSource(this.issueService, query);
    }
    ;
};
AllSourceService = __decorate([
    Injectable({ providedIn: 'root' })
], AllSourceService);
export { AllSourceService };
//# sourceMappingURL=all-source-service.js.map