import { EntityFqdn, TaskSource } from '../../enums/core-enums';
import { PublishTo } from '../../enums/notes-enum';
import { CreateTaskAction, MainEntityType, SubTaskType, TaskStatus, TaskType } from '../../enums/task-enum';
import { BaseDto } from '../common/baseDto';
export class TaskDto extends BaseDto {
    constructor() {
        super(...arguments);
        this.CreatedDate = null;
        this.CreatedBy = null;
        this.CreatedById = null;
        this.MainEntityId = null;
        this.MainEntityObject = null;
        this.MainEntityType = MainEntityType.None;
        this.MainEntitySource = null;
        this.RequiredCallbackDate = null;
        this.CallBetweenStartDate = null;
        this.CallBetweenEndDate = null;
        this.ReasonForForward = null;
        this.RelatedEntityList = [];
        this.Priority = 0;
        this.CustomerQuestion = null;
        this.Result = null;
        this.ResultFreeText = null;
        this.CallbackAttemptCount = 0;
        this.CallbackAttemptDate = null;
        this.CurrentStatus = TaskStatus.None;
        this.CurrentHandlerList = [];
        this.CurrentStatusText = null;
        this.TaskHistoryList = [];
        this.MeetingRoomList = []; // remains
        this.ContactPerson = null;
        this.OrganizationName = null;
        this.ContactPhoneNumber = null;
        this.TaskType = TaskType.None;
        this.TaskTypeText = null;
        this.SubTaskType = SubTaskType.None;
        this.RelatedEntityFqdn = EntityFqdn.Decos_Kcs_Tasks_Entities_Task;
        this.TaskSource = TaskSource.Cdr;
        this.CreateTaskAction = CreateTaskAction.Direct;
        this.TaskReminderList = [];
        this.RemindersCount = 0;
        this.ReferenceNumber = 0;
        this.CustomerOrOrganizationName = null;
        this.Representative = null;
        this.ContactAddress = null;
        this.CaseNumber = null;
        this.ContactEmail = null;
        this.CustomerBSN = null;
        this.CustomerKVKNumber = null;
        this.CustomerDateOfBirth = null;
        this.SendAsAppointment = false;
        this.Tags = null;
        this.IsConfidential = false;
        this.IsMyTask = false;
        this.PublishTo = PublishTo.Myself;
        this.AttachmentList = [];
        this.RoleId = null;
        this.PriorityText = null;
    }
}
//# sourceMappingURL=taskDto.js.map